#TITLE=MessageBuilder
; EditPlus cliptext file v1.0 written by Mohib Miah.
; This file is provided as a default cliptext file for MessageBuilder.

#CASE=n

#T=Reserved Variable $error
$error
#T=Reserved Variable $LogString
$LogString
#T=Reserved Variable $SqlCode
$SqlCode
#T=Reserved Variable $DateFormat
$DateFormat
#T=Reserved Variable $EdiSegSep
$EdiSegSep
#T=Reserved Variable $EdiSegCodeSep
$EdiSegCodeSep
#T=Reserved Variable $EdiElemSep
$EdiElemSep
#T=Reserved Variable $EdiCompSep
$EdiCompSep
#T=Reserved Variable $EdiRelChar
$EdiRelChar
#T=Reserved Variable $EdiPadChar
$EdiPadChar
#T=Reserved Variable $EdiSegCnt
$EdiSegCnt
#T=Reserved Variable $EdiElemCnt
$EdiElemCnt
#T=Reserved Variable $EdiCompCnt
$EdiCompCnt

#T=Reserved Word IF
IF ^! {;}
#T=Reserved Word else
ELSE {^!;}
#T=Reserved Word while
WHILE ^!
{
	
}
#T=Reserved Word for
FOR $i = 1 TO ^! 
{

}
#T=Reserved Word print
PRINT "^!";
#T=Reserved Word printerr
PRINTERR "^!";
#T=Reserved Word log
LOG "^!" TYPE "DEBUG";
#T=TraceDebug
TraceDebug "^!";
#T=Reserved Word log ERROR
LOG "^!" TYPE "ERROR";
#T=Reserved Word log INFO
LOG "^!" TYPE "INFO";
#T=Reserved Word log WARNING
LOG "^!" TYPE "WARNING";
#T=Reserved Word log FATAL
LOG "^!" TYPE "FATAL";
#T=Reserved Word case
CASE ^!
WHEN 
{
	
}
WHEN OTHERS
{
	LOG "Unknown item!" TYPE "ERROR";
}
#T=Reserved Word repeat
REPEAT
{
	
}
WHILE ^!;
#T=Reserved Word try
TRY
{
    ^!
}
CATCH $exception
WHEN OTHERS
{
	LOG "Error in Program: Exception=" & $exception TYPE "ERROR";
}

#T=EXEC SQL Select
EXEC SQL DBID ^!$dbid SELECT [ALL | DISTINCT] select-list
	INTO variable-list
	FROM table-list
	WHERE sql-search
	GROUP BY group-list
	HAVING sql-search
	ORDER BY order-by-list
	{ };

#T=EXEC SQL Insert
EXEC SQL DBID $dbid 
INSERT INTO ^! 
()
VALUES ()
WHERE ;
#T=EXEC SQL Update
EXEC SQL DBID $dbid 
UPDATE ^! 
SET 
WHERE ;
#T=EXEC SQL Revoke
EXEC SQL DBID $dbid REVOKE
{ALL [PRIVILEGES] | revoke-privilege [, revoke-privilege] ... }
ON table-name
FROM {PUBLIC | user-name [, user-name] ... }
[CASCADE | RESTRICT];
#T=EXEC SQL Grant
EXEC SQL DBID $dbid GRANT {ALL [PRIVILEGES] | grant-privilege [, grant-privilege] ... }
ON table-name
TO {PUBLIC | user-name [, user-name] ... }
[WITH GRANT OPTION];
#T=EXEC SQL Delete
EXEC SQL DBID $dbid DELETE FROM table-name
[WHERE search-condition];
#T=EXEC SQL Create Table
EXEC SQL DBID $dbid CREATE TABLE base-table-name
(column-identifier data-type [NOT NULL]
[, column-identifier data-type [NOT NULL]] ... );
#T=EXEC SQL Create Index
EXEC SQL DBID $dbid CREATE [UNIQUE] INDEX index-name
ON base-table-name
(column-identifier [ASC | DESC] [, column-identifier [ASC | DESC]] ... );
#T=EXEC SQL Alter Table
EXEC SQL DBID $dbid ALTER TABLE base-table-name
{ADD column-identifier data-type |
ADD (column-identifier data-type [, column-identifier data-type] ... ) };
#T=EXEC SQL Create View
EXEC SQL DBID $dbid CREATE VIEW viewed-table-name
[(column-identifier [, column-identifier] ... )]
AS query-specification [WITH CHECK OPTION];
#T=EXEC SQL Drop View
EXEC SQL DBID $dbid DROP VIEW viewed-table-name
[CASCADE | RESTRICT];
#T=EXEC SQL Drop Index
EXEC SQL DBID $dbid DROP INDEX index-name;
#T=EXEC SQL Drop Table
EXEC SQL DBID $dbid DROP TABLE base-table-name [CASCADE | RESTRICT];
#T=EXEC SQL Begin Work
EXEC SQL DBID $dbid BEGIN WORK;
#T=EXEC SQL Commit Work
EXEC SQL DBID $dbid COMMIT WORK;
#T=EXEC SQL Rollback Work
EXEC SQL DBID $dbid ROLLBACK WORK;

#T=Reserved Word ArraySize
ARRAYSIZE(^!)
#T=sysinfo
CASE System()
WHEN $system_Posix , $SYSTEM_OS400 
{
	$Sep = "/";
}
WHEN $system_Win32 
{
	$Sep = "\\";
}
WHEN OTHERS
{
	LOG "System Not Supported" TYPE "ERROR";
}
#T=comment header
/*---------------------------------------------------------------------------------------
@NAME	^!
@SYNTAX
@DESC		
@END   
 *---------------------------------------------------------------------------------------*/
#T=DATAIO.AttachFile
DATAIO.AttachFile handle FILEPATH file-path [START start] [LENGTH length];
#T=DATAIO.AttachFilerFile
DATAIO.AttachFilerFile handle ROOTNAME root-name FILENAME file-name
			[START start] [LENGTH length]
#T=DATAIO.AttachString
DATAIO.AttachString handle STRING string [START start] [LENGTH length]
#T=DATAIO.CloseInput
DATAIO.CloseInput handle;
#T=DATAIO.CloseOutput
DATAIO.CloseOutput handle;
#T=DATAIO.Copy
DATAIO.Copy(handle [, start [, length]])
#T=DATAIO.CreateFile
DATAIO.CreateFile handle FILEPATH file-path;
#T=DATAIO.CreateFilerFile
DATAIO.CreateFilerFile handle ROOTNAME root-name;
#T=DATAIO.CreateString
DATAIO.CreateString handle;
#T=DATAIO.Delete
DATAIO.Delete handle;
#T=DATAIO.FromPackedHandle
DATAIO.FromPackedHandle(packed-handle)
#T=DATAIO.GetInputPosition
DATAIO.GetInputPosition (handle)
#T=DATAIO.GetLength
DATAIO.GetLength (handle)
#T=DATAIO.GetRealFileName
DATAIO.GetRealFileName (handle)
#T=DATAIO.GetType
DATAIO.GetType (handle)
#T=DATAIO.OpenInput
DATAIO.OpenInput handle;
#T=DATAIO.OpenOutput
DATAIO.OpenOutput handle;
#T=DATAIO.ReadInput
DATAIO.ReadInput handle [COUNT count] [UNTIL until] DATA data;
#T=DATAIO.SetInputPosition
DATAIO.SetInputPosition handle [WHENCE whence] [OFFSET offset];
#T=DATAIO.ToPackedHandle
DATAIO.ToPackedHandle(handle)
#T=DATAIO.WriteOutput
DATAIO.WriteOutput handle DATA data;
#T=User Function
DECLARE FUNCTION ^! ()
{

	RETURN $;
}
#T=User Statement
DECLARE STATEMENT ^! IN
{

	RETURN;
}
#T=User Function Public
DECLARE PUBLIC FUNCTION ^! ()
{

	RETURN $;
}
#T=User Statement Public
DECLARE PUBLIC STATEMENT ^! IN
{

	RETURN;
}
#T=Reserved Word declare
DECLARE $^!
#T=Reserved Word integer
INTEGER;

#T=Reserved Word string
STRING;

#T=Reserved Word float
FLOAT;

#T=Reserved Word date
DATE;

#T=declare TraceDebug Statement
DECLARE STATEMENT TraceDebug IN $txt
{
	IF $gDebug 
	{
		LOG $txt TYPE "DEBUG";
	}
	RETURN;
}
#T=declare Module
DECLARE MODULE ^!  {

DECLARE $mDebug = 0	INTEGER;

/*--------------------------------------------------------------------
 * Version
 *--------------------------------------------------------------------*/
DECLARE PUBLIC FUNCTION Version() 
{
	RETURN SOURCEMODULE() & " Version 1.0.0";
}

/*--------------------------------------------------------------------
 * MODULE_INIT
 *--------------------------------------------------------------------*/
DECLARE STATEMENT MODULE_INIT 
{

	RETURN;
}

/*--------------------------------------------------------------------
 * SetDebug
 *--------------------------------------------------------------------*/
DECLARE PUBLIC STATEMENT SetDebug IN $int
{
	$mDebug = $int;
	TraceDebug SOURCEMODULE() & " Started in debug mode";
	RETURN;
}

/*--------------------------------------------------------------------
 * TraceDebug
 *--------------------------------------------------------------------*/
DECLARE STATEMENT TraceDebug IN $txt
{
	IF $mDebug
	{
		LOG $txt TYPE "DEBUG";
	}
	RETURN;
}

/*--------------------------------------------------------------------
 * MODULE_CLEAN
 *--------------------------------------------------------------------*/
DECLARE STATEMENT MODULE_CLEAN
{
	
	RETURN;
}

} # End Module

#T=declare public field
DECLARE PUBLIC FIELD $^! STRING;
#T=declare field
DECLARE FIELD $^! STRING;
#T=declare record
DECLARE RECORD ^! {
	
}
#T=declare record public
DECLARE PUBLIC RECORD ^! {
	
}
#T=Reserved Word strmid
STRMID($^!,,)
#T=Reserved Word $error_ReadEndOfFile
$error_ReadEndOfFile
#T=Reserved Word SourceFile
SOURCEFILE()
#T=Reserved Word SourseLine
SOURCELINE()
#T=Reserved Word SourceModule
SOURCEMODULE()
#T=Reserved Word SourceProcedure
SOURCEPROCEDURE()
#T=Reserved Word unique_id
UNIQUE_ID("IntLogRef^!")
#T=Reserved Word use
USE {FUNCTION | STATEMENT} ^! FROM pgm name AS name;
#T=Expand Environment Variables
SL_ENVIRON.ExpandEnvironmentVariables(^!);
#T=Directory Separator
SL_FILEIO.DirectorySeparator() ^!
#T=Standard Library Argument function
^!INCLUDE "sl_argument.s4h";

DECLARE $opt		STRING;
DECLARE $argument	STRING;

WHILE 1 
{
	TRY 
	{
		SL_ARGUMENT.GetOption   "Va:" 
				OPTION	 $opt 
				ARGUMENT $argument;
		CASE $opt
		WHEN "" 
		{
			BREAK; /* no more options */
		}
		WHEN "V" 
		{
			PRINT "Got V option\n";
		}
		WHEN "a" 
		{
			PRINT "Got a option, argument = " & $argument & "\n";
		}
	}
	CATCH $exception
	WHEN SL_ARGUMENT.$ExceptionName 
	{
		IF $Error = SL_ARGUMENT.$Error_GetOption_IllegalOption 
		{
			PRINTERR "found illegal option\n";
		}
		ELSE 
		{
			PRINTERR "missing option argument\n";
		}
		
		EXIT 1;
	}
}

#T=declare MID function
DECLARE PUBLIC FUNCTION Mid($str,$n,$m)
{
    declare $i integer;
    declare $num integer;
    declare $ntmp integer;
    declare $mtmp integer;
    declare $retstr string;
    
    $retstr = "";
    $num = STRLEN($str);
    $ntmp = $n;
    $mtmp = $m;
    
    if $ntmp<1 {$ntmp=1;}
    if $mtmp>$num {$mtmp=$num;}
    if $ntmp>$mtmp {return $retstr;}

    $retstr = STRMID($str,$ntmp,$mtmp);

    return $retstr;
} 

#T=HME.Abort
MBC_HIERCHMSGENV.Abort;
#T=HME.AbortSession
MBC_HIERCHMSGENV.AbortSession session-id;
#T=HME.ActivateLoggerEntry
MBC_HIERCHMSGENV.ActivateLoggerEntry session-id LoggerId logger-id;
#T=HME.Alert
MBC_HIERCHMSGENV.Alert type Code code Severity severity Description description Data data;
#T=HME.AttachData
MBC_HIERCHMSGENV.AttachData session-id MessageId message-id Data data;
#T=HME.CancelWait
MBC_HIERCHMSGENV.CancelWait coroutine-id;
#T=HME.CloseInput
MBC_HIERCHMSGENV.CloseInput input-id;
#T=HME.CloseOutput
MBC_HIERCHMSGENV.CloseOutput output-id;
#T=HME.CorrelationDelete
MBC_HIERCHMSGENV.CorrelationDelete key Callback callback UserData user-data;
#T=HME.CorrelationRead
MBC_HIERCHMSGENV.CorrelationRead key Callback callback UserData user-data;
#T=HME.CorrelationWrite
MBC_HIERCHMSGENV.CorrelationWrite key
		Data		data
		Callback	callback
		UserData	user-data;
#T=HME.CreateLoggerEvent
MBC_HIERCHMSGENV.CreateLoggerEvent session-id 
		LoggerId	logger-id 
		Event		event;
#T=HME.CreateMessage
MBC_HIERCHMSGENV.CreateMessage(session-id, message-id, data-type)
#T=HME.CreateMessageCopy
MBC_HIERCHMSGENV.CreateMessageCopy(session-id, message-id)
#T=HME.CreateSession
MBC_HIERCHMSGENV.CreateSession(data)
#T=HME.CreateSessionMessage
MBC_HIERCHMSGENV.CreateSessionMessage(session-id, message-id, start, length)
#T=HME.CreateSyncpoint
MBC_HIERCHMSGENV.CreateSyncpoint session-id;
#T=HME.DestroyMessage
MBC_HIERCHMSGENV.DestroyMessage session-id MessageId message-id;
#T=HME.EndSession
MBC_HIERCHMSGENV.EndSession session-id;
#T=HME.GetActivityBranch
MBC_HIERCHMSGENV.GetActivityBranch(session-id, message-id)
#T=HME.GetAttribute
MBC_HIERCHMSGENV.GetAttribute(session-id, message-id, name)
#T=HME.GetAttributeNames
MBC_HIERCHMSGENV.GetAttributeNames(session-id, message-id)
#T=HME.GetData
MBC_HIERCHMSGENV.GetData(session-id, message-id)
#T=HME.GetLoggerId
MBC_HIERCHMSGENV.GetLoggerId(session-id, message-id)
#T=HME.GetMessages
MBC_HIERCHMSGENV.GetMessages(session-id, message-id)
#T=HME.GetMessageStatus
MBC_HIERCHMSGENV.GetMessageStatus(session-id, message-id)
#T=HME.GetOwnerMessage
MBC_HIERCHMSGENV.GetOwnerMessage(session-id, message-id)
#T=HME.GetPriority
MBC_HIERCHMSGENV.GetPriority (session-id, message-id)
#T=HME.GetParentMessage
MBC_HIERCHMSGENV.GetParentMessage(session-id, message-id)
#T=HME.GetprocessExitStatus
MBC_HIERCHMSGENV.GetprocessExitStatus(process-id)
#T=HME.GetprocessExitStatus
MBC_HIERCHMSGENV.GetprocessExitStatus(process-id)
#T=HME.GetRootMessage
MBC_HIERCHMSGENV.GetRootMessage(session-id)
#T=HME.GetSessionMessages
MBC_HIERCHMSGENV.GetSessionMessages(session-id, message-id)
#T=HME.GetSessionStatus
MBC_HIERCHMSGENV.GetSessionStatus(session-id)
#T=HME.HoldSession
MBC_HIERCHMSGENV.HoldSession(session-id)
#T=HME.InactivateLoggerEntry
MBC_HIERCHMSGENV.InactivateLoggerEntry session-id LoggerId logger-id;
#T=HME.LookupProperties
MBC_HIERCHMSGENV.LookupProperties (activity-branch-id, property-name, property-value)
#T=HME.LookupPropertiesFirst
MBC_HIERCHMSGENV.LookupPropertiesFirst activity-branch-id
			Name		property-name
			Value		property-value
			Handle		handle
			Properties	properties;
#T=HME.LookupPropertiesNext
MBC_HIERCHMSGENV.LookupPropertiesNext handle Properties properties
#T=HME.OpenInput
MBC_HIERCHMSGENV.OpenInput(session-id, message-id)
#T=HME.OpenOutput
MBC_HIERCHMSGENV.OpenOutput(session-id, message-id[, append])
#T=HME.ProcessMessageDone
MBC_HIERCHMSGENV.ProcessMessageDone session-id MessageId message-id;
#T=HME.ReleaseSession
MBC_HIERCHMSGENV.ReleaseSession session-id HoldId hold-id;
#T=HME.SentinelGetIdentifier
MBC_HIERCHMSGENV.SentinelGetIdentifier		session-id
		MessageId			message-id
		TrackedObject_ObjectName	trackedobject-objectname
		TrackedObject_Identity		trackedobject-identity
		[TrackedObject_UserObjectId	trackedobject-userobjectid];
#T=HME.SentinelSetIdentifier
MBC_HIERCHMSGENV.SentinelSetIdentifier		session-id
		MessageId			message-id
		TrackedObject_ObjectName	trackedobject-objectname
		TrackedObject_Identity		trackedobject-identity
		[TrackedObject_UserObjectId	trackedobject-userobjectid];
#T=HME.SentinelCreateTrackedObject
MBC_HIERCHMSGENV.SentinelCreateTrackedObject	session-id
		TrackedObject_ObjectName	trackedobject-objectname
		TrackedObject_ObjectVersion	trackedobject-objectversion
		TrackedObject_Identity		trackedobject-identity
		[TrackedObject_UserObjectId	trackedobject-userobjectid]
		[TrackedObject_UserParentId	trackedobject-userparentid]
		[TrackedObject_UserChildIds	trackedobject-userchildids]
		[IsEnd				is-end]
		[IsException			is-exception]
		[IsAlert			is-alert]
		State				state
		Attributes			attributes;
#T=HME.SentinelCreateCycleLink
MBC_HIERCHMSGENV.SentinelCreateCycleLink	session-id
		TrackedObject_ObjectName	trackedobject-objectname
		TrackedObject_Identity		trackedobject-identity
		ParentTrackedObject_ObjectName	parenttrackedobject-objectname
		ParentTrackedObject_Identity	parenttrackedobject-identity;
#T=HME.SessionEndAdd
MBC_HIERCHMSGENV.SessionEndAdd session-id Callback callback UserData user-data;
#T=HME.SessionEndDone
MBC_HIERCHMSGENV.SessionEndDone session-id CallbackId callback-id Status status;
#T=HME.SetActivityBranch
MBC_HIERCHMSGENV.SetActivityBranch session-id MessageId message-id ActivityBranchId activity-branch-id;
#T=HME.SetAttribute
MBC_HIERCHMSGENV.SetAttribute session-id MessageId message-id Name name Value value;
#T=HME.SetLoggerId
MBC_HIERCHMSGENV.SetLoggerId session-id MessageId message-id LoggerId logger-id;
#T=HME.SetPriority
MBC_HIERCHMSGENV.SetPriority session-id MessageId message-id Priority priority;
#T=HME.SocketReadAdd
MBC_HIERCHMSGENV.SocketReadAdd socket Callback callback Data data;
#T=HME.SocketReadRemove
MBC_HIERCHMSGENV.SocketReadRemove socket;
#T=HME.SocketWriteAdd
MBC_HIERCHMSGENV.SocketWriteAdd socket Callback callback Data data;
#T=HME.SocketWriteRemove
MBC_HIERCHMSGENV.SocketWriteRemove socket;
#T=HME.StartSession
MBC_HIERCHMSGENV.StartSession session-id;
#T=HME.StopMessage
MBC_HIERCHMSGENV.StopMessage session-id MessageId message-id;
#T=HME.TimeoutAdd
MBC_HIERCHMSGENV.TimeoutAdd(timeout, callback, data)
#T=HME.TimeoutRemove
MBC_HIERCHMSGENV.TimeoutRemove id;
#T=HME.TimerAdd
MBC_HIERCHMSGENV.TimerAdd timeout
	Qualifier	qualifier
	Id		id
	Callback	callback
	UserData	user-data;
#T=HME.TimerRemove
MBC_HIERCHMSGENV.TimerRemove qualifier Id id;
#T=HME.Wait
MBC_HIERCHMSGENV.Wait	timeout
	[SocketRead	socket-read]
	[SocketWrite	socket-write]
	[ProcessIds	process-ids]
	[Type		type]
	[Id		id];

#T=DIR_CHANGE
DIR_CHANGE dir-name;
#T=DIR_CLOSE
DIR_CLOSE dir-id;
#T=DIR_CREATE
DIR_CREATE dir-name;
#T=DIR_ERROR
DIR_ERROR()
#T=DIR_OPEN
DIR_OPEN([dir-name])
#T=DIR_READ
DIR_READ(dir-id)
#T=DIR_REMOVE
DIR_REMOVE dir-name;
#T=DIR_REWIND
DIR_REWIND dir-id;
#T=DIR_VERSION
DIR_VERSION()

#T=PROCESS.KILL
PROCESS.KILL pid [SIGNAL signal];
#T=PROCESS.START
PROCESS.START(arguments [, stdin [, stdout [, stderr]]])
#T=PROCESS.STARTCOMMAND
PROCESS.STARTCOMMAND(command [, stdin [, stdout [, stderr]]])
#T=PROCESS.VERSION
PROCESS.VERSION()
#T=PROCESS.WAIT 
PROCESS.WAIT wait-pids PID pid [EXITSTATUS exit-status][WAIT timeout];

#T=RAW_CLOSE
RAW_CLOSE file-id;
#T=RAW_ERROR
RAW_ERROR()
#T=RAW_FLUSH
RAW_FLUSH file-id;
#T=RAW_OPEN
RAW_OPEN(file-name[, open-type])
#T=RAW_READ
RAW_READ(file-id, count)
#T=RAW_SEEK
RAW_SEEK file-id [OFFSET offset] [WHENCE whence];
#T=RAW_SYNCHRONIZE
RAW_SYNCHRONIZE file-id;
#T=RAW_TELL
RAW_TELL(file-id)
#T=RAW_TEMPORARY
RAW_TEMPORARY([dir])
#T=RAW_VERSION
RAW_VERSION()
#T=RAW_WRITE
RAW_WRITE file-id DATA data;

#T=REGISTER.CHECKSOCKET
REGISTER.CHECKSOCKET(sock-desc)
#T=REGISTER.CHILDEXITDISABLE
REGISTER.CHILDEXITDISABLE;
#T=REGISTER.CHILDEXITENABLE
REGISTER.CHILDEXITENABLE;
#T=REGISTER.ERROR
REGISTER.ERROR()
#T=REGISTER.READADD 
REGISTER.READADD sock-desc [EXTRAID extra-id];
#T=REGISTER.READCLEAR
REGISTER.READCLEAR;
#T=REGISTER.READREMOVE 
REGISTER.READREMOVE sock-desc;
#T=REGISTER.SECONDS
REGISTER.SECONDS()
#T=REGISTER.TIMEOUTADD
REGISTER.TIMEOUTADD(timeout[, extra-id]);
#T=REGISTER.TIMEOUTCLEAR
REGISTER.TIMEOUTCLEAR;
#T=REGISTER.TIMEOUTREMOVE 
REGISTER.TIMEOUTREMOVE timeout-id;
#T=REGISTER.VERSION
REGISTER.VERSION()
#T=REGISTER.WAIT 
REGISTER.WAIT [type [ID id] [EXTRAID extra-id]];
#T=REGISTER.WRITEADD
REGISTER.WRITEADD sock-desc [EXTRAID extra-id];
#T=REGISTER.WRITECLEAR
REGISTER.WRITECLEAR;
#T=REGISTER.WRITEREMOVE
REGISTER.WRITEREMOVE sock-desc;

#T=SOCKET.ACCEPT
SOCKET.ACCEPT(listen-socket);
#T=SOCKET.CONNECT
SOCKET.CONNECT(host, service);
#T=SOCKET.DISCONNECT 
SOCKET.DISCONNECT socket;
#T=SOCKET.ERROR
SOCKET.ERROR()
#T=SOCKET.GET
SOCKET.GET(connect-socket, size)
#T=SOCKET.LISTEN
SOCKET.LISTEN(service[, backlog])
#T=SOCKET.NGET
SOCKET.NGET(connect-socket, size)
#T=SOCKET.NPUT
SOCKET.NPUT(connect-socket, data)
#T=SOCKET.PUT
SOCKET.PUT(connect-socket, data)
#T=SOCKET.VERSION
SOCKET.VERSION()

#T=UNIQUE.ADD
UNIQUE.ADD id TYPE type LENGTH length [BASE base] [INITIAL initial];
#T=UNIQUE.DELETE 
UNIQUE.DELETE id TYPE type;
#T=UNIQUE.FILECLOSE 
UNIQUE.FILECLOSE id;
#T=UNIQUE.FILECREATE 
UNIQUE.FILECREATE name;
#T=UNIQUE.FILEOPEN
UNIQUE.FILEOPEN(name)
#T=UNIQUE.GETID
UNIQUE.GETID(id, type[, count])
#T=UNIQUE.LIST
UNIQUE.LIST(id)
#T=UNIQUE.VERSION
UNIQUE.VERSION()

#T=NET.GETHOSTNAME
NET.GETHOSTNAME()
#T=NET.GETHOSTBYNAME
NET.GETHOSTBYNAME in-name [NAME name] [ALIASES aliases] [ADDRESSES addresses];
#T=NET.GETHOSTBYADDRESS
NET.GETHOSTBYADDRESS in-address [NAME name] [ALIASES aliases] [ADDRESSES addresses];
#T=NET.GETSERVICEENTRIES
NET.GETSERVICEENTRIES service-entries;
#T=NET.VERSION
NET.VERSION()


#T=SL_ARGUMENT.GetOption
SL_ARGUMENT.GetOption format OPTION option [ARGUMENT argument];
#T=SL_ARGUMENT.GetArgument
SL_ARGUMENT.GetArgument(argument-number)
#T=SL_ARGUMENT.GetArgumentCount
SL_ARGUMENT.GetArgumentCount()
#T=SL_ARGUMENT.GetInterpreterArgument
SL_ARGUMENT.GetInterpreterArgument(argument-number)
#T=SL_ARGUMENT.GetInterpreterArgumentCount
SL_ARGUMENT.GetInterpreterArgumentCount()
#T=SL_ARGUMENT.GetInterpreterFiles
SL_ARGUMENT.GetInterpreterFiles()
#T=SL_ARGUMENT.Version
SL_ARGUMENT.Version()

#T=SL_ARRAY.Insert 
SL_ARRAY.Insert array POSITION index VALUE element;
#T=SL_ARRAY.Append
SL_ARRAY.Append array VALUE element;
#T=SL_ARRAY.Delete 
SL_ARRAY.Delete array POSITION index;
#T=SL_ARRAY.Version
SL_ARRAY.Version()

#T=SL_CHAR.IsAlpha
SL_CHAR.IsAlpha(character)
#T=SL_CHAR.IsAlphaUnderscore
SL_CHAR.IsAlphaUnderscore(character)
#T=SL_CHAR.IsAlphaDigit
SL_CHAR.IsAlphaDigit(character)
#T=SL_CHAR.IsAlphaDigitUnderscore
SL_CHAR.IsAlphaDigitUnderscore(character)
#T=SL_CHAR.IsDigit
SL_CHAR.IsDigit(character)
#T=SL_CHAR.IsLower
SL_CHAR.IsLower(character)
#T=SL_CHAR.IsPrintable
SL_CHAR.IsPrintable(character)
#T=SL_CHAR.IsUpper
SL_CHAR.IsUpper(character)
#T=SL_CHAR.ClassCreate
SL_CHAR.ClassCreate(characters)
#T=SL_CHAR.ClassAdd
SL_CHAR.ClassAdd(characters, class)
#T=SL_CHAR.ClassRemove
SL_CHAR.ClassRemove(characters, class)
#T=SL_CHAR.IsInClass
SL_CHAR.IsInClass(character, class)
#T=SL_CHAR.Version
SL_CHAR.Version()
#T=SL_DATE.StringToDate
SL_DATE.StringToDate(string, format)
#T=SL_DEBUG.Assert 
SL_DEBUG.Assert condition FILE file LINE line; 
#T=SL_ENVIRON.ExpandEnvironmentVariables
SL_ENVIRON.ExpandEnvironmentVariables(string)
#T=SL_FILE.DeleteDirectoryTree
SL_FILE.DeleteDirectoryTree path;
#T=SL_FILE.ReadDirectory
SL_FILE.ReadDirectory path FILES files;
#T=SL_FILEIO.OpenBinaryRead
SL_FILEIO.OpenBinaryRead(pathname)
#T=SL_FILEIO.OpenTextRead
SL_FILEIO.OpenTextRead(pathname)
#T=SL_FILEIO.CreateBinaryWrite
SL_FILEIO.CreateBinaryWrite(pathname)
#T=SL_FILEIO.CreateTextWrite
SL_FILEIO.CreateTextWrite(pathname)
#T=SL_FILEIO.AppendBinaryWrite
SL_FILEIO.AppendBinaryWrite(pathname)
#T=SL_FILEIO.AppendTextWrite
SL_FILEIO.AppendTextWrite(pathname)
#T=SL_FILEIO.OpenBinaryReadWrite
SL_FILEIO.OpenBinaryReadWrite(pathname)
#T=SL_FILEIO.CreateBinaryReadWrite
SL_FILEIO.CreateBinaryReadWrite(pathname)
#T=SL_FILEIO.AppendBinaryReadWrite
SL_FILEIO.AppendBinaryReadWrite(pathname)
#T=SL_FILEIO.ReadCount
SL_FILEIO.ReadCount filehandle COUNT count DATA data;
#T=SL_FILEIO.ReadUntil
SL_FILEIO.ReadUntil filehandle UNTIL until [LIMIT limit] DATA data;
#T=SL_FILEIO.Unread
SL_FILEIO.Unread filehandle DATA data;
#T=SL_FILEIO.WriteString
SL_FILEIO.WriteString filehandle DATA data;
#T=SL_FILEIO.Seek
SL_FILEIO.Seek filehandle [OFFSET offset] [WHENCE whence];
#T=SL_FILEIO.Tell
SL_FILEIO.Tell filehandle POSITION position;
#T=SL_FILEIO.Flush
SL_FILEIO.Flush filehandle;
#T=SL_FILEIO.CloseFile
SL_FILEIO.CloseFile filehandle;
#T=SL_FILEIO.IsOpen
SL_FILEIO.IsOpen(filehandle)
#T=SL_FILEIO.IsReadable
SL_FILEIO.IsReadable(filehandle)
#T=SL_FILEIO.IsWritable
SL_FILEIO.IsWritable(filehandle)
#T=SL_FILEIO.IsBinary
SL_FILEIO.IsBinary(filehandle)
#T=SL_FILEIO.IsText
SL_FILEIO.IsText(filehandle)
#T=SL_FILEIO.DirectorySeparator
SL_FILEIO.DirectorySeparator()
#T=SL_HASH.Initialize
SL_HASH.Initialize()
#T=SL_HASH.Put
SL_HASH.Put handle KEY key VALUE value;
#T=SL_HASH.Get
SL_HASH.Get handle KEY key VALUE value;
#T=SL_PACKED.SapIntegerToInt4
SL_PACKED.SapIntegerToInt4 (integer)
#T=SL_PACKED.SapInt4ToInteger
SL_PACKED.SapInt4ToInteger(packed)
#T=SL_PACKED.IbmFloatToPackedDecimal
SL_PACKED.IbmFloatToPackedDecimal(float, length, decimals [, plus-nibble[, minus-nibble]])
#T=SL_PACKED.IbmPackedDecimalToFloat
SL_PACKED.IbmPackedDecimalToFloat(buffer, decimals [, plus-nibble[, minus-nibble]])
#T=SL_PATH.Filter
SL_PATH.Filter(path)
#T=SL_PATH.Compare
SL_PATH.Compare(path1, path2)
#T=SL_PATH.CompareFilter
SL_PATH.CompareFilter(path1, path2)
#T=SL_SEARCH.BinarySearch
SL_SEARCH.BinarySearch(array, search)
#T=SL_SORT.HeapSort_Any
SL_SORT.HeapSort_Any array COMPARE_IMPL compare-function;
#T=SL_SORT.HeapSort_String
SL_SORT.HeapSort_String array;
#T=SL_SORT.QuickSort_String
SL_SORT.QuickSort_String array [FROM from] [TO to];
#T=SL_STRING.AsciiToEbcdic
SL_STRING.AsciiToEbcdic(string)
#T=SL_STRING.EbcdicToAscii
SL_STRING.EbcdicToAscii(string)
#T=SL_STRING.FieldCount
SL_STRING.FieldCount(string[, separators])
#T=SL_STRING.FieldExtract
SL_STRING.FieldExtract(string, field-number[, separators])
#T=SL_STRING.FieldExplode
SL_STRING.FieldExplode(string[, separator])
#T=SL_STRING.FieldImplode
SL_STRING.FieldImplode(array[, separator])
#T=SL_STRING.Reverse
SL_STRING.Reverse string;
#T=SL_STRING.ToLower
SL_STRING.ToLower(string)
#T=SL_STRING.ToUpper
SL_STRING.ToUpper(string)
#T=SL_TAG.Put
SL_TAG.Put file-name TAG tag-name VALUE value [FORCE_READ force-read]; 
#T=SL_TAG.Get
SL_TAG.Get(file-name, tag-name[, force-read])
#T=SL_TAG.Remove
SL_TAG.Remove file-name TAG tag-name [FORCE_READ force-read];
#T=SL_TAG.List
SL_TAG.List file-name [TAGS tags] [VALUES values] [FORCE_READ force-read];


