/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import net.luminis.jmx.topthreads.InfoStats;

public abstract class AbstractInfoStats
implements InfoStats {
    static int defaultHistoryLength = 10;
    protected int nrOfValidValues;
    protected int percentage;
    protected int[] usageHistory;
    protected long lastCpuUsage;
    protected int historyIndex;
    protected int historyLength = defaultHistoryLength;

    public AbstractInfoStats() {
        this.usageHistory = new int[this.historyLength];
    }

    public int getPercentage() {
        return this.percentage;
    }

    public long getCpuUsage() {
        return this.lastCpuUsage;
    }

    public int getAverageUsage() {
        if (this.nrOfValidValues > 0) {
            int n = this.percentage;
            for (int n2 : this.usageHistory) {
                n += n2;
            }
            return n / this.nrOfValidValues;
        }
        return 0;
    }

    public int[] getHistory() {
        int[] nArray = new int[this.historyLength];
        for (int i = 0; i < this.historyLength; ++i) {
            int n = (this.historyIndex + i) % this.historyLength;
            nArray[i] = this.usageHistory[n];
        }
        return nArray;
    }

    public boolean getSelect() {
        return false;
    }

    public Thread.State getState() {
        return null;
    }

    public void setIndex(int n) {
    }

    public void setSelect(boolean bl) {
    }
}

