/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.luminis.jmx.topthreads.TopThreadsPanel;

public class Main {
    private static final String PROGRAM_NAME = "TopThreads";
    public static final String JARNAME = "topthreads.jar";
    public static final String VERSION = "1.1";

    static void usage() {
        System.out.println("");
        System.out.println("TopThreads version 1.1");
        System.out.println("");
        System.out.println("Usage: java -jar topthreads.jar <hostname>:<port>");
        System.out.println("    or java -cp topthreads.jar " + Main.class.getName() + " <hostname>:<port>");
        System.out.println("    or as a JConsole plugin: jconsole -pluginpath topthreads.jar");
        System.out.println("Requires Java 1.5, JConsole plugin requires Java 1.6");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        if (stringArray.length > 0 && (stringArray[0].equals("-v") || stringArray[0].equals("--version"))) {
            System.out.println(VERSION);
            return;
        }
        if (stringArray.length != 1) {
            Main.usage();
        }
        if ((stringArray2 = stringArray[0].split(":")).length != 2) {
            Main.usage();
        }
        String string = stringArray2[0];
        int n = -1;
        try {
            n = Integer.parseInt(stringArray2[1]);
        }
        catch (NumberFormatException numberFormatException) {
            Main.usage();
        }
        if (n < 0) {
            Main.usage();
        }
        final TopThreadsPanel topThreadsPanel = new TopThreadsPanel();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Main.createAndShowGUI(topThreadsPanel);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        MBeanServerConnection mBeanServerConnection = Main.connect(topThreadsPanel, string, n);
        topThreadsPanel.setMBeanServerConnection(mBeanServerConnection);
    }

    public static void createAndShowGUI(JPanel jPanel) {
        JFrame jFrame = new JFrame(PROGRAM_NAME);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.add((Component)jPanel, "Center");
        jComponent.setOpaque(true);
        jComponent.setBorder(new EmptyBorder(12, 12, 12, 12));
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(jComponent);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static MBeanServerConnection connect(JPanel jPanel, String string, int n) {
        String string2 = "/jndi/rmi://" + string + ":" + n + "/jmxrmi";
        MBeanServerConnection mBeanServerConnection = null;
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", "", 0, string2);
            JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL);
            mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(jPanel, "Could not connect to " + string + ":" + n + ".\n" + "Check that the application you want to monitor has remote jmx monitoring enabled.", PROGRAM_NAME, 0);
            System.exit(1);
        }
        return mBeanServerConnection;
    }
}

