/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.management.MBeanServerConnection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.luminis.jmx.topthreads.InfoStats;
import net.luminis.jmx.topthreads.PreferencesPanel;
import net.luminis.jmx.topthreads.ThreadDataCollector;
import net.luminis.jmx.topthreads.ThreadInfoStats;
import org.jdesktop.swingworker.SwingWorker;

public class TopThreadsPanel
extends JPanel {
    public static final String DEBUG_FLAG = "net.luminis.jmx.topthreads.debug";
    public static final String PRIORITY_FLAG = "net.luminis.jmx.topthreads.priorities";
    public static final String RESETPREFS_FLAG = "net.luminis.jmx.topthreads.resetPrefs";
    public static final String INITIAL_INTERVAL_FLAG = "net.luminis.jmx.topthreads.interval";
    public static final int INITIAL_MAX_THREADS = 100;
    private static final int COLUMN_SETTRACE = 0;
    private static final int COLUMN_THREADNAME = 1;
    private static final int COLUMN_HISTORY = 2;
    private static final int COLUMN_USAGE = 3;
    private static final int COLUMN_PERCENTAGE = 4;
    private static final int COLUMN_AVG = 5;
    private static final int COLUMN_THREADSTATE = 6;
    private static final int COLUMN_PRIORITY = 7;
    private int columnCount = 7;
    private JLabel threadCountLabel;
    private JLabel threadDisplayedLabel;
    private JLabel threadsRunningLabel;
    private JLabel threadsBlockedLabel;
    private JLabel threadsWaitingLabel;
    private JLabel threadsTimedWaitingLabel;
    private JTable table;
    private ThreadInfoTableModel tableModel;
    private JTextArea stackTraceArea;
    private JTextField intervalField;
    private int timerInterval = 15;
    private int maxThreadsDisplayed = 100;
    private JLabel cpuUsage;
    private boolean debug;
    private MBeanServerConnection server;
    private ThreadMXBean threadMXBean;
    private Comparator<InfoStats> m_comparator = ThreadInfoStats.lastUsageComparator();
    private boolean fixOrder;
    private boolean hideUsageColumn;
    private boolean compareStackTraces = false;
    private InfoStats tracedThread;
    private Timer timer;
    private TimerTask timerTask;
    private int maxStackTraceDepth = Integer.MAX_VALUE;
    private JSplitPane m_splitter;
    private ThreadDataCollector threadDataCollector;
    private volatile boolean showCpuUsageHistory;
    private Integer lastDividerLocation;
    private JScrollPane m_textScrollPane;

    public TopThreadsPanel() {
        super(new BorderLayout());
        if (System.getProperty(DEBUG_FLAG) != null && System.getProperty(DEBUG_FLAG).equals("true")) {
            this.debug = true;
        }
        this.readPrefs();
        this.add((Component)this.createTopPanel(), "North");
        this.createTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.stackTraceArea = new JTextArea();
        this.stackTraceArea.setEditable(false);
        this.stackTraceArea.setMinimumSize(new Dimension(0, 0));
        this.m_textScrollPane = new JScrollPane(this.stackTraceArea);
        this.m_splitter = new JSplitPane(0, jScrollPane, this.m_textScrollPane);
        this.m_splitter.setOneTouchExpandable(true);
        this.m_splitter.setContinuousLayout(false);
        this.m_splitter.setResizeWeight(1.0);
        this.add((Component)this.m_splitter, "Center");
        this.add(this.createBottomPanel(), "South");
        this.m_splitter.setDividerLocation(1.0);
    }

    private JPanel createTopPanel() {
        int n = 13;
        int n2 = 3;
        this.threadCountLabel = new JLabel(" ");
        this.threadDisplayedLabel = new JLabel();
        this.threadsRunningLabel = new JLabel();
        this.threadsBlockedLabel = new JLabel();
        this.threadsWaitingLabel = new JLabel();
        this.threadsTimedWaitingLabel = new JLabel();
        this.cpuUsage = new JLabel();
        this.threadCountLabel.setToolTipText("current thread count");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Total:"));
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(this.threadCountLabel);
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(new JLabel("Shown:"));
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(this.threadDisplayedLabel);
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(new JLabel("Running:"));
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(this.threadsRunningLabel);
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(new JLabel("Blocked:"));
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(this.threadsBlockedLabel);
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(new JLabel("Waiting:"));
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(this.threadsWaitingLabel);
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(new JLabel("Timed waiting:"));
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(this.threadsTimedWaitingLabel);
        jPanel.add(Box.createRigidArea(new Dimension(13, 25)));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.cpuUsage);
        this.cpuUsage.setText("Cpu usage:  0 %");
        this.cpuUsage.setToolTipText("cpu usage of the monitored process");
        return jPanel;
    }

    private void createTable() {
        this.tableModel = new ThreadInfoTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 300));
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.hideUsageColumn = false;
        this.table.setIntercellSpacing(new Dimension(6, 3));
        this.table.setRowHeight(this.table.getRowHeight() + 4);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new UsageHistoryRenderer());
        this.table.getColumnModel().getColumn(4).setCellRenderer(new CurrentValueRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = TopThreadsPanel.this.table.columnAtPoint(mouseEvent.getPoint());
                if (n != 0) {
                    int n2 = TopThreadsPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                    TopThreadsPanel.this.tableModel.setValueAt(Boolean.TRUE, n2, 0);
                }
            }
        });
    }

    private Component createBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        int n = 3;
        int n2 = 6;
        this.intervalField = new JTextField(2);
        this.intervalField.setHorizontalAlignment(4);
        this.intervalField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                TopThreadsPanel.this.updateTimerInterval();
            }
        });
        jPanel.add(new JLabel("refresh:"));
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(this.intervalField);
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(Box.createGlue());
        final JToggleButton jToggleButton = new JToggleButton("fix order");
        jToggleButton.setActionCommand("fix");
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("fix")) {
                    jToggleButton.setActionCommand("unfix");
                    TopThreadsPanel.this.fixOrder(true);
                } else {
                    jToggleButton.setActionCommand("fix");
                    TopThreadsPanel.this.fixOrder(false);
                }
            }
        });
        jPanel.add(jToggleButton);
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(Box.createGlue());
        JButton jButton = new JButton("settings...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopThreadsPanel.this.showPreferencesDialog();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    protected void fixOrder(boolean bl) {
        this.fixOrder = bl;
        this.m_comparator = bl ? ThreadInfoStats.fixOrderComparator() : ThreadInfoStats.lastUsageComparator();
    }

    public synchronized void setMBeanServerConnection(MBeanServerConnection mBeanServerConnection) {
        this.server = mBeanServerConnection;
        if (mBeanServerConnection != null) {
            try {
                this.threadMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Threading", ThreadMXBean.class);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.err.println("Cannot access the Thread MXBean in the target VM: " + exception);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(TopThreadsPanel.this, "Cannot access the Thread MXBean in the target VM.", "TopThreadsPanel", 0);
                    }
                });
                return;
            }
            if (!this.threadMXBean.isThreadCpuTimeSupported()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(TopThreadsPanel.this, "Target VM does not support thread CPU time monitoring", "TopThreadsPanel", 0);
                    }
                });
            } else {
                boolean bl = this.threadMXBean.isThreadCpuTimeEnabled();
                try {
                    if (!bl) {
                        this.threadMXBean.setThreadCpuTimeEnabled(true);
                    }
                    this.initPollTime(this.threadMXBean.getThreadCount());
                    this.initTimer(false);
                    this.threadDataCollector = new ThreadDataCollector(this.threadMXBean, this.debug);
                }
                catch (SecurityException securityException) {
                    if (this.debug) {
                        System.err.println("Thread CPU time monitoring cannot be enabled in target VM: " + securityException);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(TopThreadsPanel.this, "Thread CPU time monitoring cannot be enabled in target VM.", "TopThreadsPanel", 0);
                        }
                    });
                }
            }
        } else {
            if (this.debug) {
                System.err.println("JMX connection is reset.");
            }
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.threadMXBean = null;
        }
    }

    private void retrieveAndShowStackTrace(final Long l) {
        if (l != null) {
            new SwingWorker<String, Object>(){

                @Override
                protected String doInBackground() throws Exception {
                    return TopThreadsPanel.this.retrieveStackTrace(l);
                }

                @Override
                protected void done() {
                    try {
                        TopThreadsPanel.this.showStackTrace((String)this.get());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            }.execute();
        }
    }

    private String retrieveStackTrace(long l) {
        ThreadInfo threadInfo = this.threadMXBean.getThreadInfo(l, this.maxStackTraceDepth);
        if (threadInfo != null) {
            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
            StringBuffer stringBuffer = new StringBuffer();
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuffer.append(stackTraceElement.toString());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private void showStackTrace(String string) {
        boolean bl;
        boolean bl2 = bl = !this.stackTraceArea.getText().isEmpty();
        if (this.compareStackTraces) {
            String string2 = this.stackTraceArea.getText();
            string = this.visualizeDiff(string2, string);
        }
        this.stackTraceArea.setText(string);
        if (string.isEmpty()) {
            if (bl) {
                this.lastDividerLocation = this.m_splitter.getDividerLocation();
            }
            this.m_splitter.setDividerLocation(1.0);
        } else if (!bl) {
            if (this.lastDividerLocation != null) {
                this.m_splitter.setDividerLocation(this.lastDividerLocation);
            } else {
                this.m_splitter.setDividerLocation(0.8f);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopThreadsPanel.this.m_textScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    private String visualizeDiff(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\n");
        String[] stringArray2 = string2.split("\n");
        String[] stringArray3 = new String[stringArray2.length];
        int n = stringArray.length - 1;
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            if (stringArray2[i] != null && stringArray2[i].trim().length() > 0) {
                stringArray3[i] = n >= 0 ? (stringArray[n].length() > 2 && stringArray[n].substring(3).equals(stringArray2[i]) ? "== " + stringArray2[i] : "!= " + stringArray2[i]) : "++ " + stringArray2[i];
            }
            --n;
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3[i] == null || stringArray3[i].trim().length() <= 0) continue;
            stringBuffer.append(stringArray3[i] + "\n");
        }
        return stringBuffer.toString();
    }

    void initTimer(boolean bl) {
        this.timerTask = new TimerTask(){
            SwingWorker<?, ?> swingWorker;

            public void run() {
                if (this.swingWorker != null && !this.swingWorker.isDone()) {
                    TopThreadsPanel.this.enlargeTimerInterval();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(TopThreadsPanel.this, "Refresh interval is modified, because it was too small.", "TopThreadsPanel", 2);
                        }
                    });
                } else {
                    this.swingWorker = new RefreshUiWorker();
                    this.swingWorker.execute();
                }
            }
        };
        this.timer = new Timer("Topthreads timer thread");
        int n = bl ? this.timerInterval : 0;
        this.timer.schedule(this.timerTask, n * 1000, (long)(this.timerInterval * 1000));
    }

    private void initPollTime(int n) {
        Integer n2 = null;
        if (System.getProperty(INITIAL_INTERVAL_FLAG) != null) {
            n2 = Integer.getInteger(INITIAL_INTERVAL_FLAG);
        }
        if (n2 == null) {
            if (n != 0) {
                this.timerInterval = n / 10;
                if (this.timerInterval < 1) {
                    this.timerInterval = 1;
                }
            } else {
                this.timerInterval = 1;
            }
        } else {
            this.timerInterval = n2;
        }
        this.intervalField.setText(String.valueOf(this.timerInterval));
    }

    protected void updateTimerInterval() {
        try {
            int n = Integer.parseInt(this.intervalField.getText());
            if (n > 0 && n < 999) {
                this.timer.cancel();
                this.timerInterval = n;
                this.initTimer(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.intervalField.setText(String.valueOf(this.timerInterval));
        }
    }

    protected void enlargeTimerInterval() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = Math.max(2, 5 - TopThreadsPanel.this.timerInterval);
                TopThreadsPanel.this.timerInterval *= n;
                TopThreadsPanel.this.intervalField.setText(String.valueOf(TopThreadsPanel.this.timerInterval));
                TopThreadsPanel.this.updateTimerInterval();
            }
        });
    }

    public void dispose() {
        ThreadDataCollector threadDataCollector = this.threadDataCollector;
        if (threadDataCollector != null) {
            threadDataCollector.dispose();
        }
    }

    private void showPreferencesDialog() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JFrame); container = container.getParent()) {
        }
        PreferencesPanel preferencesPanel = new PreferencesPanel((JFrame)container);
        preferencesPanel.setMaxStackTraceSize(this.maxStackTraceDepth);
        preferencesPanel.setShowCpuUsageHistory(this.showCpuUsageHistory);
        preferencesPanel.setHideUsageColumn(this.hideUsageColumn);
        preferencesPanel.setMaxNrThreadsDisplayed(this.maxThreadsDisplayed);
        preferencesPanel.setVisible(true);
        this.maxStackTraceDepth = preferencesPanel.getMaxStackTraceSize();
        this.maxThreadsDisplayed = preferencesPanel.getMaxNrThreadsDisplayed();
        this.showCpuUsageHistory = preferencesPanel.getShowCpuUsageHistory();
        boolean bl = preferencesPanel.getStoreAsPrefs();
        preferencesPanel.dispose();
        if (bl) {
            this.storePrefs();
        }
    }

    private void storePrefs() {
        block2: {
            try {
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putInt("maxStackTraceDepth", this.maxStackTraceDepth);
                preferences.putBoolean("showCpuUsageHistory", this.showCpuUsageHistory);
                preferences.putInt("maxThreadsDisplayed", this.maxThreadsDisplayed);
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.err.println("Storing preferences failed: " + exception);
            }
        }
    }

    private void readPrefs() {
        block2: {
            try {
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                this.maxStackTraceDepth = preferences.getInt("maxStackTraceDepth", 100);
                this.showCpuUsageHistory = preferences.getBoolean("showCpuUsageHistory", false);
                this.maxThreadsDisplayed = preferences.getInt("maxThreadsDisplayed", 100);
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.err.println("Reading preferences failed: " + exception);
            }
        }
    }

    private void removePrefs() {
        block2: {
            try {
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.removeNode();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.err.println("Reading preferences failed: " + exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RefreshUiWorker
    extends SwingWorker<Data, Object> {
        RefreshUiWorker() {
        }

        @Override
        public Data doInBackground() {
            Data data;
            block4: {
                data = new Data();
                try {
                    List<? extends InfoStats> list = TopThreadsPanel.this.threadDataCollector.getThreadList(TopThreadsPanel.this.showCpuUsageHistory);
                    Collections.sort(list, TopThreadsPanel.this.m_comparator);
                    if (!TopThreadsPanel.this.fixOrder) {
                        int n = 1;
                        for (InfoStats infoStats : list) {
                            infoStats.setIndex(n++);
                        }
                    }
                    data.stackTrace = TopThreadsPanel.this.tracedThread != null ? TopThreadsPanel.this.retrieveStackTrace(TopThreadsPanel.this.tracedThread.getId()) : "";
                    data.threadList = list.subList(0, Math.min(list.size(), TopThreadsPanel.this.maxThreadsDisplayed));
                    data.threadStats = TopThreadsPanel.this.threadDataCollector.getStats();
                    data.threadCount = list.size();
                    data.cpuUsagePercentage = TopThreadsPanel.this.threadDataCollector.getCpuUsagePercentage();
                }
                catch (Exception exception) {
                    data.error = exception;
                    if (TopThreadsPanel.this.timer == null) break block4;
                    TopThreadsPanel.this.timer.cancel();
                }
            }
            return data;
        }

        @Override
        protected void done() {
            try {
                Data data = (Data)this.get();
                if (data.error == null) {
                    TopThreadsPanel.this.tableModel.setThreadList(data.threadList);
                    TopThreadsPanel.this.tableModel.fireTableDataChanged();
                    TopThreadsPanel.this.threadCountLabel.setText(String.valueOf(data.threadCount));
                    if (data.threadCount <= TopThreadsPanel.this.maxThreadsDisplayed) {
                        TopThreadsPanel.this.threadDisplayedLabel.setText("all");
                    } else {
                        TopThreadsPanel.this.threadDisplayedLabel.setText(String.valueOf(Math.min(data.threadCount, TopThreadsPanel.this.maxThreadsDisplayed)));
                    }
                    TopThreadsPanel.this.showStackTrace(data.stackTrace);
                    TopThreadsPanel.this.threadsBlockedLabel.setText("" + data.threadStats.get((Object)Thread.State.BLOCKED));
                    TopThreadsPanel.this.threadsRunningLabel.setText("" + data.threadStats.get((Object)Thread.State.RUNNABLE));
                    TopThreadsPanel.this.threadsWaitingLabel.setText("" + data.threadStats.get((Object)Thread.State.WAITING));
                    TopThreadsPanel.this.threadsTimedWaitingLabel.setText("" + data.threadStats.get((Object)Thread.State.TIMED_WAITING));
                    TopThreadsPanel.this.cpuUsage.setText(String.format("Cpu usage: %2d %%", data.cpuUsagePercentage));
                } else if (data.error instanceof SecurityException) {
                    if (TopThreadsPanel.this.debug) {
                        System.err.println("Target VM does not allow retrieving thread CPU time: " + data.error);
                    }
                    JOptionPane.showMessageDialog(TopThreadsPanel.this, "Target VM does not allow retrieving thread CPU time.", "TopThreadsPanel", 0);
                } else {
                    if (TopThreadsPanel.this.debug) {
                        System.err.println("An error occured while retrieving thread CPU time: " + data.error);
                    }
                    JOptionPane.showMessageDialog(TopThreadsPanel.this, "An error occured while retrieving thread CPU time.", "TopThreadsPanel", 0);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    static class Data {
        public List<? extends InfoStats> threadList;
        public Map<Thread.State, Integer> threadStats;
        public int threadCount;
        public int cpuUsagePercentage;
        public String stackTrace;
        public Exception error;

        Data() {
        }
    }

    public static class UsageHistoryRenderer
    extends CustomTableCellRenderer
    implements TableCellRenderer {
        protected void paintComponent(Graphics graphics) {
            int[] nArray = (int[])this.table.getValueAt(this.row, this.column);
            int n = 0;
            for (int n2 : nArray) {
                n += n2;
            }
            int n3 = this.getHeight();
            int n4 = this.getWidth();
            int n5 = 25;
            for (int n2 = nArray.length - 1; n2 >= 0; --n2) {
                Color color = this.determineColor(nArray[n2]);
                int n6 = n4 - n5;
                int n7 = n5;
                n4 -= n5;
                float f = (float)Math.min(nArray[n2], 100) / 100.0f;
                int n8 = Math.round(f * (float)n3);
                int n9 = n3 - n8;
                int n10 = n3;
                graphics.setColor(color);
                graphics.fillRect(n6, n9, n7, n10);
                if (n > 0) {
                    graphics.setColor(Color.LIGHT_GRAY);
                    graphics.drawString("" + nArray[n2], n6 + 3, n10 - 3);
                }
                if (n6 <= 0) break;
            }
        }
    }

    public static class CurrentValueRenderer
    extends CustomTableCellRenderer
    implements TableCellRenderer {
        protected void paintComponent(Graphics graphics) {
            int n = (Integer)this.table.getValueAt(this.row, this.column);
            Color color = this.determineColor(n);
            graphics.setColor(color);
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            int n4 = Math.round(Math.min(n, 100) * n3 / 100);
            graphics.fillRect(0, n3 - n4, n2, n3);
            graphics.setColor(Color.BLACK);
            graphics.drawString("" + n, 3, n3 - 3);
        }
    }

    public static abstract class CustomTableCellRenderer
    extends JComponent {
        protected int row;
        protected int column;
        protected JTable table;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.table = jTable;
            this.row = n;
            this.column = n2;
            return this;
        }

        protected Color determineColor(int n) {
            int n2;
            int n3;
            if (n < 0) {
                n = 0;
            }
            if (n > 100) {
                n = 100;
            }
            if (n < 50) {
                n3 = (int)(5.1 * (double)n);
                n2 = 255;
            } else {
                n3 = 255;
                n2 = 255 - (int)((double)(n - 50) * 5.1);
            }
            int n4 = 0;
            return new Color(n3, n2, n4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ThreadInfoTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private List<? extends InfoStats> threadList;

        public ThreadInfoTableModel() {
            this.columnNames = new String[TopThreadsPanel.this.columnCount];
            this.threadList = Collections.emptyList();
            this.columnNames[1] = "Thread";
            this.columnNames[2] = "Usage history";
            this.columnNames[3] = "Cpu";
            this.columnNames[4] = "%";
            this.columnNames[5] = "Average";
            this.columnNames[6] = "State";
            if (TopThreadsPanel.this.columnCount > 7) {
                this.columnNames[7] = "Priority";
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.threadList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InfoStats infoStats = this.threadList.get(n);
            switch (n2) {
                case 0: {
                    return infoStats.getSelect();
                }
                case 1: {
                    return infoStats.getName();
                }
                case 2: {
                    return infoStats.getHistory();
                }
                case 3: {
                    long l = infoStats.getCpuUsage() / 1000L;
                    return new Long(l);
                }
                case 4: {
                    return infoStats.getPercentage();
                }
                case 5: {
                    return infoStats.getAverageUsage();
                }
                case 6: {
                    return infoStats.getState();
                }
                case 7: {
                    Integer n3 = infoStats.getPriority();
                    if (n3 != null) {
                        return n3.toString();
                    }
                    return "";
                }
            }
            return null;
        }

        public Class<? extends Object> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            return object != null ? object.getClass() : String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (TopThreadsPanel.this.showCpuUsageHistory && n == 0) {
                return;
            }
            if (n2 == 0) {
                if (object.equals(Boolean.TRUE)) {
                    if (TopThreadsPanel.this.tracedThread != null) {
                        TopThreadsPanel.this.tracedThread.setSelect(false);
                    }
                    TopThreadsPanel.this.tableModel.fireTableDataChanged();
                    TopThreadsPanel.this.retrieveAndShowStackTrace(this.threadList.get(n).getId());
                    TopThreadsPanel.this.tracedThread = this.threadList.get(n);
                    TopThreadsPanel.this.tracedThread.setSelect(true);
                } else {
                    TopThreadsPanel.this.showStackTrace("");
                    TopThreadsPanel.this.tracedThread.setSelect(false);
                    TopThreadsPanel.this.tracedThread = null;
                }
            }
        }

        void setThreadList(List<? extends InfoStats> list) {
            this.threadList = list;
        }
    }
}

