/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import com.sun.tools.jconsole.JConsoleContext;
import com.sun.tools.jconsole.JConsolePlugin;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.luminis.jmx.topthreads.TopThreadsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginAdapter
extends JConsolePlugin {
    public static final String TAB_NAME = "Top threads";
    private TopThreadsPanel topthreadsPanel;

    @Override
    public Map<String, JPanel> getTabs() {
        this.topthreadsPanel = new TopThreadsPanel();
        ConnectionListener connectionListener = new ConnectionListener();
        this.addContextPropertyChangeListener(connectionListener);
        connectionListener.checkConnection();
        return Collections.singletonMap(TAB_NAME, this.topthreadsPanel);
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return null;
    }

    @Override
    public void dispose() {
        if (this.topthreadsPanel != null) {
            this.topthreadsPanel.dispose();
        }
        super.dispose();
    }

    private class ConnectionListener
    implements PropertyChangeListener {
        private ConnectionListener() {
        }

        public void checkConnection() {
            MBeanServerConnection mBeanServerConnection = PluginAdapter.this.getContext().getMBeanServerConnection();
            if (mBeanServerConnection != null) {
                PluginAdapter.this.topthreadsPanel.setMBeanServerConnection(mBeanServerConnection);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "connectionState") {
                JConsoleContext jConsoleContext = PluginAdapter.this.getContext();
                if (propertyChangeEvent.getNewValue().equals((Object)JConsoleContext.ConnectionState.CONNECTED)) {
                    if (jConsoleContext != null) {
                        PluginAdapter.this.topthreadsPanel.setMBeanServerConnection(jConsoleContext.getMBeanServerConnection());
                    }
                } else {
                    PluginAdapter.this.topthreadsPanel.setMBeanServerConnection(null);
                }
            }
        }
    }
}

