/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class PreferencesPanel
extends JDialog {
    private int maxStackTraceSize;
    private JTextField stackTraceSizeField;
    private Frame parent;
    private JCheckBox showCpuUsageHistory;
    private JCheckBox storePrefs;
    private JTextField maxNrThreadsDisplayedField;
    private int maxNrThreads;

    public PreferencesPanel(Frame frame) {
        super(frame, "TopThreads - Preferences", true);
        this.parent = frame;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new LineBorder(Color.BLACK));
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createLoweredBevelBorder();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(border, BorderFactory.createCompoundBorder(border2, BorderFactory.createEmptyBorder(5, 5, 5, 5)))));
        jPanel.setLayout(new GridLayout(0, 2));
        JLabel jLabel = new JLabel(" Max stack trace size:   ");
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        this.stackTraceSizeField = new JTextField();
        int n = this.stackTraceSizeField.getPreferredSize().height;
        this.stackTraceSizeField.setPreferredSize(new Dimension(100, n));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 5));
        jPanel2.add(this.stackTraceSizeField);
        jPanel.add(jPanel2);
        this.maxNrThreadsDisplayedField = new JTextField();
        this.maxNrThreadsDisplayedField.setPreferredSize(new Dimension(100, n));
        jPanel.add(new JLabel("  Max number of threads displayed:   "));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 5));
        jPanel3.add(this.maxNrThreadsDisplayedField);
        jPanel.add(jPanel3);
        this.showCpuUsageHistory = new JCheckBox();
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.add(this.showCpuUsageHistory);
        jPanel.add(jPanel4);
        jPanel.add(new JLabel("Show process cpu usage too (top row)"));
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        JPanel jPanel5 = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 1);
        jPanel5.setLayout(gridLayout);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        this.storePrefs = new JCheckBox("store these settings as default");
        this.storePrefs.setSelected(true);
        jPanel6.add(this.storePrefs);
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPanel.this.close();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPanel.this.close();
            }
        });
        jPanel7.add(jButton2);
        jPanel7.add(jButton);
        jPanel5.add(jPanel7);
        container.add((Component)jPanel5, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.parent);
    }

    private void close() {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        PreferencesPanel preferencesPanel = new PreferencesPanel(null);
        preferencesPanel.setDefaultCloseOperation(2);
        preferencesPanel.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        preferencesPanel.setVisible(true);
    }

    public int getMaxStackTraceSize() {
        try {
            return Integer.parseInt(this.stackTraceSizeField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return this.maxStackTraceSize;
        }
    }

    public void setMaxStackTraceSize(int n) {
        this.maxStackTraceSize = n;
        this.stackTraceSizeField.setText("" + n);
    }

    public int getMaxNrThreadsDisplayed() {
        try {
            return Integer.parseInt(this.maxNrThreadsDisplayedField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return this.maxNrThreads;
        }
    }

    public void setMaxNrThreadsDisplayed(int n) {
        this.maxNrThreadsDisplayedField.setText("" + n);
        this.maxNrThreads = n;
    }

    public boolean getHideUsageColumn() {
        return false;
    }

    public void setHideUsageColumn(boolean bl) {
    }

    public boolean getShowCpuUsageHistory() {
        return this.showCpuUsageHistory.isSelected();
    }

    public void setShowCpuUsageHistory(boolean bl) {
        this.showCpuUsageHistory.setSelected(bl);
    }

    public boolean getStoreAsPrefs() {
        return this.storePrefs.isSelected();
    }
}

