/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.luminis.jmx.topthreads.InfoStats;
import net.luminis.jmx.topthreads.ProcessInfoStats;
import net.luminis.jmx.topthreads.ThreadInfoStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadDataCollector {
    private ThreadMXBean threadMXBean;
    private int updateCount;
    private boolean debug;
    private boolean includeThreadPriorities;
    private Map<Long, ThreadInfoStats> threadData = new HashMap<Long, ThreadInfoStats>();
    private ProcessInfoStats processInfo = new ProcessInfoStats("Process (% CPU of all threads together)");
    private long startMeasurement;
    private int cpuUsagePercentage;
    private int threadsBlocked;
    private int threadsRunning;
    private int threadsTimedWaiting;
    private int threadsWaiting;

    public ThreadDataCollector(ThreadMXBean threadMXBean, boolean bl) {
        this.threadMXBean = threadMXBean;
        this.debug = bl;
    }

    public synchronized List<? extends InfoStats> getThreadList(boolean bl) throws SecurityException {
        Object object;
        if (this.threadMXBean == null) {
            return Collections.emptyList();
        }
        ++this.updateCount;
        long[] lArray = null;
        ThreadInfo[] threadInfoArray = null;
        try {
            lArray = this.threadMXBean.getAllThreadIds();
            threadInfoArray = this.threadMXBean.getThreadInfo(lArray);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (this.debug) {
                System.err.println("error while getting thread info: " + undeclaredThrowableException + " caused by " + undeclaredThrowableException.getCause());
            }
            return Collections.emptyList();
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.err.println("error while getting thread info: " + exception);
                exception.printStackTrace();
            }
            return Collections.emptyList();
        }
        Map<Long, Integer> map = null;
        if (this.includeThreadPriorities) {
            map = this.determineThreadPriorities();
        }
        long l = System.currentTimeMillis();
        long l2 = 0L;
        for (int i = 0; i < lArray.length; ++i) {
            long l3;
            assert (threadInfoArray[i].getThreadId() == lArray[i]);
            long l4 = lArray[i];
            if (threadInfoArray[i] == null || (l3 = this.threadMXBean.getThreadCpuTime(l4)) == -1L) continue;
            object = this.threadData.get(l4);
            if (object == null) {
                object = new ThreadInfoStats(l4, threadInfoArray[i], l3);
                this.threadData.put(l4, (ThreadInfoStats)object);
            } else {
                l2 += ((ThreadInfoStats)object).update(threadInfoArray[i], l3);
            }
            if (!this.includeThreadPriorities) continue;
            Integer n = map.get(l4);
            if (n != null) {
                ((ThreadInfoStats)object).setThreadPriority(n);
                continue;
            }
            System.err.println("no prio for thread " + l4);
        }
        long l5 = System.currentTimeMillis();
        long l6 = this.startMeasurement;
        this.startMeasurement = l + (l5 - l) / 2L;
        if (l6 != 0L) {
            long l7 = this.startMeasurement - l6;
            long l8 = l2 / 1000L;
            l8 = 1000L * l8 / l7;
            this.cpuUsagePercentage = (int)(100L * l8 / 1000000L);
            if (this.debug) {
                System.out.println(String.format("Obtaining cputimes took %3d ms, measurement period was %d ms, current total (/s) = %d", l5 - l, l7, l8));
            }
        }
        this.resetStateCounts();
        ArrayList<ThreadInfoStats> arrayList = new ArrayList<ThreadInfoStats>(this.threadData.values());
        for (ThreadInfoStats threadInfoStats : arrayList) {
            if (!threadInfoStats.checkUpdate(this.updateCount) && this.threadMXBean.getThreadInfo(threadInfoStats.getId()) == null) {
                this.threadData.remove(threadInfoStats.getId());
            }
            threadInfoStats.computePercentage(l2);
            this.updateStateCounts(threadInfoStats.getState());
        }
        object = arrayList;
        if (bl) {
            this.processInfo.update(l2);
            this.processInfo.setPercentage(this.cpuUsagePercentage);
            object.add(this.processInfo);
        }
        return object;
    }

    public Map<Thread.State, Integer> getStats() {
        HashMap<Thread.State, Integer> hashMap = new HashMap<Thread.State, Integer>();
        hashMap.put(Thread.State.BLOCKED, this.threadsBlocked);
        hashMap.put(Thread.State.RUNNABLE, this.threadsRunning);
        hashMap.put(Thread.State.TIMED_WAITING, this.threadsTimedWaiting);
        hashMap.put(Thread.State.WAITING, this.threadsWaiting);
        return hashMap;
    }

    public int getCpuUsagePercentage() {
        return this.cpuUsagePercentage;
    }

    private void resetStateCounts() {
        this.threadsBlocked = 0;
        this.threadsRunning = 0;
        this.threadsTimedWaiting = 0;
        this.threadsWaiting = 0;
    }

    private void updateStateCounts(Thread.State state) {
        switch (state) {
            case BLOCKED: {
                ++this.threadsBlocked;
                break;
            }
            case RUNNABLE: {
                ++this.threadsRunning;
                break;
            }
            case TIMED_WAITING: {
                ++this.threadsTimedWaiting;
                break;
            }
            case WAITING: {
                ++this.threadsWaiting;
            }
        }
    }

    private Map<Long, Integer> determineThreadPriorities() {
        return Collections.emptyMap();
    }

    public synchronized void dispose() {
        this.threadMXBean = null;
        this.threadData = null;
    }
}

