/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.lang.management.ThreadInfo;
import java.util.Comparator;
import net.luminis.jmx.topthreads.AbstractInfoStats;
import net.luminis.jmx.topthreads.InfoStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadInfoStats
extends AbstractInfoStats {
    static int historyLength = 10;
    private ThreadInfo threadInfo;
    private long threadId;
    private long previousCpuTime;
    private int updateCount;
    private boolean showTrace;
    private int index;
    private Integer threadPriority;

    public ThreadInfoStats(long l, ThreadInfo threadInfo, long l2) {
        this.threadId = l;
        this.threadInfo = threadInfo;
        this.previousCpuTime = l2;
        this.usageHistory = new int[historyLength];
    }

    @Override
    public String getName() {
        return this.threadInfo.getThreadName();
    }

    @Override
    public long getId() {
        return this.threadId;
    }

    @Override
    public boolean getSelect() {
        return this.showTrace;
    }

    @Override
    public void setSelect(boolean bl) {
        this.showTrace = bl;
    }

    @Override
    public Thread.State getState() {
        return this.threadInfo.getThreadState();
    }

    public long update(ThreadInfo threadInfo, long l) {
        this.usageHistory[this.historyIndex] = this.percentage;
        ++this.historyIndex;
        this.historyIndex %= historyLength;
        if (this.nrOfValidValues <= historyLength) {
            ++this.nrOfValidValues;
        }
        this.threadInfo = threadInfo;
        this.lastCpuUsage = l - this.previousCpuTime;
        if (this.lastCpuUsage < 0L) {
            this.lastCpuUsage = 0L;
        }
        this.previousCpuTime = l;
        ++this.updateCount;
        return this.lastCpuUsage;
    }

    public boolean checkUpdate(int n) {
        if (this.updateCount != n) {
            assert (this.updateCount == n - 1 || this.updateCount == 0);
            this.lastCpuUsage = 0L;
            this.updateCount = n;
            return false;
        }
        return true;
    }

    public void computePercentage(long l) {
        if (l != 0L) {
            this.percentage = (int)(100L * this.lastCpuUsage / l);
        }
    }

    public String getHistoryAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < historyLength; ++i) {
            int n = (this.historyIndex + i) % historyLength;
            int n2 = this.usageHistory[n];
            if (n2 > 0) {
                bl = true;
            }
            stringBuffer.append(n2);
            stringBuffer.append(" ");
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return "";
    }

    static Comparator<InfoStats> lastUsageComparator() {
        return new Comparator<InfoStats>(){

            @Override
            public int compare(InfoStats infoStats, InfoStats infoStats2) {
                ThreadInfoStats threadInfoStats = null;
                ThreadInfoStats threadInfoStats2 = null;
                if (infoStats instanceof ThreadInfoStats) {
                    threadInfoStats = (ThreadInfoStats)infoStats;
                }
                if (infoStats2 instanceof ThreadInfoStats) {
                    threadInfoStats2 = (ThreadInfoStats)infoStats2;
                }
                if (threadInfoStats == null && threadInfoStats2 == null) {
                    return 0;
                }
                if (threadInfoStats == null) {
                    return -1;
                }
                if (threadInfoStats2 == null) {
                    return 1;
                }
                if (threadInfoStats.lastCpuUsage < threadInfoStats2.lastCpuUsage) {
                    return 1;
                }
                if (threadInfoStats.lastCpuUsage > threadInfoStats2.lastCpuUsage) {
                    return -1;
                }
                if (threadInfoStats.previousCpuTime < threadInfoStats2.previousCpuTime) {
                    return 1;
                }
                if (threadInfoStats.previousCpuTime > threadInfoStats2.previousCpuTime) {
                    return -1;
                }
                return 0;
            }
        };
    }

    static Comparator<ThreadInfoStats> nameComparator() {
        return new Comparator<ThreadInfoStats>(){

            @Override
            public int compare(ThreadInfoStats threadInfoStats, ThreadInfoStats threadInfoStats2) {
                return threadInfoStats.getName().compareTo(threadInfoStats2.getName());
            }
        };
    }

    public static Comparator<InfoStats> fixOrderComparator() {
        return new Comparator<InfoStats>(){

            @Override
            public int compare(InfoStats infoStats, InfoStats infoStats2) {
                ThreadInfoStats threadInfoStats = null;
                ThreadInfoStats threadInfoStats2 = null;
                if (infoStats instanceof ThreadInfoStats) {
                    threadInfoStats = (ThreadInfoStats)infoStats;
                }
                if (infoStats2 instanceof ThreadInfoStats) {
                    threadInfoStats2 = (ThreadInfoStats)infoStats2;
                }
                if (threadInfoStats == null && threadInfoStats2 == null) {
                    return 0;
                }
                if (threadInfoStats == null) {
                    return -1;
                }
                if (threadInfoStats2 == null) {
                    return 1;
                }
                if (threadInfoStats.index == 0 && threadInfoStats2.index == 0) {
                    return new Long(threadInfoStats.lastCpuUsage).compareTo(threadInfoStats2.lastCpuUsage);
                }
                if (threadInfoStats.index == 0) {
                    return 1;
                }
                if (threadInfoStats2.index == 0) {
                    return -1;
                }
                return new Integer(threadInfoStats.index).compareTo(threadInfoStats2.index);
            }
        };
    }

    @Override
    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Integer getPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(Integer n) {
        this.threadPriority = n;
    }
}

