/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.Status;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ActivateAttrLoader
extends ManagedRunnableImpl {
    private static Log log = LogFactory.getLog((String)"master.Loader.ActivateAttr");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.ActivateAttrLoader");
    private CtrlDispAppl dispatcher;
    private Status status = Status.START;
    private Map<Long, Attributes<String>> activateAttr = new Hashtable<Long, Attributes<String>>();
    private SQLException e = null;

    public ActivateAttrLoader(CtrlDispAppl dispatcher) {
        this.dispatcher = dispatcher;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEnd() throws InterruptedException {
        Map<Long, Attributes<String>> map = this.activateAttr;
        synchronized (map) {
            while (this.status != Status.READY) {
                this.activateAttr.wait();
            }
        }
    }

    public Map<Long, Attributes<String>> getAll() {
        return this.activateAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        Map<Long, Attributes<String>> map;
        this.setName("ActivateAttr Loader");
        this.status = Status.RUN;
        Attributes attr = null;
        long jobid = -1L;
        try (Connection con = this.dispatcher.getConnection();){
            String sql = "select jobid, name, value from ctrl_activate order by jobid, attrno";
            PreparedStatement stmt = con.prepareStatement(sql);
            stmt.setFetchSize(this.dispatcher.getEdiboss().getLoadFetchSize());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + sql));
            }
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    long newJobId = rs.getLong(1);
                    if (newJobId != jobid) {
                        if (attr != null && attr.size() > 0) {
                            Map<Long, Attributes<String>> map2 = this.activateAttr;
                            synchronized (map2) {
                                this.activateAttr.put(jobid, (Attributes<String>)attr);
                                this.activateAttr.notifyAll();
                            }
                        }
                        jobid = newJobId;
                        attr = new Attributes();
                    }
                    attr.put(new Attribute(rs.getString(2), (Object)rs.getString(3)));
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.e = e;
        }
        if (attr != null && attr.size() > 0) {
            map = this.activateAttr;
            synchronized (map) {
                this.activateAttr.put(jobid, attr);
                this.activateAttr.notifyAll();
            }
        }
        this.status = Status.READY;
        map = this.activateAttr;
        synchronized (map) {
            this.activateAttr.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes get(long id) throws SQLException {
        Map<Long, Attributes<String>> map;
        Attributes<String> attr = null;
        do {
            map = this.activateAttr;
            synchronized (map) {
                attr = this.activateAttr.get(id);
                if (attr != null) {
                    this.activateAttr.remove(id);
                    return attr;
                }
                if (this.status != Status.READY && this.e != null) {
                    try {
                        this.activateAttr.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } while (attr == null && this.status != Status.READY && this.e == null);
        if (this.e != null) {
            throw this.e;
        }
        map = this.activateAttr;
        synchronized (map) {
            attr = this.activateAttr.get(id);
            if (attr != null) {
                this.activateAttr.remove(id);
                return attr;
            }
        }
        return null;
    }
}

