/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.builtin.Builtin;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.util.ActisFile;
import de.axway.lockDaemon.LockException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public abstract class CtrlBuiltin {
    protected static final Pattern EDI_COMP_PATTERN = Pattern.compile("(EDIOBJ\\..*\\.FN)|(\\$\\(EDIOBJ\\..*\\.FN\\))");
    protected Builtin builtin = null;
    private CtrlDispAppl dispatcher;
    private Connection con = null;

    protected CtrlBuiltin(Builtin builtin) {
        this.builtin = builtin;
    }

    public String getCurrentStepName() {
        return this.builtin.getName();
    }

    public String getRealFc() {
        return "(BUILT_IN=" + this.builtin.getName() + ") " + this.builtin.getRealFc();
    }

    public abstract long getId();

    public String getName() {
        return this.builtin.getName();
    }

    public boolean exec(CtrlDispAppl dispatcher, Connection con) throws Exception {
        return this.exec(dispatcher, con, true);
    }

    protected boolean exec(CtrlDispAppl dispatcher, Connection con, boolean doLog) throws Exception {
        this.dispatcher = dispatcher;
        this.con = con;
        if (doLog) {
            Logbook.getLogbook().createBIC(this.builtin.getName(), this.getId(), this.getId(), this.getId());
        }
        return this.builtin.exec(this);
    }

    public boolean handleDbi() {
        boolean ret = true;
        return ret;
    }

    public boolean ifJsRetryFull(String idAndSteps, List<Builtin> toExec) throws Exception {
        String[] sid = this.getParam(idAndSteps, "IF_JS_RETRY_FULL");
        if (sid == null || sid.length <= 0) {
            return true;
        }
        String[] s = sid[0].trim().split(":");
        if (s.length < 1) {
            throw new CfgException("no jobid for IF_JS_RETRY_FULL");
        }
        try {
            if (this.dispatcher.isJsRetryFull(s, this.getId())) {
                for (Builtin exec : toExec) {
                    Logbook.getLogbook().createBIC(exec.getName(), this.getId(), this.getId(), this.getId());
                    exec.exec(this);
                }
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            CfgException ce = new CfgException("invalid jobid: <" + sid[0] + ">  for IF_JS_RETRY_FULL");
            ce.initCause(e);
            throw ce;
        }
    }

    public boolean jobstepChangeSequ(String ids) throws CfgException, InterruptedException, LockException {
        String[] sid = this.getParam(ids, "JS_CHANGE_SEQU");
        if (sid == null) {
            return true;
        }
        if (sid.length < 1) {
            throw new CfgException("no parameter");
        }
        boolean flag = sid[0].equalsIgnoreCase("SEQU");
        for (int x = 1; x < sid.length; ++x) {
            String[] idStep = sid[x].split(",");
            String id = idStep[0];
            String step = "-1";
            if (idStep.length > 0) {
                step = idStep[1];
            }
            try {
                this.dispatcher.jobstepChangeSequ(Long.parseLong(id), Integer.parseInt(step), flag, this.getId());
                continue;
            }
            catch (NumberFormatException e) {
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
        }
        return true;
    }

    public boolean jobChangeSequ(String ids) throws CfgException, InterruptedException, LockException, SQLException {
        String[] sid = this.getParam(ids, "JOB_CHANGE_SEQU");
        if (sid == null) {
            return true;
        }
        if (sid.length < 1) {
            throw new CfgException("no parameter");
        }
        boolean flag = sid[0].equalsIgnoreCase("SEQU");
        for (int x = 1; x < sid.length; ++x) {
            try {
                this.dispatcher.jobChangeSequ(Long.parseLong(sid[x]), flag, this.getId());
                continue;
            }
            catch (NumberFormatException e) {
                CfgException ce = new CfgException("invalid jobid: " + sid[x].trim());
                e.initCause((Throwable)((Object)ce));
                throw e;
            }
        }
        return true;
    }

    protected abstract EdiComp getEdiComp(String var1);

    protected abstract CtrlSlave getCompSlave();

    public boolean workflowResult(String ids, boolean close, int answer, Attributes<String> ... attr) throws CfgException, InterruptedException {
        String[] sid = this.getParam(ids, "WORKFLOW_RESULT");
        if (sid == null) {
            return true;
        }
        for (int x = 0; x < sid.length; ++x) {
            Attributes newAttr = new Attributes(Attributes.Type.POS);
            CtrlSlave slave = null;
            SlaveHandler sh = null;
            slave = this.getCompSlave();
            if (slave != null) {
                sh = this.dispatcher.getSlaveHandler(slave.getName());
            }
            ArrayList<File> remoteFiles = new ArrayList<File>();
            for (int y = 0; y < attr.length; ++y) {
                for (Attribute a : attr[y].get()) {
                    EdiComp comp = null;
                    if (a.getName().equalsIgnoreCase("FILE")) {
                        comp = this.getEdiComp((String)a.get());
                    }
                    if (comp == null) {
                        newAttr.put(new Attribute(a.getName(), a.get()));
                        continue;
                    }
                    if (slave == null || slave.isLocal()) {
                        newAttr.put(new Attribute(a.getName(), (Object)comp));
                        continue;
                    }
                    if (sh == null) {
                        Logbook.getLogbook().error("no slavehandler for slave " + slave.getName() + " started");
                        newAttr.put(new Attribute("TEXT", (Object)("no slavehandler for slave " + slave.getName() + " started")));
                        continue;
                    }
                    try {
                        File file = sh.getRemoteFile(comp.getFileName());
                        EdiComp newComp = new EdiComp(comp, null);
                        newComp.setFileName(file.getAbsolutePath());
                        remoteFiles.add(file);
                        newAttr.put(new Attribute(a.getName(), (Object)newComp));
                    }
                    catch (Exception e) {
                        Logbook.getLogbook().error("Cannot receive remote file " + comp.getFileName() + " from slave " + slave.getName() + ": " + e.getMessage());
                        newAttr.put(new Attribute("TEXT", (Object)("Cannot receive remote file " + comp.getFileName() + " from slave " + slave.getName() + ": " + e.getMessage())));
                    }
                }
            }
            try {
                this.dispatcher.workflowResult(Long.parseLong(sid[x]), close, answer, newAttr, this.getId(), this.con);
            }
            catch (NumberFormatException e) {
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
            for (File file : remoteFiles) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    Logbook.getLogbook().warning("can not remove temp file " + file.getAbsolutePath() + ": " + e.getMessage());
                }
            }
        }
        return true;
    }

    public boolean deleteApplic(String ids) throws CfgException {
        String[] sid = this.getParam(ids, "DELETE_APPLIC");
        if (sid == null) {
            return true;
        }
        for (int x = 0; x < sid.length; ++x) {
            try {
                this.dispatcher.removeAppl(Long.parseLong(sid[x]));
                continue;
            }
            catch (NumberFormatException e) {
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
        }
        return true;
    }

    public boolean stopJob(String ids) throws CfgException, InterruptedException, LockException, SQLException {
        String[] sid = this.getParam(ids, "STOP_JOB");
        if (sid == null) {
            return true;
        }
        for (int x = 0; x < sid.length; ++x) {
            try {
                this.dispatcher.stopJob(Long.parseLong(sid[x]), this.getId(), this.con);
                continue;
            }
            catch (NumberFormatException e) {
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
        }
        return true;
    }

    public boolean jobExit(String ids) throws CfgException, InterruptedException, LockException, SQLException {
        String[] sid = this.getParam(ids, "JOB_EXIT");
        if (sid == null) {
            return true;
        }
        for (int x = 0; x < sid.length; ++x) {
            try {
                String[] s = sid[x].trim().split(":");
                if (s.length < 1) {
                    throw new CfgException("no jobid");
                }
                this.dispatcher.jobExit(s, this.getId(), this.con);
                continue;
            }
            catch (NumberFormatException e) {
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
        }
        return true;
    }

    public boolean termJs(String ids) throws CfgException, InterruptedException, LockException, SQLException {
        String[] sid = this.getParam(ids, "JS_TERMINATE");
        if (sid == null) {
            return true;
        }
        for (int x = 0; x < sid.length; ++x) {
            try {
                String[] s = sid[x].trim().split(":");
                if (s.length < 1) {
                    throw new CfgException("no jobid for JS_TERMINATE");
                }
                this.dispatcher.termJs(s, this.getId(), this.con);
                continue;
            }
            catch (NumberFormatException e) {
                throw new CfgException("invalid jobid: " + sid[x].trim() + "  for JS_TERMINATE");
            }
        }
        return true;
    }

    public boolean runJs(String ids) throws CfgException, InterruptedException, LockException, SQLException {
        String[] sid = this.getParam(ids, "JS_READY_TO_RUN");
        if (sid == null) {
            return true;
        }
        for (int x = 0; x < sid.length; ++x) {
            try {
                long jobid;
                String[] s = sid[x].trim().split(":");
                if (s.length < 1) {
                    throw new CfgException("no jobid");
                }
                if (s.length < 2) {
                    jobid = Long.parseLong(s[0].trim());
                    this.dispatcher.runJs(jobid, -1, this.getId(), this.con);
                    continue;
                }
                jobid = Long.parseLong(s[0].trim());
                int stepno = Integer.parseInt(s[1].trim());
                this.dispatcher.runJs(jobid, stepno, this.getId(), this.con);
                continue;
            }
            catch (NumberFormatException e) {
                if (sid[x].trim().equalsIgnoreCase("ALL")) {
                    return this.dispatcher.runAllJs(this.getId(), this.con);
                }
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
        }
        return true;
    }

    public boolean activateJob(String activateAttr) throws CfgException, InterruptedException, LockException, SQLException {
        Attributes attributes = new Attributes(Attributes.Type.POS);
        String[] attr = this.getParam(activateAttr, "ACTIVATE_JOB");
        if (attr == null) {
            throw new CfgException("no activate attributes");
        }
        for (int x = 0; x < attr.length; ++x) {
            try {
                long id = Long.parseLong(attr[x]);
                this.dispatcher.activateJob(id, this.getId(), this.con, "Selected by JOB_ID");
                continue;
            }
            catch (NumberFormatException e) {
                if (attr[x].equalsIgnoreCase("ALL")) {
                    return this.dispatcher.activateAllJobs(this.getId(), this.con);
                }
                attributes.put(new Attribute(attr[x]));
            }
        }
        if (attributes.size() > 0) {
            return this.dispatcher.activateJob((Attributes<String>)attributes, this.getId(), this.con);
        }
        return true;
    }

    public boolean suspendJob(String ids, String activateAttr, long suspTime) throws CfgException, InterruptedException {
        int x;
        String[] sid = this.getParam(ids, "SUSPEND_JOB");
        if (sid == null) {
            return true;
        }
        String[] attr = this.getParam(activateAttr, "ACTIVATE_ATTR");
        Attributes a = new Attributes();
        if (attr != null && attr.length > 0) {
            for (x = 0; x < attr.length; ++x) {
                if (attr[x].length() <= 0) continue;
                a.put(new Attribute(attr[x]));
            }
        }
        for (x = 0; x < sid.length; ++x) {
            try {
                this.dispatcher.suspendJob(Long.parseLong(sid[x].trim()), (Attributes<String>)a, suspTime, this.getId(), this.con);
                continue;
            }
            catch (NumberFormatException e) {
                if (sid[x].trim().equalsIgnoreCase("ALL")) {
                    return this.dispatcher.suspendAllJobs((Attributes<String>)a, suspTime, this.getId(), this.con);
                }
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
        }
        return true;
    }

    public boolean killOrDelete(String ids, boolean kill, String paramName) throws CfgException, InterruptedException, SQLException, IOException {
        String[] sid = this.getParam(ids, paramName);
        if (sid == null) {
            return true;
        }
        for (int x = 0; x < sid.length; ++x) {
            try {
                this.dispatcher.killJob(Long.parseLong(sid[x].trim()), kill, this.getId());
                continue;
            }
            catch (NumberFormatException e) {
                if (sid[x].trim().equalsIgnoreCase("ALL")) {
                    return this.dispatcher.killAllJobs(kill, this.getId());
                }
                throw new CfgException("invalid jobid: " + sid[x].trim());
            }
        }
        return true;
    }

    public boolean assign(long jobid, String dest, String src) throws LockException, SQLException, InterruptedException {
        return this.dispatcher.assign(this.con, jobid, dest, src, this.getId());
    }

    public boolean reconfig() {
        return this.dispatcher.reconfig();
    }

    public boolean location() {
        return this.dispatcher.location();
    }

    public boolean writeJoeStat() {
        return this.dispatcher.writeJoeStat();
    }

    public boolean shutdown() {
        return this.dispatcher.shutdownThread();
    }

    public boolean newLogbook() {
        return this.dispatcher.newLogbook();
    }

    public boolean status() throws CfgException {
        String status = this.dispatcher.getStatus() + '\n';
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new ActisFile("spool/prot/status").toFile());
            fos.write(status.getBytes());
        }
        catch (IOException e) {
            throw new CfgException(e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public String evalPar(long jobid, String cmd) throws InterruptedException, CfgException, SQLException {
        IJob job = this.dispatcher.getJob(jobid);
        if (job != null) {
            return job.evalPar(cmd, false, true);
        }
        return null;
    }

    public abstract String[] getParam(String var1, String var2) throws CfgException;
}

