/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.DebPrepStmt;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CtrlEdiComp
extends EdiComp {
    public static final int MAX_NAME_LENGTH = 32;
    private static Log log = LogFactory.getLog((String)"master.CtrlEdiComp");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.CtrlEdiComp");
    private boolean isNew = true;

    private CtrlEdiComp(CtrlEdiComp comp, Job job) {
        super((EdiComp)comp, job);
        this.isNew = comp.isNew;
    }

    public CtrlEdiComp clone(Job job) {
        return new CtrlEdiComp(this, job);
    }

    public CtrlEdiComp(Job job, int creationJS, String name, String fileName, int num) throws ParameterException {
        super(job, creationJS, name, fileName, num);
        if (name == null || name.length() <= 0) {
            throw new ParameterException("no name");
        }
        if (name.length() > 32) {
            throw new ParameterException("name too long (max 32): " + name);
        }
        this.setModificationDate((int)(System.currentTimeMillis() / 1000L));
        this.setCreationDate((int)(System.currentTimeMillis() / 1000L));
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + (Object)((Object)this)));
        }
    }

    public static String getSql() {
        return "select name, filename, creationstep, filesize, creationdate, modificationdate, num from ctrl_edicomp where jobid = ?";
    }

    public CtrlEdiComp(Job job, ResultSet rs) throws SQLException, ParameterException {
        super(job, rs.getInt(3), rs.getString(1), rs.getString(2), rs.getInt(7));
        this.setSize(rs.getLong(4));
        this.setCreationDate(rs.getInt(5));
        this.setModificationDate(rs.getInt(6));
        this.setSaved();
        this.isNew = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + (Object)((Object)this)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Connection con) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        DebPrepStmt update = null;
        if (this.isDirtyFile() || this.isDirtySize() || this.isDirtyCDate() || this.isDirtyMDate()) {
            String sql;
            if (this.isNew) {
                sql = "insert into ctrl_edicomp (filename, filesize, creationdate, modificationdate, jobid, num, name, creationstep) values (?,?,?,?,?,?,?,?)";
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("update ctrl_edicomp set ");
                boolean first = true;
                if (this.isDirtyFile()) {
                    sb.append("filename = ? ");
                    first = false;
                }
                if (this.isDirtySize()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("filesize = ? ");
                }
                if (this.isDirtyCDate()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("creationdate = ? ");
                }
                if (this.isDirtyMDate()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("modificationdate = ? ");
                }
                sb.append("where jobid = ? and num = ?");
                sql = sb.toString();
            }
            update = new DebPrepStmt(con, sql, dbLog);
            int pos = 0;
            try {
                if (this.isNew || this.isDirtyFile()) {
                    update.setString(++pos, this.getFileName());
                }
                if (this.isNew || this.isDirtySize()) {
                    update.setLong(++pos, this.getSize());
                }
                if (this.isNew || this.isDirtyCDate()) {
                    update.setInt(++pos, this.getCreationDate());
                }
                if (this.isNew || this.isDirtyMDate()) {
                    update.setInt(++pos, this.getModificationDate());
                }
                update.setLong(++pos, this.getJobId());
                update.setInt(++pos, this.getNum());
                if (this.isNew) {
                    update.setString(++pos, this.getName());
                    update.setInt(++pos, this.getCreationJs());
                }
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeUpdate: " + update));
                }
                update.executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CtrlEdiComp " + (this.isNew ? "written" : "updated")));
                }
            }
            finally {
                update.close();
            }
            this.setSaved();
            this.isNew = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection con, long jobid) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove EdiComp of job: " + jobid));
        }
        String sql = "delete from ctrl_edicomp where jobid = ?";
        DebPrepStmt delete = null;
        delete = new DebPrepStmt(con, sql, dbLog);
        try {
            delete.setLong(1, jobid);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + delete));
            }
            delete.executeUpdate();
        }
        finally {
            delete.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end:");
        }
    }

    public String toString() {
        return "CtrlEdiComp: " + super.toString() + ", isNew: " + this.isNew;
    }
}

