/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IRemovable;
import de.axway.aim.controller.master.WorkflowResultConnection;
import de.axway.aim.controller.master.command.MatchCmdParam;
import de.axway.aim.controller.master.command.MatchCmdValue;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.message.MessageEncodingException;
import de.axway.lockDaemon.LockException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CtrlEvent
extends Event
implements IRemovable {
    private long removeDate = 0L;
    private static Log log = LogFactory.getLog((String)"master.CtrlEvent");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.CtrlEvent");
    private WorkflowResultConnection wfrConn = null;

    public CtrlEvent(long id, String evAttr) {
        super(id, evAttr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + this));
        }
    }

    public CtrlEvent(long id, Date removeDate) {
        super(id);
        this.removeDate = removeDate.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + this));
        }
    }

    public CtrlEvent(long id, Connection con) throws SQLException {
        super(id);
        this.reload(con);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + this));
        }
    }

    public CtrlEvent(ResultSet rs) throws SQLException {
        super(rs.getLong(1));
        this.removeDate = 1000L * rs.getLong(2);
        this.setType(rs.getInt(3));
        this.setInitiator(rs.getString(4));
        this.setRefNo(rs.getString(5));
        this.setInitiatorHost(rs.getString(6));
        this.setCorefuncId(rs.getString(7));
    }

    public static CtrlEvent getEvent(Connection con, long id) throws SQLException {
        String sql = "select jobid, removedate, type, initiator, reference_no, initiator_host, corefunc_id from ctrl_event where jobid=?";
        try (PreparedStatement stmt = con.prepareStatement(sql);){
            stmt.setLong(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    CtrlEvent ctrlEvent = new CtrlEvent(rs);
                    return ctrlEvent;
                }
                throw new SQLException("event " + id + " not found in db");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(long id, Connection con) throws SQLException {
        String sql = "select jobid from ctrl_event where jobid=?";
        DebPrepStmt select = new DebPrepStmt(con, sql, dbLog);
        ResultSet rs = null;
        try {
            select.setLong(1, id);
            rs = select.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            select.close();
        }
        return false;
    }

    public void setWFRConnection(WorkflowResultConnection wfrConn) {
        this.wfrConn = wfrConn;
    }

    public WorkflowResultConnection getWFRConnection() {
        return this.wfrConn;
    }

    public boolean isWrfConnected() {
        return this.wfrConn != null && this.wfrConn.isConnected();
    }

    public void sendWorkflowResult(boolean close, int rc, Attributes attr) {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: close: " + close + ", rc: " + rc));
                if (attr != null) {
                    Iterator it = attr.get().iterator();
                    while (it.hasNext()) {
                        log.debug((Object)((Attribute)it.next()).toString());
                    }
                }
            }
            if (this.wfrConn != null) {
                try {
                    if (attr != null && attr.size() > 0) {
                        for (int i = 0; this.wfrConn.isConnected() && i < attr.size(); ++i) {
                            if (close && i == attr.size() - 1) {
                                this.sendOneWfr(this.wfrConn, true, rc, attr.elementAt(i));
                                continue;
                            }
                            this.sendOneWfr(this.wfrConn, false, rc, attr.elementAt(i));
                        }
                        break block10;
                    }
                    this.wfrConn.sendWfr(close, rc);
                }
                catch (Exception e) {
                    log.error((Object)"Cannot send workflow result!", (Throwable)e);
                }
            } else {
                log.debug((Object)"No workflow result connection defined.");
            }
        }
        log.debug((Object)"end:");
    }

    private void sendOneWfr(WorkflowResultConnection wfr, boolean close, int rc, Attribute at) throws MessageEncodingException {
        String name = at.getName();
        Object val = at.get();
        if (log.isDebugEnabled()) {
            if (val != null) {
                log.debug((Object)("start: attr.name: " + name + ", attr.val: " + val + ", class: " + val.getClass().getName()));
            } else {
                log.debug((Object)("start: attr.name: " + name + ", attr.val: <null>"));
            }
        }
        if (name.equalsIgnoreCase("TEXT")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Send text in Workflow Result: " + val));
            }
            wfr.sendWfrText(close, rc, val.toString());
        } else if (name.equalsIgnoreCase("FILE")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("send file in Workflow Result: " + val));
            }
            if (val instanceof String) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Send file, name: " + val));
                }
                wfr.sendWfrFile(close, rc, val.toString());
            } else if (val instanceof EdiComp) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Send EDI Object Component: " + val));
                }
                this.wfrConn.sendWfrComp(close, rc, ((EdiComp)val).getFileName(), ((EdiComp)val).getName());
            } else {
                Logbook.getLogbook().warning("File specification of Workflow Result contains unexpected data: " + val);
                log.warn((Object)("File specification of Workflow Result contains unexpected data: " + val));
                log.warn((Object)"Sending data as text message!");
                wfr.sendWfrText(close, rc, val.toString());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Invalid attribute for Workflow Result :" + name + ", value: " + val));
        }
    }

    public void reloadAttr(Connection con) throws SQLException {
        if (this.attr == null) {
            this.attr = new Attributes();
            this.getAttr("ctrl_evtattr", false, con);
        }
    }

    public void reloadParam(Connection con) throws SQLException {
        if (this.params == null) {
            this.params = new Attributes();
            this.getAttr("ctrl_evtparam", true, con);
        }
    }

    public void reload(Connection con) throws SQLException {
        this.reloadAttr(con);
        this.reloadParam(con);
        this.getEventData(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEventData(Connection con) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        String sql = "select type, initiator, reference_no, initiator_host, corefunc_id from ctrl_Event where jobid = ?";
        DebPrepStmt stmt = null;
        stmt = new DebPrepStmt(con, sql, dbLog);
        ResultSet rs = null;
        try {
            stmt.setLong(1, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.setType(rs.getInt(1));
                this.setInitiator(rs.getString(2));
                this.setRefNo(rs.getString(3));
                this.setInitiatorHost(rs.getString(4));
                this.setCorefuncId(rs.getString(5));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttr(String table, boolean param, Connection con) throws SQLException {
        String sql = "select name, value from " + table + " where jobid = ? order by attrno";
        DebPrepStmt stmt = null;
        stmt = new DebPrepStmt(con, sql, dbLog);
        ResultSet rs = null;
        try {
            stmt.setLong(1, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            rs = stmt.executeQuery();
            try {
                while (rs.next()) {
                    if (param) {
                        this.addParam(rs.getString(1), rs.getString(2));
                        continue;
                    }
                    this.addAttr(rs.getString(1), rs.getString(2));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoveDate(Connection con, long date) throws SQLException {
        this.removeDate = date;
        String sql = "update ctrl_event set removedate = ? where jobid = ?";
        DebPrepStmt update = null;
        update = new DebPrepStmt(con, sql, dbLog);
        try {
            update.setLong(1, date / 1000L);
            update.setLong(2, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + update));
            }
            if (update.executeUpdate() != 1) {
                throw new SQLException("event " + this.getId() + " not found to update");
            }
        }
        finally {
            update.close();
        }
    }

    @Override
    public long getRemoveDate() {
        return this.removeDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRefNo(Connection con, String refNo) throws SQLException {
        this.setRefNo(refNo);
        String sql = "update ctrl_event set reference_no = ? where jobid = ?";
        try (DebPrepStmt stmt = new DebPrepStmt(con, sql, dbLog);){
            stmt.setString(1, this.getRefNo());
            stmt.setLong(2, this.getId());
            stmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection con) throws SQLException, LockException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        if (this.getId() < 1L) {
            throw new SQLException("No job id set: " + this.getId());
        }
        String sql = "insert into ctrl_event (jobid, type, initiator, reference_no, initiator_host, corefunc_id)  values (?, ?, ?, ?, ?, ?)";
        DebPrepStmt insert = null;
        insert = new DebPrepStmt(con, sql, dbLog);
        try {
            insert.setLong(1, this.getId());
            insert.setInt(2, this.getType());
            insert.setString(3, this.getInitiator());
            insert.setString(4, this.getRefNo());
            insert.setString(5, this.getInitiatorHost());
            insert.setString(6, this.getCorefuncId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + insert));
            }
            insert.executeUpdate();
        }
        finally {
            insert.close();
        }
        ((IJob)this.getJob()).insert(con);
        if (this.getAttr() != null) {
            this.saveAttr(this.getAttrList(), "ctrl_evtattr", con);
        }
        if (this.getParams() != null) {
            this.saveAttr(this.getParamList(), "ctrl_evtparam", con);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAttr(List attr, String table, Connection con) throws SQLException {
        String sql = "insert into " + table + " (jobid, attrno, name, value) values (?,?,?,?)";
        DebPrepStmt insert = null;
        insert = new DebPrepStmt(con, sql, dbLog);
        int x = 0;
        try {
            for (Attribute a : attr) {
                insert.setLong(1, this.getId());
                insert.setInt(2, x);
                insert.setString(3, a.getName());
                insert.setString(4, (String)a.get());
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeUpdate: " + insert));
                }
                insert.executeUpdate();
                ++x;
            }
        }
        finally {
            insert.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(Connection con, long id, String table) throws SQLException {
        String sql = "delete from " + table + " where jobid=?";
        DebPrepStmt delete = null;
        delete = new DebPrepStmt(con, sql, dbLog);
        try {
            delete.setLong(1, id);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + delete));
            }
            delete.executeUpdate();
        }
        finally {
            delete.close();
        }
    }

    public static void remove(Connection con, long id) throws SQLException {
        CtrlEvent.removeAttrParam(con, id);
        CtrlEvent.remove(con, id, "ctrl_event");
    }

    public static void removeAttrParam(Connection con, long id) throws SQLException {
        CtrlEvent.remove(con, id, "ctrl_evtattr");
        CtrlEvent.remove(con, id, "ctrl_evtparam");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<Long> matchEventAttr(MatchCmdParam partnerSpec, MatchCmdParam senderSpec, MatchCmdParam receiverSpec, MatchCmdParam objClassSpec, Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<Long> jobIds = null;
        StringBuilder selectCmd = null;
        StringBuilder newSelect = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"CtrlEvent.matchEventAttr start: ");
            log.debug((Object)("CtrlEvent.matchEventAttr: " + partnerSpec));
            log.debug((Object)("CtrlEvent.matchEventAttr: " + senderSpec));
            log.debug((Object)("CtrlEvent.matchEventAttr: " + receiverSpec));
            log.debug((Object)("CtrlEvent.matchEventAttr: " + objClassSpec));
        }
        for (MatchCmdParam oneAttr : new MatchCmdParam[]{partnerSpec, senderSpec, receiverSpec, objClassSpec}) {
            if (oneAttr == null || (newSelect = CtrlEvent.buildAttrSelect(oneAttr)) == null) continue;
            if (selectCmd == null) {
                selectCmd = newSelect;
                continue;
            }
            selectCmd.append(" and jobid in (");
            selectCmd.append((CharSequence)newSelect);
            selectCmd.append(")");
        }
        if (selectCmd != null && selectCmd.length() > 0) {
            jobIds = new HashSet<Long>();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Select command for ctrl_evtattr table: ");
                log.debug((Object)selectCmd);
            }
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery(selectCmd.toString());
                while (rs.next()) {
                    jobIds.add(rs.getLong(1));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matching event attribues returns " + jobIds.size() + " job ids"));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return jobIds;
    }

    private static StringBuilder buildAttrSelect(MatchCmdParam param) {
        MatchCmdValue val = null;
        StringBuilder selectCmd = null;
        StringBuilder include = null;
        StringBuilder exclude = null;
        StringBuilder current = null;
        if (!param.hasValues()) {
            return null;
        }
        selectCmd = new StringBuilder();
        include = new StringBuilder();
        exclude = new StringBuilder();
        selectCmd.append("select distinct jobid from ctrl_evtattr ");
        if (param.getName().equals("PARTNER")) {
            selectCmd.append(" where ((ctrl_evtattr.name = 'SENDER' or ctrl_evtattr.name = 'RECEIVER')  and ");
        } else {
            selectCmd.append(" where (ctrl_evtattr.name = '" + param.getName() + "' and ");
        }
        for (int i = 0; i < param.size(); ++i) {
            val = (MatchCmdValue)param.get(i);
            current = val.isInclude() ? include : exclude;
            String strVal = val.getValue().toString();
            strVal = strVal.replace("*", "%");
            strVal = strVal.replace("?", "_");
            if (current.length() > 0) {
                current.append(" or ctrl_evtattr.value like ");
            } else {
                current.append("(ctrl_evtattr.value like ");
            }
            current.append("'");
            current.append(strVal);
            current.append("'");
        }
        if (include.length() > 0) {
            include.append(")");
        }
        if (exclude.length() > 0) {
            exclude.append(")");
        }
        if (include.length() > 0) {
            selectCmd.append((CharSequence)include);
            if (exclude.length() > 0) {
                selectCmd.append(" and not ");
                selectCmd.append((CharSequence)exclude);
            }
        } else {
            selectCmd.append(" not ");
            selectCmd.append((CharSequence)exclude);
        }
        selectCmd.append(")");
        return selectCmd;
    }

    public static HashSet<Long> matchEvent(MatchCmdParam refNoSpec, Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<Long> jobIds = null;
        MatchCmdValue val = null;
        String strVal = null;
        StringBuilder selectCmd = null;
        StringBuilder include = null;
        StringBuilder exclude = null;
        StringBuilder currentCriteria = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"CtrlEvent.matchEvent start: ");
            log.debug((Object)("CtrlEvent.matchEvent: " + refNoSpec));
        }
        if (!refNoSpec.hasValues()) {
            log.debug((Object)"CtrlEvent.matchEvent return: <null>");
            return null;
        }
        selectCmd = new StringBuilder();
        include = new StringBuilder();
        exclude = new StringBuilder();
        for (int i = 0; i < refNoSpec.size(); ++i) {
            val = (MatchCmdValue)refNoSpec.get(i);
            currentCriteria = val.isInclude() ? include : exclude;
            strVal = val.getValue().toString();
            strVal = strVal.replace("*", "%");
            strVal = strVal.replace("?", "_");
            if (currentCriteria.length() > 0) {
                currentCriteria.append(" or reference_no like ");
            } else {
                currentCriteria.append("(reference_no like ");
            }
            currentCriteria.append("'");
            currentCriteria.append(strVal);
            currentCriteria.append("'");
        }
        if (include.length() > 0) {
            include.append(")");
        }
        if (exclude.length() > 0) {
            exclude.append(")");
        }
        selectCmd.append("select distinct jobid from ctrl_event where ");
        if (include.length() > 0) {
            selectCmd.append((CharSequence)include);
            if (exclude.length() > 0) {
                selectCmd.append(" and not ");
                selectCmd.append((CharSequence)exclude);
            }
        } else {
            selectCmd.append(" not ");
            selectCmd.append((CharSequence)exclude);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Select command for ctrl_event table: ");
                log.debug((Object)selectCmd);
            }
            jobIds = new HashSet<Long>();
            stmt = con.createStatement();
            rs = stmt.executeQuery(selectCmd.toString());
            while (rs.next()) {
                jobIds.add(rs.getLong(1));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matching event parameters returns " + jobIds.size() + " job ids"));
            }
        }
        catch (SQLException e) {
            log.error((Object)selectCmd.toString(), (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return jobIds;
    }

    public String toString() {
        return super.toString() + ", removeDate: " + new Date(this.removeDate);
    }
}

