/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.FunctionCall;
import de.axway.aim.controller.lib.JobStep;
import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.FcBuiltin;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.account.FcAccountSums;
import de.axway.aim.controller.master.builtin.Builtin;
import de.axway.aim.controller.master.builtin.UnknownBuiltinException;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.lockDaemon.LockException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CtrlFunctionCall
extends FunctionCall {
    private static Log log = LogFactory.getLog((String)"master.CtrlFunctionCall");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.CtrlFunctionCall");
    private CtrlBuiltin builtin = null;

    public CtrlFunctionCall(String cmd, IJobStep parent, int seqNo, int seqRetry, int level) throws UnknownBuiltinException {
        super(new Attributes(cmd, Attributes.Type.LST, true), (JobStep)parent, parent.getLevel(), seqNo, seqRetry, level);
        if (log.isTraceEnabled()) {
            log.trace((Object)("CtrlFunctionCall(cmd): " + this.getInstanceName() + ", cmd: " + cmd + ", Step: " + (Object)((Object)parent) + ", seqNo: " + seqNo + ", seqRetry: " + seqRetry));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("CtrlFunctionCall(cmd): " + this.getInstanceName() + ", seqNo: " + seqNo + ", seqRetry: " + seqRetry));
        }
        if (cmd.toUpperCase().startsWith("BUILT_IN=")) {
            this.builtin = new FcBuiltin(Builtin.create(cmd), parent);
        }
    }

    public void shrink() {
        super.shrink();
        this.builtin = null;
    }

    public static String getSql(boolean withReal) {
        return "select stepretry, steplevel, seqnr, seqretry, rc, rctype, creationdate, readydate, slave, " + (withReal ? "call_level, realfc " : "call_level ") + "from ctrl_fc where jobid=? and jobstep=? order by stepretry desc, seqnr desc, seqretry desc";
    }

    public CtrlFunctionCall(IJobStep parent, ResultSet rs, boolean withReal, CtrlDispAppl dispatcher) throws SQLException {
        super((Attributes)null, (JobStep)parent, rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(10));
        if (log.isTraceEnabled()) {
            log.trace((Object)("CtrlFunctionCall: " + this.getInstanceName() + ", Step: " + (Object)((Object)parent)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("CtrlFunctionCall(builtin): " + this.getInstanceName()));
        }
        this.rc = rs.getInt(5);
        this.rcType = rs.getInt(6);
        this.setCreationDate(rs.getLong(7));
        this.setReadyDate(rs.getLong(8));
        String slaveName = rs.getString(9);
        CtrlSlave slave = null;
        if (dispatcher != null) {
            slave = dispatcher.getSlave(slaveName);
        }
        if (slave != null) {
            this.setSlave(slave.getName());
        } else {
            this.setSlave(slaveName);
        }
        if (withReal) {
            this.real = rs.getString(11);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + (Object)((Object)this)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CtrlFunctionCall getLastInstance(Connection con, long jobid, int stepNo, Value<Integer> stepRetryValue, Value<Integer> stepLevelValue) throws SQLException {
        int stepRetry = (Integer)stepRetryValue.get();
        int stepLevel = (Integer)stepLevelValue.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: jobId: " + jobid + ", stepNo: " + stepNo + ", stepRetry: " + stepRetry));
        }
        String sql = "select stepretry, steplevel, seqnr, seqretry, rc, rctype, creationdate, readydate, slave, call_level, realfc from ctrl_fc where jobid=? and jobstep=?" + (stepRetry > -1 ? " and stepretry = ? " : " ") + (stepLevel > -1 ? " and steplevel = ? " : " ") + "order by stepretry desc, steplevel desc, seqnr desc, seqretry desc, call_level desc";
        DebPrepStmt stmt = null;
        stmt = new DebPrepStmt(con, sql, dbLog);
        ResultSet rs = null;
        CtrlFunctionCall fc = null;
        try {
            stmt.setLong(1, jobid);
            stmt.setInt(2, stepNo);
            if (stepRetry >= 0) {
                stmt.setInt(3, stepRetry);
                if (stepLevel > -1) {
                    stmt.setInt(4, stepLevel);
                }
            } else if (stepLevel > -1) {
                stmt.setInt(3, stepLevel);
            }
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            if ((rs = stmt.executeQuery()).next()) {
                fc = new CtrlFunctionCall(null, rs, true, null);
                if (stepRetry < 0) {
                    stepRetryValue.updateValue((Object)rs.getInt(1));
                }
                if (stepLevel < 0) {
                    stepLevelValue.updateValue((Object)rs.getInt(2));
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + (Object)((Object)fc)));
        }
        return fc;
    }

    public boolean execBuiltin(CtrlDispAppl dispatcher, Connection con) throws Exception {
        if (this.builtin == null) {
            throw new CfgException("no builtin defined");
        }
        return this.builtin.exec(dispatcher, con);
    }

    public boolean isBuiltin() {
        return this.builtin != null;
    }

    public void setRealFromBuiltin() throws CfgException {
        if (this.builtin == null) {
            throw new CfgException("it is not a builtin");
        }
        this.real = this.builtin.getRealFc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResult(Connection con, CtrlDispAppl dispatcher) throws SQLException, InterruptedException, LockException {
        block11: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: " + this.getInstanceName()));
            }
            String sql = "update ctrl_fc set rc = ?, rctype = ?, readydate = ? where jobid=? AND jobstep=? AND stepretry=? AND steplevel=? AND seqnr=? AND seqretry=? AND call_level=?";
            try (DebPrepStmt update = new DebPrepStmt(con, sql, dbLog);){
                update.setInt(1, this.rc);
                update.setInt(2, this.rcType);
                update.setLong(3, this.getReadyDate());
                update.setLong(4, this.parent.getJobId());
                update.setInt(5, this.parent.getStepNo());
                update.setInt(6, this.parent.getRetry());
                update.setInt(7, this.parent.getLevel());
                update.setInt(8, this.getSeqNo());
                update.setInt(9, this.getSeqRetry());
                update.setInt(10, this.level);
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeUpdate: " + update));
                }
                if (update.executeUpdate() == 1) break block11;
                log.error((Object)("fc " + this.getInstanceName() + " not found in db"));
                sql = "insert into ctrl_fc (jobid, jobstep, stepretry, steplevel, seqnr, seqretry, call_level, rc, rctype, readydate, creationdate) values (?,?,?,?,?,?,?,?,?,?,?)";
                try (DebPrepStmt insert = new DebPrepStmt(con, sql, dbLog);){
                    insert.setLong(1, this.parent.getJobId());
                    insert.setInt(2, this.parent.getStepNo());
                    insert.setInt(3, this.parent.getRetry());
                    insert.setInt(4, this.parent.getLevel());
                    insert.setInt(5, this.getSeqNo());
                    insert.setInt(6, this.getSeqRetry());
                    insert.setInt(7, this.level);
                    insert.setInt(8, this.rc);
                    insert.setInt(9, this.rcType);
                    insert.setLong(10, this.getReadyDate());
                    insert.setLong(11, -1L);
                    insert.executeUpdate();
                }
                dispatcher.stopJob(this.parent.getJobId(), this.parent.getJobId(), con);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection con) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: " + this.getInstanceName()));
        }
        String sql = "insert into ctrl_fc (jobid, jobstep, stepretry, steplevel, seqnr, seqretry, creationdate, call_level, realfc, slave) values (?,?,?,?,?,?,?,?,?,?)";
        DebPrepStmt insert = null;
        insert = new DebPrepStmt(con, sql, dbLog);
        try {
            insert.setLong(1, this.parent.getJobId());
            insert.setInt(2, this.parent.getStepNo());
            insert.setInt(3, this.parent.getRetry());
            insert.setInt(4, this.parent.getLevel());
            insert.setInt(5, this.getSeqNo());
            insert.setInt(6, this.getSeqRetry());
            insert.setLong(7, this.getCreationDate());
            insert.setInt(8, this.level);
            insert.setString(9, this.real);
            insert.setString(10, this.slave);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + insert));
            }
            insert.executeUpdate();
        }
        finally {
            insert.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Connection con) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: " + this.getInstanceName()));
        }
        String sql = "delete from ctrl_fc where jobid=? and jobstep=? and stepretry=? and steplevel=? and seqnr=? and seqretry=? and call_level=?";
        DebPrepStmt delete = null;
        delete = new DebPrepStmt(con, sql, dbLog);
        try {
            delete.setLong(1, this.parent.getJobId());
            delete.setInt(2, this.parent.getStepNo());
            delete.setInt(3, this.parent.getRetry());
            delete.setInt(4, this.parent.getLevel());
            delete.setInt(5, this.getSeqNo());
            delete.setInt(6, this.getSeqRetry());
            delete.setInt(7, this.level);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("remove: " + delete));
            }
            delete.executeUpdate();
        }
        finally {
            delete.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection con, long jobid) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: jobId: " + jobid));
        }
        String sql = "delete from ctrl_fc where jobid=?";
        DebPrepStmt delete = null;
        delete = new DebPrepStmt(con, sql, dbLog);
        try {
            delete.setLong(1, jobid);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + delete));
            }
            delete.executeUpdate();
        }
        finally {
            delete.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end:");
        }
    }

    public String toString() {
        return "CtrlFC: " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FcAccountSums getFcAccountSums(CtrlJob job, Connection con) throws SQLException {
        FcAccountSums fcas = null;
        DebPrepStmt stmt = null;
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: jobId: " + job.getId()));
        }
        String sql = "select max(jobstep), count(*), sum(readydate - creationdate) from ctrl_fc where jobid=?";
        stmt = new DebPrepStmt(con, sql, dbLog);
        int lastStepCount = job.getStatus() == 2 ? 1 : 0;
        try {
            stmt.setLong(1, job.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            if ((rs = stmt.executeQuery()).next()) {
                fcas = new FcAccountSums(rs.getLong(3), rs.getInt(2), rs.getInt(2) - rs.getInt(1) + lastStepCount);
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot query function call sums: ", (Throwable)e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + fcas));
        }
        return fcas;
    }

    public String getFcInstance() {
        CfgFctnEntry cfgFctn;
        CtrlJobStep step = (CtrlJobStep)this.parent;
        try {
            cfgFctn = step.getFctnEntry();
        }
        catch (CfgException e) {
            return null;
        }
        String fcInstance = this.getSeqNo() + "/" + cfgFctn.getSeqCount() + "." + this.getSeqRetry() + "/" + cfgFctn.getMaxSeqRetry(this.getSeqNo());
        return fcInstance;
    }
}

