/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.lib.Result;
import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.lib.Variable;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlEdiComp;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.CtrlJobVar;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.CtrlVar;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.JobConst;
import de.axway.aim.controller.master.NextJobStepException;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.account.FcAccountSums;
import de.axway.aim.controller.master.account.JobAccountSums;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctn;
import de.axway.aim.controller.master.cfg.CfgFctnRcReaction;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.command.MatchCmdParam;
import de.axway.aim.controller.master.command.MatchCmdValue;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import de.axway.lib.util.ActisFile;
import de.axway.lockDaemon.LockException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;

public class CtrlJob
extends IJob<Connection> {
    private long activateDate = 0L;
    private Attributes<String> activateAttr = null;
    private long lastReady = 0L;
    private int lastRc = 0;
    private int runJs = -1;
    private Integer errorCodeJobExit = null;
    private DataSource dataSource = null;
    private static String protfileDir = "spool/prot/";

    public CtrlJob(CtrlJob job) {
        super(job);
        this.initFromJob(job);
    }

    private void initFromJob(CtrlJob job) {
        this.activateDate = job.activateDate;
        if (job.activateAttr != null) {
            this.activateAttr = new Attributes(job.activateAttr);
        }
        this.lastReady = job.lastReady;
        this.lastRc = job.lastRc;
        this.runJs = job.runJs;
        this.dataSource = job.dataSource;
    }

    public void rollback(CtrlJob jobState) {
        super.initFromJob((Job)jobState);
        this.initFromJob(jobState);
    }

    public CtrlJob(long creationDate, Event parent, CfgJSelectEntry jslEntry) {
        super(creationDate, parent, jslEntry);
        if (log.isTraceEnabled()) {
            log.trace((Object)("create job: " + this.getName() + ", created: " + new Date(creationDate) + ", event: " + parent + "\njslEntry: " + (Object)((Object)jslEntry)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("create job: " + this.getName() + ", created: " + new Date(creationDate) + ", event ID: " + parent.getId() + "\njslEntry: " + (Object)((Object)jslEntry)));
        }
        this.lastReady = creationDate;
        if (parent.getAttr() != null) {
            this.setEmptyVarTable();
            this.setEmptyComps();
        }
    }

    public CtrlJob(Event parent, CfgJSelectEntry jslEntry) {
        this(System.currentTimeMillis(), parent, jslEntry);
    }

    @Override
    public int getPrio() {
        CtrlJobStep js = this.getCurrentStep();
        if (js != null) {
            return super.getPrio() + js.getPrio();
        }
        return super.getPrio();
    }

    @Override
    public boolean isGrouped() {
        return this.getCurrentStep().isGrouped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJsRetryFull(int step, CtrlDispAppl dispatcher) throws SQLException {
        if (step < 1 || step > this.getStepCount()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IF_JS_RETRY_FULL: job " + this.getId() + "." + step + ": invalid step"));
            }
            return false;
        }
        CtrlJobStep js = null;
        js = (CtrlJobStep)this.getStep(step);
        if (js == null) {
            int status;
            if (log.isDebugEnabled()) {
                log.debug((Object)("IF_JS_RETRY_FULL: job " + this.getId() + "." + step + ": step is shrinked"));
            }
            try (Connection con = dispatcher.getConnection();){
                con.setReadOnly(true);
                status = CtrlJobStep.getStatus(con, this.getId(), step);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("IF_JS_RETRY_FULL: job " + this.getId() + "." + step + ": " + (status == 32)));
            }
            return status == 32;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("IF_JS_RETRY_FULL: job " + this.getId() + "." + step + ": " + (js.getStatus() == 32)));
        }
        return js.getStatus() == 32;
    }

    @Override
    public List<SlaveHandler> getSlaves() throws CfgException {
        CtrlJobStep js = (CtrlJobStep)((Object)this.steps.get(super.getActiveStep() - 1));
        return js.getSlaves();
    }

    public void termJs(int stepNo, Connection con) throws SQLException {
        CtrlJobStep step = (CtrlJobStep)this.getStep(stepNo);
        if (step == null) {
            log.warn((Object)("job " + this.getId() + " step " + stepNo + " not valid for terminate"));
            return;
        }
        step.termJs(con);
    }

    private void reloadVars() throws SQLException {
        try (Connection con = this.dataSource.getConnection();){
            this.reloadVarTable(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadVarTable(Connection con) throws SQLException {
        con.setReadOnly(true);
        ((CtrlEvent)this.getEvt()).reload(con);
        this.getEvt().setJob((Job)this);
        String sql = "select name, value from ctrl_jobvar where jobid = ? order by num";
        try (DebPrepStmt stmt = new DebPrepStmt(con, sql, dbLog);){
            stmt.setLong(1, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    CtrlJobVar v = new CtrlJobVar(rs.getString(2), rs.getString(1), this.getId(), this.getVarTable() == null ? 0 : this.getVarTable().size(), true);
                    this.setInternalVar(v.getName(), v);
                }
            }
        }
        if (this.getVarTable() == null) {
            this.setEmptyVarTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadComps() throws SQLException {
        try (Connection con = this.dataSource.getConnection();){
            con.setReadOnly(true);
            String sql = CtrlEdiComp.getSql();
            try (DebPrepStmt stmt = new DebPrepStmt(con, sql, dbLog);){
                stmt.setLong(1, this.getId());
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        try {
                            this.addComp(new CtrlEdiComp(this, rs));
                        }
                        catch (ParameterException parameterException) {}
                    }
                }
            }
        }
        if (this.getAllComps() == null) {
            this.setEmptyComps();
        }
    }

    public void unsetRunJs() {
        this.runJs = -1;
    }

    public void stopJob(Connection con) throws SQLException {
        this.activate(con);
        this.setStatus(6);
        CtrlJobStep js = this.getCurrentStep();
        if (js != null) {
            js.stopped(con);
        }
        this.runJs = -1;
    }

    public boolean jobExit(int exitCode, Connection con) throws SQLException {
        this.activate(con);
        if (exitCode == 0) {
            this.setStatus(4);
            log.info((Object)("JobExit: Setting status Remove for job: " + this.getId()));
        } else {
            this.setStatus(2);
            log.info((Object)("JobExit: Setting status Error for job: " + this.getId()));
        }
        this.errorCodeJobExit = exitCode;
        return true;
    }

    public boolean isRunJs() {
        return this.runJs > -1;
    }

    public boolean runJs(int stepNo, Connection con) throws SQLException {
        CtrlJobStep step;
        int oldActive = this.activeStep;
        int oldStatus = this.getStatus();
        if (stepNo == -1) {
            if (this.getStatus() == 4) {
                return false;
            }
            stepNo = this.activeStep;
        }
        if ((step = (CtrlJobStep)this.getStep(stepNo)).getStatus() != 1) {
            step.setReadyToRun(con);
        }
        if (stepNo < 0 || stepNo == this.activeStep) {
            if (this.getStatus() == 5) {
                return false;
            }
            this.activate(con);
            this.setStatus(1);
        } else {
            this.activeStep = stepNo;
        }
        switch (oldStatus) {
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                step.setLevel(0);
            }
        }
        this.update(con);
        this.runJs = oldActive;
        return true;
    }

    public CtrlJobStep getCurrentStep() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentStep start: runJs: " + this.runJs + ", activeStep: " + this.activeStep));
        }
        if (this.getActiveStep() > this.getStepCount()) {
            return null;
        }
        if (this.getActiveStep() > this.steps.size()) {
            return null;
        }
        return (CtrlJobStep)((Object)this.steps.get(this.getActiveStep() - 1));
    }

    @Override
    public CtrlFunctionCall getLastFc() {
        CtrlJobStep js = this.getCurrentStep();
        if (js == null) {
            return null;
        }
        return this.getCurrentStep().getLastFc();
    }

    public boolean matchActivateAttrOld(Attribute<String> attr) {
        if (this.activateAttr == null) {
            return false;
        }
        String ja = (String)this.activateAttr.get(attr.getName());
        if (ja == null) {
            return false;
        }
        if (ja == null && attr.get() == null) {
            return true;
        }
        if (ja == null || attr.get() == null) {
            return false;
        }
        return ja.equals(attr.get());
    }

    @Override
    public boolean matchActivateAttr(Attribute<String> toCheck) {
        if (this.activateAttr == null || toCheck == null || toCheck.getName() == null) {
            return false;
        }
        String toCheckName = toCheck.getName();
        String toCheckVal = (String)toCheck.get();
        Collection attrs = this.activateAttr.values();
        for (Attribute attr : attrs) {
            if (!CtrlJob.matchString(attr.getName(), toCheckName) || !CtrlJob.matchString((String)attr.get(), toCheckVal)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchString(String source, String target) {
        if (source == null && target == null) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        String s = source.toLowerCase();
        String t = target.toLowerCase();
        int ls = s.length();
        int lt = t.length();
        int cs = 0;
        int ct = 0;
        boolean sStar = false;
        boolean tStar = false;
        while (cs < ls && ct < lt) {
            char sChar = s.charAt(cs);
            char tChar = t.charAt(ct);
            if (sChar == '?' || tChar == '?') {
                ++cs;
                ++ct;
                continue;
            }
            if (sChar == '*') {
                sStar = true;
                ++cs;
                continue;
            }
            if (tChar == '*') {
                tStar = true;
                ++ct;
                continue;
            }
            if (sChar == tChar) {
                sStar = false;
                tStar = false;
                ++cs;
                ++ct;
                continue;
            }
            if (!sStar && !tStar) {
                return false;
            }
            if (sStar) {
                ++ct;
                continue;
            }
            if (!tStar) continue;
            ++cs;
        }
        if (cs < ls && !tStar && !"*".equals(s.substring(cs))) {
            return false;
        }
        return ct >= lt || sStar || "*".equals(t.substring(ct));
    }

    @Override
    public void activate(Connection con) throws SQLException {
        if (this.isSuspended()) {
            this.setUnsuspended();
            this.dropActivateAttr(con);
            this.updateSusp(con);
            CtrlJobStep js = this.getCurrentStep();
            if (js != null) {
                js.activate(con);
            }
        }
    }

    @Override
    public void suspend(long time, Attributes<String> activateAttr, Connection con) throws SQLException {
        this.activateDate = time > 0L ? System.currentTimeMillis() + time * 1000L : 0L;
        this.setActivateAttr(activateAttr);
        if (this.isSuspended()) {
            this.dropActivateAttr(con);
        }
        this.setSuspended();
        if (activateAttr != null) {
            this.saveActivateAttr(con);
        }
        this.updateSusp(con);
        this.getCurrentStep().suspended(con);
    }

    public void setActivateAttr(Attributes<String> activateAttr) {
        this.activateAttr = activateAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSusp(Connection con) throws SQLException {
        String sql = "update ctrl_job set susp=? where id=?";
        DebPrepStmt update = null;
        update = new DebPrepStmt(con, sql, dbLog);
        try {
            update.setInt(1, this.isSuspended() ? 1 : 0);
            update.setLong(2, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + update));
            }
            if (update.executeUpdate() != 1) {
                dbLog.error((Object)("Job " + this.getId() + " not found to update."));
                throw new SQLException("Job " + this.getId() + " not found to update");
            }
        }
        finally {
            update.close();
        }
    }

    @Override
    public long getActivateDate() {
        if (this.activateDate <= 0L) {
            return Long.MAX_VALUE;
        }
        return this.activateDate;
    }

    @Override
    public String evalPar(String cmd, boolean quoteEmpty, boolean evalComps) throws CfgException, SQLException {
        if (this.getVarTable() == null) {
            this.reloadVars();
        }
        CtrlJob job4comps = evalComps ? this : null;
        Attributes jslPars = this.jslEntry.getPar();
        List pars = jslPars.get();
        this.replaceValues(pars);
        String jslCmd = CtrlVar.eval(cmd, false, Ediboss.isKeepEmptyVars(), job4comps, 0, new Map[]{this.getConst(), this.getVarTable(), this.getEvt().getAttr(), this.getEvt().getParams(), jslPars});
        String evtConstCmd = CtrlVar.eval(jslCmd, !Ediboss.isKeepUnknownVars(), quoteEmpty, job4comps, new Map[]{this.getVarTable(), this.getEvt().getAttr(), this.getEvt().getParams(), this.getConst()});
        return evtConstCmd;
    }

    private void replaceValues(List<Attribute<String>> pars) {
        Attribute<String> parameter;
        int i;
        HashMap<String, String> hashParVal = new HashMap<String, String>();
        boolean replaceNeeded = false;
        for (i = 0; i < pars.size(); ++i) {
            parameter = pars.get(i);
            String name = parameter.getName();
            String value = (String)parameter.get();
            hashParVal.put(name, value);
            if (value == null || !value.contains("$(")) continue;
            replaceNeeded = true;
        }
        if (replaceNeeded) {
            block1: for (i = 0; i < pars.size(); ++i) {
                String paramValueOriginal;
                String origName;
                parameter = pars.get(i);
                String name = origName = parameter.getName();
                String paramValueCopy = paramValueOriginal = (String)parameter.get();
                int noOfReplacements = 0;
                while (this.isReplaceNeeded(paramValueCopy)) {
                    int endParamName;
                    if (++noOfReplacements > 100) {
                        log.error((Object)("The evaluation of the parameter " + origName + " generated an infinite loop. "));
                        continue block1;
                    }
                    int startParamName = paramValueCopy.indexOf("$(");
                    String replacePar = paramValueCopy.substring(startParamName + 2, endParamName = paramValueCopy.indexOf(")", startParamName));
                    if (hashParVal.containsKey(replacePar)) {
                        String value = (String)hashParVal.get(replacePar);
                        if (value.contains("$(" + replacePar + ")")) {
                            log.error((Object)("The evaluation of the parameter " + origName + " is " + value + " and contains " + replacePar + ". Please change de configuration in order not to generate an infinite loop. "));
                            continue block1;
                        }
                        paramValueCopy = paramValueCopy.replace("$(" + replacePar + ")", value);
                        paramValueOriginal = paramValueOriginal.replace("$(" + replacePar + ")", value);
                        parameter.updateValue((Object)paramValueOriginal.replace("$(" + replacePar + ")", value));
                        pars.set(i, parameter);
                        hashParVal.put(name, paramValueOriginal);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("The value of parameter " + name + " has been replaced with " + value + "."));
                        continue;
                    }
                    if (endParamName + 1 > paramValueCopy.length()) continue block1;
                    paramValueCopy = paramValueCopy.substring(endParamName + 1);
                }
            }
        }
    }

    private boolean isReplaceNeeded(String paramValue) {
        if (paramValue != null) {
            int startParamName = paramValue.indexOf("$(");
            int endParamName = paramValue.indexOf(")", startParamName);
            return paramValue != null && paramValue.contains("$(") && startParamName + 2 <= endParamName;
        }
        return false;
    }

    public static String getSql() {
        return "select id, step, status, susp, prio, seq, creationDate, compslave, susp_time, lastReady, lastRc, jslid from ctrl_job order by id";
    }

    public CtrlJob(Event parent, ResultSet rs, CfgJSelectEntry jslEntry, CtrlDispAppl dispatcher) throws SQLException {
        this(rs.getLong(7) * 1000L, parent, jslEntry);
        this.activeStep = rs.getInt(2);
        this.setStatus(rs.getInt(3));
        if (rs.getInt(4) == 0) {
            this.setUnsuspended();
        } else {
            this.setSuspended();
        }
        this.setPrio(rs.getInt(5));
        this.setSeq(rs.getInt(6) != 0);
        String slaveName = rs.getString(8);
        if (slaveName != null && slaveName.length() > 0) {
            this.setCompSlave(dispatcher.getSlave(slaveName));
        }
        this.activateDate = rs.getLong(9) * 1000L;
        this.lastReady = rs.getLong(10);
        this.lastRc = rs.getInt(11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadSteps(Connection con) throws SQLException {
        CtrlJobStep js;
        DebPrepStmt stmt = null;
        stmt = new DebPrepStmt(con, CtrlJobStep.getSql(false), dbLog);
        ResultSet rsjs = null;
        try {
            stmt.setLong(1, this.getId());
            stmt.setLong(2, 1L);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            rsjs = stmt.executeQuery();
            while (rsjs.next()) {
                js = new CtrlJobStep((Job)this, rsjs, ((CfgJSelectEntry)this.jslEntry).getJobEntry());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("new step created: job id: " + this.getId() + ", js: " + (Object)((Object)js)));
                }
                try {
                    this.addStep(js);
                }
                catch (Exception e) {
                    log.error((Object)"addStep", (Throwable)e);
                }
                Value stepRetry = new Value((Object)-1);
                Value stepLevel = new Value((Object)-1);
                js.setLastFC(CtrlFunctionCall.getLastInstance(con, this.getId(), js.getStepNo(), (Value<Integer>)stepRetry, (Value<Integer>)stepLevel));
                js.setRetry((Integer)stepRetry.get());
                js.setLevel((Integer)stepLevel.get());
            }
        }
        finally {
            if (rsjs != null) {
                rsjs.close();
            }
            stmt.close();
        }
        js = this.getCurrentStep();
        if (js != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set next exec time for step : " + js.getJobId() + "." + js.getStepNo() + ", base time: " + new Date(this.lastReady)));
            }
            js.setNextExecTime(this.lastReady);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CtrlJob getJob(long jobid, CtrlDispAppl dispatcher) throws SQLException, ParameterException {
        CtrlJob job;
        block11: {
            DataSource dataSource = dispatcher.getDataSource();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJob start: ID: " + jobid));
            }
            String sql = "select id, step, status, susp, prio, seq, creationDate, compslave, susp_time, lastReady, lastRc, jslid from ctrl_job where id = ?";
            DebPrepStmt stmt = null;
            ResultSet rs = null;
            job = null;
            CtrlEvent event = null;
            Connection con = dataSource.getConnection();
            try {
                con.setReadOnly(true);
                stmt = new DebPrepStmt(con, sql, dbLog);
                stmt.setLong(1, jobid);
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeQuery: " + stmt));
                }
                if ((rs = stmt.executeQuery()).next()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getJob load JSelect data for job ID: " + jobid + ", jslid: " + rs.getInt(12)));
                    }
                    CfgJSelectEntry oldjsl = CfgJSelectEntry.load(dataSource, rs.getInt(12), dispatcher.getCfgRc(), dispatcher.getCfgTimeWindow());
                    event = CtrlEvent.getEvent(con, rs.getLong(1));
                    job = new CtrlJob(event, rs, oldjsl, dispatcher);
                    job.reloadSteps(con);
                    event.setJob(job);
                    try {
                        job.setFctn(dispatcher.getCfg(), dispatcher.getDataSource());
                    }
                    catch (CfgException cfgException) {
                        // empty catch block
                    }
                    job.reloadVars();
                    job.reloadComps();
                    break block11;
                }
                dbLog.error((Object)("Job " + jobid + " not found in db"));
                throw new SQLException("Job " + jobid + " not found in db");
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                con.close();
            }
        }
        return job;
    }

    public int varCount() throws SQLException {
        if (this.getVarTable() == null) {
            this.reloadVars();
        }
        return this.getVarTable().size();
    }

    public Enumeration<String> getVarKeys() throws SQLException {
        if (this.getVarTable() == null) {
            this.reloadVars();
        }
        return this.getVarTable().keys();
    }

    private void setVar(CtrlJobVar var) throws SQLException {
        if (this.getVarTable() == null) {
            this.reloadVars();
        }
        super.setInternalVar(var.getName(), (Variable)var);
    }

    private void setVar(String name, String value, boolean saved) throws SQLException {
        this.setVar(new CtrlJobVar(value, name, this.getId(), this.varCount(), saved));
    }

    public void setVar(Connection con, String name, String value) throws SQLException {
        if (name.equals("EDIOBJ.REFNO")) {
            ((CtrlEvent)this.getEvt()).updateRefNo(con, value);
        } else {
            this.setVar(new CtrlJobVar(value, name, this.getId(), this.varCount()));
        }
    }

    public void setFctn(CfgFctn cfgFctn, DataSource dataSource) throws CfgException {
        this.dataSource = dataSource;
        Iterator it = this.steps.iterator();
        while (it.hasNext()) {
            ((CtrlJobStep)((Object)it.next())).setFctn(cfgFctn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection con) throws SQLException, LockException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start: ");
        }
        String sql = "insert into ctrl_job (id, step, status, susp, prio, seq, creationdate, compslave, lastready, jslid) values (?,?,?,?,?,?,?,?,?,?)";
        DebPrepStmt insert = null;
        insert = new DebPrepStmt(con, sql, dbLog);
        try {
            insert.setLong(1, this.getId());
            insert.setInt(2, this.activeStep);
            insert.setInt(3, this.getStatus());
            insert.setInt(4, this.isSuspended() ? 1 : 0);
            insert.setInt(5, super.getPrio());
            insert.setInt(6, this.isSeq() ? 1 : 0);
            insert.setLong(7, this.getCreationDate() / 1000L);
            if (this.getCompSlave() != null) {
                insert.setString(8, this.getCompSlave().getName());
            } else {
                insert.setString(8, "");
            }
            insert.setLong(9, this.lastReady);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + insert));
            }
            insert.setLong(10, this.getJslId());
            insert.executeUpdate();
        }
        finally {
            insert.close();
        }
        Iterator<Object> it = this.steps.iterator();
        while (it.hasNext()) {
            ((CtrlJobStep)((Object)it.next())).insert(con);
        }
        this.writeVars(con, false);
        it = this.getComps().iterator();
        while (it.hasNext()) {
            ((CtrlEdiComp)((Object)it.next())).save(con);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: ");
        }
    }

    private void setRetrySkipFail(int isRunnable, CfgFctnRcReaction.Action rcr, Connection con, CtrlJobStep js) throws CfgException, SQLException {
        if (isRunnable > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"set status RETRY");
            }
            this.setStatus(3);
            if (!js.assignModesContains(8192)) {
                long start = System.currentTimeMillis();
                switch (rcr) {
                    case RETRY: {
                        if (!js.assignModesContains(2)) break;
                        js.execAssign(con);
                        break;
                    }
                    case SKIP: {
                        if (!js.assignModesContains(4)) break;
                        js.execAssign(con);
                        break;
                    }
                    case FAIL: {
                        if (!js.assignModesContains(16)) break;
                        js.execAssign(con);
                    }
                }
                WorkerThread.addDbTime(System.currentTimeMillis() - start);
            }
            if (isRunnable > 1) {
                js.setLevel();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"set status ERROR");
            }
            this.setStatus(2);
            long start = System.currentTimeMillis();
            js.retryFull(con);
            if (!js.assignModesContains(8192)) {
                switch (rcr) {
                    case RETRY: 
                    case SKIP: 
                    case FAIL: {
                        if (!js.assignModesContains(23)) break;
                        js.execAssign(con);
                    }
                }
            }
            WorkerThread.addDbTime(System.currentTimeMillis() - start);
        }
    }

    public boolean setResult(Result res, Connection con, CtrlSlave resultSlave, CtrlDispAppl dispatcher) throws SQLException, InterruptedException, CfgException, LockException {
        int i;
        boolean isOk = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("start: job: " + this + ", result: " + res + ", slave: " + resultSlave));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("start: jobId: " + this.getId() + ", rc: " + res.getRc() + ", instance: " + res.getInstanceName() + ", slave: " + resultSlave.getName()));
        }
        CtrlJobStep js = (CtrlJobStep)((Object)this.steps.get(res.getStepNo() - 1));
        if (js == null) {
            throw new SQLException("Step not found Job ID: " + this.getId() + ", step: " + res.getStepNo());
        }
        long start = System.currentTimeMillis();
        if (this.getVarTable() == null || this.getVarTable().size() == 0 && !js.assignModesContains(8192)) {
            this.reloadVarTable(con);
        }
        if (System.getenv("reloadVartableAlways") != null && System.getenv("reloadVartableAlways").equalsIgnoreCase("true") && (this.getVarTable() == null || this.getVarTable().size() == 0)) {
            this.reloadVarTable(con);
        }
        js.setActive(con, false);
        js.setSlaveExecution(resultSlave.getName());
        WorkerThread.addDbTime(System.currentTimeMillis() - start);
        CtrlFunctionCall fc = js.getLastFc();
        if (log.isTraceEnabled()) {
            log.trace((Object)("step: " + (Object)((Object)js)));
            log.trace((Object)("function call: " + (Object)((Object)fc)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("id: " + this.getId() + "." + js.getStepNo() + "." + js.getRetry()));
        }
        long now = System.currentTimeMillis();
        fc.setReadyDate(now);
        this.lastReady = now;
        if (this.errorCodeJobExit != null) {
            res.setRc(this.errorCodeJobExit.intValue());
        }
        fc.setRc(res.getRc());
        this.lastRc = res.getRc();
        fc.setRcType(res.getRcType());
        start = System.currentTimeMillis();
        fc.saveResult(con, dispatcher);
        this.setAllVars(con, res.getVars());
        WorkerThread.addDbTime(System.currentTimeMillis() - start);
        if (log.isDebugEnabled()) {
            log.debug((Object)("New job variables set: " + res.getVars()));
        }
        try {
            this.setAllComps(res.getComps(), con);
        }
        catch (ParameterException pex) {
            this.stopJob(con);
            Logbook.getLogbook().stopJob(this);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("New/changed EDI object components set: " + res.getComps()));
        }
        if (res.getComps() != null && res.getComps().size() > 0) {
            this.setCompSlave(resultSlave);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Component slave set: " + resultSlave));
            }
        }
        CfgFctnRcReaction rcr = js.getLastRc();
        if (this.errorCodeJobExit != null && this.errorCodeJobExit != 0) {
            this.setStatus(2);
            rcr = CfgFctnRcReaction.RcFail;
            for (i = res.getStepNo(); i < this.steps.size(); ++i) {
                ((CtrlJobStep)((Object)this.steps.get(i))).termJs(con);
            }
            log.info((Object)("JOB_EXIT was executed for jobId: " + js.getJobId() + " with rc: " + js.getLastFc().getRc() + ". Terminate all steps except current step."));
        }
        if (this.errorCodeJobExit != null && this.errorCodeJobExit == 0) {
            this.setStatus(4);
            rcr = CfgFctnRcReaction.RcReturn;
            for (i = res.getStepNo() - 1; i < this.steps.size(); ++i) {
                ((CtrlJobStep)((Object)this.steps.get(i))).termJs(con);
            }
            log.info((Object)("JOB_EXIT was executed for jobId: " + js.getJobId() + " with rc: " + js.getLastFc().getRc() + ". Terminate all following steps."));
        }
        if (this.getStatus() != 6 && this.getStatus() != 4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("rc reaction is " + (Object)((Object)rcr.getAction())));
            }
            switch (rcr.getAction()) {
                case RETURN: {
                    isOk = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"rc reaction is RcReturn");
                    }
                    start = System.currentTimeMillis();
                    if (!js.assignModesContains(8192)) {
                        js.execAssign(con);
                    }
                    js.termJs(con);
                    WorkerThread.addDbTime(System.currentTimeMillis() - start);
                    if (this.isRunJs() && this.activeStep != js.getStepNo() || !this.setNextJs()) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("set next exec time for step: " + js.getJobId() + "." + js.getStepNo() + ", base time getReadyDate: " + new Date(fc.getReadyDate())));
                    }
                    ((CtrlJobStep)this.getStep(this.activeStep)).setNextExecTime(fc.getReadyDate());
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("next exec time set: " + new Date(((CtrlJobStep)this.getStep(this.activeStep)).getNextExecTime())));
                    break;
                }
                case FAIL: {
                    try {
                        if (this.errorCodeJobExit != null) {
                            js.setStatus(2048);
                        }
                        if (js.getStatus() == 16) {
                            this.setNextJs();
                            isOk = true;
                            break;
                        }
                        if (this.errorCodeJobExit != null) {
                            this.setRetrySkipFail(-1, rcr.getAction(), con, js);
                            break;
                        }
                        this.setRetrySkipFail(js.isRunnable(true), rcr.getAction(), con, js);
                    }
                    catch (NextJobStepException e) {
                        if (this.isRunJs() && this.activeStep != js.getStepNo()) break;
                        js.retryFull(con);
                        if (this.setNextJs()) {
                            ((CtrlJobStep)this.getStep(this.activeStep)).setNextExecTime(fc.getReadyDate());
                        }
                        isOk = true;
                    }
                    break;
                }
                case RETRY: 
                case SKIP: {
                    try {
                        if (js.getStatus() == 16) {
                            this.setNextJs();
                            isOk = true;
                            break;
                        }
                        this.setRetrySkipFail(js.isRunnable(false), rcr.getAction(), con, js);
                    }
                    catch (NextJobStepException e) {
                        if (this.isRunJs() && this.activeStep != js.getStepNo()) break;
                        js.retryFull(con);
                        if (this.setNextJs()) {
                            ((CtrlJobStep)this.getStep(this.activeStep)).setNextExecTime(fc.getReadyDate());
                        }
                        isOk = true;
                    }
                    break;
                }
                case STOP_JOB: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"set status STOPPED");
                    }
                    this.setStatus(6);
                    js.stopped(con);
                    break;
                }
                case SUSPEND_JOB: {
                    if (!js.assignModesContains(8192) && js.assignModesContains(1024)) {
                        js.execAssign(con);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"set status OK");
                    }
                    this.setStatus(1);
                    js.suspended(con);
                    this.setSuspended();
                    break;
                }
                case EXCEPTION: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"set status RETRY");
                    }
                    this.setStatus(3);
                    if (js.assignModesContains(8192) || !js.assignModesContains(1)) break;
                    js.execAssign(con);
                    break;
                }
                default: {
                    log.error((Object)("unknown rc reaction " + rcr));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"rc reaction is something else -> set status ERROR");
                    }
                    this.setStatus(2);
                    if (js.assignModesContains(8192) || !js.assignModesContains(23)) break;
                    js.execAssign(con);
                }
            }
        }
        start = System.currentTimeMillis();
        this.update(con);
        WorkerThread.addDbTime(System.currentTimeMillis() - start);
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + isOk));
        }
        return isOk;
    }

    private void setAllVars(Connection con, Hashtable<String, Value<String>> vars) throws SQLException {
        if (vars == null) {
            return;
        }
        Enumeration<String> en = vars.keys();
        while (en.hasMoreElements()) {
            String k = en.nextElement();
            this.setVar(con, k, (String)vars.get(k).get());
        }
    }

    protected boolean setNextJs() throws CfgException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: ID: " + this.getId()));
        }
        this.activeStep = 0;
        block11: while (this.activeStep < this.steps.size()) {
            CtrlJobStep step;
            ++this.activeStep;
            if (log.isDebugEnabled()) {
                log.debug((Object)("nextjs: " + this.activeStep + " runjs: " + this.runJs));
            }
            if (((step = (CtrlJobStep)this.getStep(this.activeStep)).getStatus() & 0x10) == 16) continue;
            CfgFctnRcReaction rc = step.getLastRc();
            if (rc == null) {
                this.setStatus(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Id: " + this.getId() + " end: true"));
                }
                return true;
            }
            try {
                switch (rc.getAction()) {
                    case RETURN: {
                        if (!log.isDebugEnabled()) continue block11;
                        log.debug((Object)("Id: " + this.getId() + " rc is RcReturn"));
                        break;
                    }
                    case RETRY: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " rc is RcRetry"));
                        }
                        if (step.isRunnable(false) > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " set status RETRY"));
                            }
                            this.setStatus(3);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " end: true"));
                            }
                            return true;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " set status ERROR"));
                        }
                        this.setStatus(2);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " end: false"));
                        }
                        return false;
                    }
                    case FAIL: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " rc is RcFail. Set status ERROR"));
                        }
                        if (step.isRunnable(true) > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " set status RETRY"));
                            }
                            this.setStatus(3);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " end: true"));
                            }
                            return true;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " set status ERROR"));
                        }
                        this.setStatus(2);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " end: false"));
                        }
                        return false;
                    }
                    case SKIP: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " rc is RcSkip"));
                        }
                        if (step.isRunnable(false) > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " set status  OK"));
                            }
                            this.setStatus(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " end: true"));
                            }
                            return true;
                        }
                        if (!log.isDebugEnabled()) continue block11;
                        log.debug((Object)("Id: " + this.getId() + " remove active step"));
                        break;
                    }
                    case STOP_JOB: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " rc is RcStopJob, set status STOPPED"));
                        }
                        this.setStatus(6);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " end: false"));
                        }
                        return false;
                    }
                    case SUSPEND_JOB: {
                        if (!log.isDebugEnabled()) continue block11;
                        log.debug((Object)("Id: " + this.getId() + " rc is RcSuspendJob, remove active stop"));
                        break;
                    }
                    case EXCEPTION: {
                        if (step.isRunnable(false) > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " set status OK"));
                            }
                            this.setStatus(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Id: " + this.getId() + " end: true"));
                            }
                            return true;
                        }
                        this.setStatus(2);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Id: " + this.getId() + " set status ERROR"));
                            log.debug((Object)("Id: " + this.getId() + " end: false"));
                        }
                        return false;
                    }
                    default: {
                        throw new CfgException("unknown rc");
                    }
                }
            }
            catch (NextJobStepException nextJobStepException) {}
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Id: " + this.getId() + " set status REMOVE"));
        }
        this.setStatus(4);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Id: " + this.getId() + " end: false"));
        }
        return false;
    }

    public int getRemoveDelay() {
        return ((CfgJSelectEntry)this.getJsl()).getJobEntry().getRemoveDelay();
    }

    @Override
    public long getRemoveDate() {
        return this.lastReady + (long)this.getRemoveDelay() * 1000L;
    }

    public long getLastReady() {
        return this.lastReady;
    }

    public int getLastRc() {
        return this.lastRc;
    }

    public Hashtable<String, Value<String>> getConst() {
        return new JobConst(this).getTable();
    }

    public int getActiveStep() {
        if (this.isRunJs()) {
            return this.runJs;
        }
        return super.getActiveStep();
    }

    @Override
    public long getNextExecTime() {
        if (this.isRunJs()) {
            log.debug((Object)"runJs -> no timewindow");
            return 0L;
        }
        long nextTime = 0L;
        if (this.getCurrentStep() != null) {
            nextTime = this.getCurrentStep().getNextExecTime();
        }
        if (((CfgJSelectEntry)this.getJsl()).getTimeWindow() != null) {
            NormalizedTimewindow window = ((CfgJSelectEntry)this.getJsl()).getNormalizedTimewindow();
            if (window != null) {
                Date nearest = window.getNearest(new Date(), null);
                if (nearest == null) {
                    return 2147483647000L;
                }
                nextTime = Math.max(nextTime, nearest.getTime());
            } else {
                log.debug((Object)"no normalized timewindow");
            }
        } else {
            log.debug((Object)"no jsl timewindow");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("next exec time: " + new Date(nextTime)));
        }
        return nextTime;
    }

    public void shrink() {
        this.getEvt().shrink();
        super.shrink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection con) throws SQLException {
        String sql = "update ctrl_job set status=?, step=?, compslave=?, susp_time=?, lastReady=?, lastRc=?, prio=? where id=?";
        DebPrepStmt update = null;
        update = new DebPrepStmt(con, sql, dbLog);
        try {
            update.setInt(1, this.getStatus());
            update.setInt(2, this.activeStep);
            if (this.getCompSlave() != null) {
                update.setString(3, this.getCompSlave().getName());
            } else {
                update.setString(3, "");
            }
            update.setLong(4, this.activateDate / 1000L);
            update.setLong(5, this.lastReady);
            update.setInt(6, this.lastRc);
            update.setInt(7, this.getPrio());
            update.setLong(8, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + update));
            }
            if (update.executeUpdate() != 1) {
                dbLog.error((Object)("Job not found to update ID: " + this.getId()));
                throw new SQLException("Job not found to update ID: " + this.getId());
            }
        }
        finally {
            update.close();
        }
        this.writeVars(con, true);
        Collection<EdiComp> comps = this.getComps();
        if (comps != null) {
            Iterator<EdiComp> it = comps.iterator();
            while (it.hasNext()) {
                ((CtrlEdiComp)it.next()).save(con);
            }
        }
    }

    private void writeVars(Connection con, boolean reload) throws SQLException {
        Enumeration e;
        if (this.getVarTable() == null) {
            if (reload) {
                this.reloadVars();
            } else {
                return;
            }
        }
        if ((e = this.getVarTable().elements()) == null) {
            return;
        }
        while (e.hasMoreElements()) {
            try {
                ((Variable)e.nextElement()).save((Object)con);
            }
            catch (IOException ec) {
                SQLException se = new SQLException(ec.getMessage());
                se.initCause(ec);
                log.warn((Object)("The variables table of the job " + this.getId() + " will be emptied and then reloaded (reinit from database)."));
                this.setEmptyVarTable();
                this.reloadVars();
                throw se;
            }
        }
    }

    private void insertAllVars(Connection con, List<Variable<String, Connection>> listVars) throws SQLException {
        boolean autoCommitBkp = con.getAutoCommit();
        if (listVars != null && listVars.size() > 0) {
            con.setAutoCommit(false);
        }
        for (Variable<String, Connection> var : listVars) {
            try {
                con.createStatement();
            }
            catch (SQLException e) {
                con.setAutoCommit(autoCommitBkp);
                throw e;
            }
        }
        con.setAutoCommit(autoCommitBkp);
    }

    public Collection<EdiComp> getComps() throws SQLException {
        if (super.getAllComps() == null) {
            this.reloadComps();
        }
        return super.getAllComps();
    }

    private void setAllComps(List<EdiComp> comps, Connection con) throws SQLException, ParameterException {
        int errorCount = 0;
        for (EdiComp oneComp : comps) {
            try {
                EdiComp yaComp = this.newComp(oneComp.getName(), oneComp.getFileName());
                yaComp.setSize(oneComp.getSize());
            }
            catch (ParameterException e) {
                Logbook.getLogbook().error("Job " + this.getId() + " new comp " + oneComp.getName() + ": " + (Object)((Object)e));
                ++errorCount;
            }
        }
        if (comps.size() > 0) {
            Logbook.getLogbook().object(this.getCompSlave() == null ? "undefined Slave" : this.getCompSlave().getHostname(), this.getId(), this.getId(), this.getEvt().getRefNo(), this.getComps4log());
        }
        if (errorCount > 0) {
            throw new ParameterException("Failed to add " + errorCount + " components. See previous errors.");
        }
    }

    public EdiComp newComp(String name, String fileName) throws SQLException, ParameterException {
        if (name == null || name.length() <= 0) {
            throw new ParameterException("no name");
        }
        if (fileName == null || fileName.length() <= 0) {
            throw new ParameterException("no filename");
        }
        this.getComps();
        EdiComp comp = this.getComp(name);
        if (comp != null) {
            comp.setFileName(fileName);
        } else {
            comp = new CtrlEdiComp(this, this.activeStep, name, fileName, this.getCompSize());
            this.addComp(comp);
        }
        return comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Connection con) throws SQLException, IOException {
        ActisFile af = new ActisFile(protfileDir + CtrlJob.getTil(this.getId()) + '/' + this.getId(), 4);
        File protFile = af.toFile();
        if (protFile != null) {
            FileUtils.forceDelete((File)protFile);
        }
        CtrlJobVar.remove(con, this.getId());
        CtrlEvent.removeAttrParam(con, this.getId());
        CtrlJobStep.remove(con, this.getId());
        CtrlEdiComp.remove(con, this.getId());
        this.dropActivateAttr(con);
        String sql = "delete from ctrl_job where id=?";
        DebPrepStmt delete = null;
        delete = new DebPrepStmt(con, sql, dbLog);
        try {
            delete.setLong(1, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + delete));
            }
            if (delete.executeUpdate() != 1) {
                dbLog.warn((Object)("Job not found to remove ID: " + this.getId()));
            }
        }
        finally {
            delete.close();
        }
    }

    public static void setProtfileDir(String path) {
        if (path != null && !(protfileDir = path.replace('\\', '/')).endsWith("/")) {
            protfileDir = protfileDir + "/";
        }
    }

    public static File getProtDir(long id) {
        return new ActisFile(protfileDir + CtrlJob.getTil(id) + '/' + id, 12).toFile();
    }

    public static String getProtDirName(long id) {
        File f = CtrlJob.getProtDir(id);
        if (f == null) {
            return null;
        }
        String fn = f.toString();
        if (fn != null) {
            return fn.replace('\\', '/');
        }
        return null;
    }

    public static String getTil(long id) {
        long sigJobId = id / 10000L + 1L;
        return "til" + sigJobId + "0000";
    }

    public List<String> getComps4log() throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        for (EdiComp comp : this.getComps()) {
            ret.add(comp.getName() + ": " + comp.getFileName());
        }
        return ret;
    }

    public String getAllComps(char sep, EDIOBJ_PART part) throws SQLException {
        StringBuilder buf;
        block5: {
            block4: {
                buf = new StringBuilder();
                if (part != EDIOBJ_PART.FN) break block4;
                Iterator<EdiComp> it = this.getComps().iterator();
                while (it.hasNext()) {
                    if (buf.length() > 0) {
                        buf.append(sep);
                    }
                    buf.append(it.next().getFileName());
                }
                break block5;
            }
            if (part != EDIOBJ_PART.SIZE) break block5;
            Iterator<EdiComp> it = this.getComps().iterator();
            while (it.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(sep);
                }
                buf.append(Long.toString(it.next().getSize()));
            }
        }
        return buf.toString();
    }

    public String evalEdiObjComp(String spec) throws SQLException {
        return this.evalEdiObjComp(spec, ' ');
    }

    public String evalEdiObjComp(String spec, char sep) throws SQLException {
        if (spec.startsWith("EDIOBJ.")) {
            EdiComp comp;
            String[] parts = spec.split("\\.");
            if (parts.length < 2) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Invalid Specification '" + spec + "'. EDIOBJ.<NAME> or EDIOBJ.* expected."));
                }
                return null;
            }
            EDIOBJ_PART part = EDIOBJ_PART.FN;
            if (parts.length > 2 && !parts[2].equals("FN")) {
                if (parts[2].equals("SIZE")) {
                    part = EDIOBJ_PART.SIZE;
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(parts[0] + " component part isn't file name (FN) or file size (SIZE): " + parts[2]));
                    }
                    return null;
                }
            }
            if (parts[1].equals("*")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Component name is * (all)");
                }
                return this.getAllComps(sep, part);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Look for component named " + parts[1]));
            }
            if (super.getAllComps() == null) {
                this.reloadComps();
            }
            if ((comp = this.getComp(parts[1])) != null) {
                if (part == EDIOBJ_PART.FN) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Component named " + parts[1] + " found. " + parts[0] + "." + parts[1] + ".FN=" + comp.getFileName()));
                    }
                    return comp.getFileName();
                }
                if (part == EDIOBJ_PART.SIZE) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Component named " + parts[1] + " found. " + parts[0] + "." + parts[1] + ".SIZE=" + comp.getSize()));
                    }
                    return Long.toString(comp.getSize());
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Component named " + parts[1] + " not found!"));
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Specification isn't edi comp: '" + spec + "'"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveActivateAttr(Connection con) throws SQLException {
        String sql = "insert into ctrl_activate (jobid, attrno, name, value) values (?,?,?,?)";
        DebPrepStmt stmt = null;
        stmt = new DebPrepStmt(con, sql, dbLog);
        try {
            int x = 0;
            Iterator it = this.activateAttr.iterator(0);
            while (it.hasNext()) {
                Attribute a = (Attribute)it.next();
                stmt.setLong(1, this.getId());
                stmt.setInt(2, x);
                stmt.setString(3, a.getName());
                stmt.setString(4, (String)a.get());
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeUpdate: " + stmt));
                }
                stmt.executeUpdate();
                ++x;
            }
        }
        finally {
            stmt.close();
        }
    }

    private void dropActivateAttr(Connection con) throws SQLException {
        this.activateAttr = null;
        DebPrepStmt stmt = null;
        stmt = new DebPrepStmt(con, "delete from ctrl_activate where jobid = ?", dbLog);
        try {
            stmt.setLong(1, this.getId());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    public int hashCode() {
        return Long.valueOf(this.getId()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CtrlJob) {
            return this.getId() == ((CtrlJob)obj).getId();
        }
        return false;
    }

    private static void addStringVal(StringBuilder buf, String name, MatchCmdValue val) {
        String strVal = val.getValue().toString();
        strVal = strVal.replace("*", "%");
        strVal = strVal.replace("?", "_");
        buf.append(name);
        buf.append(" like '");
        buf.append(strVal);
        buf.append("'");
    }

    private static void addNumVal(StringBuilder buf, String name, MatchCmdValue val) {
        if (val.hasMinMax()) {
            buf.append("(");
            buf.append(name);
            buf.append(" >= ");
            buf.append(val.getMinValue().toString());
            buf.append(" and ");
            buf.append(name);
            buf.append(" <= ");
            buf.append(val.getMaxValue().toString());
            buf.append(")");
        } else {
            buf.append(name);
            buf.append(" = ");
            buf.append(val.getValue().toString());
        }
    }

    public static StringBuilder getCriterias(MatchCmdParam param, String dbField) {
        StringBuilder currentCriteria = null;
        if (param.hasValues()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Build select clause of parameter: " + param.getName()));
            }
            StringBuilder include = new StringBuilder();
            StringBuilder exclude = new StringBuilder();
            StringBuilder criterias = new StringBuilder();
            for (int i = 0; i < param.size(); ++i) {
                MatchCmdValue val = (MatchCmdValue)param.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("add one select value: " + val));
                }
                if (val.isInclude()) {
                    currentCriteria = include;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"add it to include list.");
                    }
                } else {
                    currentCriteria = exclude;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"add it to exclude list.");
                    }
                }
                if (currentCriteria.length() > 0) {
                    currentCriteria.append(" or ");
                } else {
                    currentCriteria.append(" (");
                }
                if (val.isNumeric()) {
                    CtrlJob.addNumVal(currentCriteria, dbField, val);
                    continue;
                }
                CtrlJob.addStringVal(currentCriteria, dbField, val);
            }
            if (include.length() > 0) {
                include.append(")");
            }
            if (exclude.length() > 0) {
                exclude.append(")");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("include/exclude = " + include + "/" + exclude));
            }
            criterias.append("(");
            if (include.length() > 0) {
                criterias.append((CharSequence)include);
                if (exclude.length() > 0) {
                    criterias.append(" and not ");
                    criterias.append((CharSequence)exclude);
                }
            } else {
                criterias.append(" not ");
                criterias.append((CharSequence)exclude);
            }
            criterias.append(")");
            return criterias;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<Long> matchJob(MatchCmdParam jobIdSpec, MatchCmdParam jobStatus, MatchCmdValue<Date> fromDate, MatchCmdValue<Date> toDate, boolean suspended, Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<Long> jobIds = null;
        StringBuilder selectCmd = new StringBuilder();
        Date nullDate = new Date(0L);
        boolean firstCondition = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start: ");
            log.debug((Object)("jobIdSpec  : " + jobIdSpec));
            log.debug((Object)("jobStatus  : " + jobStatus));
            log.debug((Object)("fromDate   : " + fromDate));
            log.debug((Object)("toDate     : " + toDate));
            log.debug((Object)("suspended  : " + suspended));
        }
        if (!(suspended || jobIdSpec != null && jobIdSpec.hasValues() || jobStatus != null && jobStatus.hasValues() || fromDate != null && !fromDate.getValue().equals(nullDate) || toDate != null && !toDate.getValue().equals(nullDate))) {
            log.debug((Object)"No job selection parameters specified. return <null>!");
            return null;
        }
        selectCmd.append("select id from ctrl_job where ");
        if (jobIdSpec != null && jobIdSpec.hasValues()) {
            selectCmd.append((CharSequence)CtrlJob.getCriterias(jobIdSpec, "id"));
            firstCondition = false;
        }
        if (fromDate != null && !fromDate.getValue().equals(nullDate)) {
            if (!firstCondition) {
                selectCmd.append(" and ");
            }
            selectCmd.append(" creationdate >= ");
            selectCmd.append(fromDate.getValue().getTime() / 1000L);
            firstCondition = false;
        }
        if (toDate != null && !toDate.getValue().equals(nullDate)) {
            if (!firstCondition) {
                selectCmd.append(" and ");
            }
            selectCmd.append(" creationdate <= ");
            selectCmd.append(toDate.getValue().getTime() / 1000L);
            firstCondition = false;
        }
        if (suspended) {
            if (!firstCondition) {
                selectCmd.append(" and ");
            }
            selectCmd.append(" susp = 1 ");
            firstCondition = false;
        }
        if (jobStatus != null && jobStatus.hasValues()) {
            if (!firstCondition) {
                selectCmd.append(" and ");
            }
            selectCmd.append((CharSequence)CtrlJob.getCriterias(jobStatus, "status"));
            firstCondition = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("selectCmd: " + selectCmd));
        }
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(selectCmd.toString());
            jobIds = new HashSet<Long>();
            while (rs.next()) {
                jobIds.add(rs.getLong(1));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matching job parameterss returns " + jobIds.size() + " job ids"));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return jobIds;
    }

    public void setStatus(int newStatus) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("set status: jobId: " + this.getId() + ", status: " + newStatus));
        }
        super.setStatus(newStatus);
        if (this.getEvt() != null && ((CtrlEvent)this.getEvt()).isWrfConnected()) {
            if (newStatus == 4) {
                ((CtrlEvent)this.getEvt()).sendWorkflowResult(true, 0, new Attributes("TEXT=\"Job ID: " + this.getId() + " successfully ended\""));
            } else if (newStatus == 2 || newStatus == 6) {
                ((CtrlEvent)this.getEvt()).sendWorkflowResult(true, 1, new Attributes("TEXT=\"Job ID: " + this.getId() + " aborted\""));
            }
        }
    }

    public JobAccountSums getJobAccounting(Connection con) throws SQLException {
        int noOfComps = 0;
        long totalCompSize = 0L;
        Long[] compsSizes = null;
        FcAccountSums fcas = null;
        ArrayList<Long> sizes = null;
        try {
            fcas = CtrlFunctionCall.getFcAccountSums(this, con);
        }
        catch (SQLException e) {
            log.error((Object)"Cannot create Function Call accounting data!", (Throwable)e);
        }
        Iterator<EdiComp> it = this.getComps().iterator();
        if (it != null) {
            sizes = new ArrayList<Long>();
            while (it.hasNext()) {
                ++noOfComps;
                EdiComp comp = it.next();
                totalCompSize += comp.getSize();
                sizes.add(comp.getSize());
            }
            compsSizes = new Long[sizes.size()];
            sizes.toArray(compsSizes);
        }
        return new JobAccountSums(fcas, noOfComps, totalCompSize, compsSizes);
    }

    @Override
    public CfgTimeWindowEntry getTimeWindow() {
        CfgJSelectEntry jsl;
        CfgTimeWindowEntry window = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTimeWindow start: Jobname/ID: " + this.getName() + "/" + this.getId()));
        }
        if ((jsl = (CfgJSelectEntry)this.getJsl()) != null) {
            window = jsl.getTimeWindow();
        }
        if (log.isDebugEnabled()) {
            if (window == null) {
                log.debug((Object)"getTimeWindow(job) end: window: null");
            } else {
                log.debug((Object)("getTimeWindow(job) end: window: " + window.getName()));
            }
        }
        return window;
    }

    public NormalizedTimewindow getNormalizedTimewindow() {
        NormalizedTimewindow window = null;
        CfgJSelectEntry jsl = (CfgJSelectEntry)this.getJsl();
        if (jsl != null) {
            window = jsl.getNormalizedTimewindow();
        }
        return window;
    }

    public int getActiveStepNo() {
        return this.activeStep;
    }

    private static enum EDIOBJ_PART {
        FN,
        SIZE;

    }
}

