/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.CfgJobStepRcReaction;
import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.lib.JobStepCfg;
import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlVar;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.NextJobStepException;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctn;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.aim.controller.master.cfg.CfgFctnRcReaction;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.cfg.CfgJobStep;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CtrlJobStep
extends IJobStep {
    private static Log log = LogFactory.getLog((String)"master.JobStep");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.JobStep");
    private CtrlFunctionCall lastFC = null;
    private CfgFctn cfgFctn = null;
    private long nextRun = 0L;

    private CtrlJobStep(CtrlJobStep step, Job job) {
        super(step, job);
        this.lastFC = step.lastFC;
        this.cfgFctn = step.cfgFctn;
        this.nextRun = step.nextRun;
    }

    public CtrlJobStep clone(Job job) {
        return new CtrlJobStep(this, job);
    }

    public CtrlJobStep(Job parent, JobStepCfg cfg, int stepNo) {
        super(parent, cfg, stepNo);
        if (cfg != null) {
            if (cfg.getStep() <= 1) {
                this.nextRun = parent.getCreationDate() + (long)this.getDelay() * 1000L;
            }
            this.setStatus(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CtrlJobStep getJobStep(long jobId, int stepNo, int retryNo, int level, CtrlDispAppl dispatcher) throws SQLException, InterruptedException {
        IJob oj = dispatcher.getJob(jobId);
        if (oj == null) {
            return null;
        }
        IJobStep ojs = (IJobStep)oj.getStep(stepNo);
        if (ojs == null) {
            return null;
        }
        JobStepCfg cfg = ojs.getCfg();
        Event evt = new Event(jobId);
        Job job = new Job(0L, evt, null);
        CtrlJobStep js = new CtrlJobStep(job, cfg, stepNo);
        js.setRetry(retryNo);
        try (Connection con = dispatcher.getConnection();){
            Value retryValue = new Value((Object)retryNo);
            Value levelValue = new Value((Object)level);
            CtrlFunctionCall fc = CtrlFunctionCall.getLastInstance(con, jobId, stepNo, (Value<Integer>)retryValue, (Value<Integer>)levelValue);
            js.setRetry((Integer)retryValue.get());
            js.setLevel((Integer)levelValue.get());
            js.setLastFC(fc);
            fc.setJobStep(js);
        }
        return js;
    }

    public void setLevel() {
        if (this.lastFC == null) {
            this.setLevel(0);
        } else if (this.cfg != null) {
            this.setLevel(this.cfg.getLevel(this.lastFC.getRc(), this.lastFC.getRetryNo(), this.lastFC.getMaxRetry()));
        }
    }

    public int getPrio() {
        try {
            CfgFctnEntry cfg = this.getFctnEntry();
            if (cfg == null) {
                log.error((Object)("no fctnEntry found: " + this.getName()));
                return 0;
            }
            return cfg.getPrio(this.getActiveSeq());
        }
        catch (CfgException e) {
            log.error((Object)("getFctnEntry (" + this.getName() + ")"), (Throwable)((Object)e));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatus(Connection con, long jobid, int step) throws SQLException {
        String sql = "select status from ctrl_jobstep where jobid=? and step=?";
        DebPrepStmt stmt = new DebPrepStmt(con, sql, dbLog);
        ResultSet rs = null;
        try {
            stmt.setLong(1, jobid);
            stmt.setLong(2, step);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            if ((rs = stmt.executeQuery()).next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        return -1;
    }

    public String getCmdLine() {
        if (this.lastFC != null) {
            return this.lastFC.getReal();
        }
        try {
            return this.getFctnEntry().getCmdLine(1);
        }
        catch (CfgException e) {
            log.error((Object)"getFctnEntry", (Throwable)((Object)e));
            return "";
        }
    }

    public CtrlJob getJob() {
        return (CtrlJob)super.getJob();
    }

    public void setFctn(CfgFctn cfgFctn) throws CfgException {
        this.cfgFctn = cfgFctn;
        if (!"NEXT_JOB_STEP".equals(this.getName()) && this.getSlaves() == null) {
            throw new CfgException("no slave for job " + this.getJobId() + " jobstep " + this.getName() + " defined");
        }
    }

    public void execAssign(Connection con) throws CfgException, SQLException {
        for (Attribute attr : ((CfgJobStep)this.cfg).getAssign().get()) {
            this.getJob().setVar(con, attr.getName(), this.evalPar((String)attr.get(), false, false));
        }
    }

    public static String getSql(boolean equal) {
        return "select step, seq, status from ctrl_jobstep where jobid = ? AND step " + (equal ? "" : ">") + "= ? order by step";
    }

    public CtrlJobStep(Job parent, ResultSet rs, CfgJobEntry cfgJobEntry) throws SQLException {
        this(parent, cfgJobEntry != null ? cfgJobEntry.getJobStep(rs.getInt(1)) : null, rs.getInt(1));
        this.setSeq(rs.getInt(2) != 0);
        this.setStatus(rs.getInt(3));
    }

    public void setLastFC(CtrlFunctionCall fc) {
        this.lastFC = fc;
        if (fc != null) {
            fc.setJobStep(this);
        }
    }

    @Override
    public String evalPar(String cmd, boolean quoteEmpty, boolean evalComps) throws CfgException, SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("evalPar cmd(" + this.getJobId() + "." + this.getStepNo() + "): <" + cmd + ">"));
        }
        if (cmd == null) {
            return null;
        }
        String stepCmd = CtrlVar.eval(cmd, null, this.getVars());
        if (log.isDebugEnabled()) {
            log.debug((Object)("evalPar stepCmd(" + this.getJobId() + "." + this.getStepNo() + "): <" + stepCmd + ">"));
        }
        String jobCmd = this.getJob().evalPar(stepCmd, quoteEmpty, evalComps);
        if (log.isDebugEnabled()) {
            log.debug((Object)("evalPar jobCmd(" + this.getJobId() + "." + this.getStepNo() + "): <" + jobCmd + ">"));
        }
        return jobCmd;
    }

    @Override
    public List<SlaveHandler> getSlaves() throws CfgException {
        boolean isRunJs;
        boolean bl = isRunJs = this.getJob() != null && this.getJob().isRunJs();
        if (this.lastFC != null && !isRunJs && this.getLastRc() != null && this.getLastRc().getException() != null && this.getLastRc().isBuiltin()) {
            return CfgFctnEntry.bics;
        }
        return this.getFctnEntry().getSlaves(this.getActiveSeq(), this.getJob().getEvt().getInitiatorHost());
    }

    public String getRealGroupName() throws CfgException {
        return this.getFctnEntry().getGroupName(this.getActiveSeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGroupName() throws CfgException, SQLException {
        CtrlJobStep ctrlJobStep = this;
        synchronized (ctrlJobStep) {
            if (this.getFcGroup() != null) {
                return this.getFcGroup().getName();
            }
        }
        try {
            CfgFctnEntry fctn = this.getFctnEntry();
            if (fctn.groupNameMustEval(this.getActiveSeq())) {
                return this.evalPar(fctn.getGroupName(this.getActiveSeq()), false, true);
            }
            return fctn.getGroupName(this.getActiveSeq());
        }
        catch (CfgException e) {
            CfgException ce = new CfgException("invalid group name");
            ce.initCause((Throwable)((Object)e));
            throw ce;
        }
    }

    @Override
    public int getMaxGroupCalls() {
        try {
            return this.getFctnEntry().getMaxCalls(this.getActiveSeq());
        }
        catch (CfgException e) {
            log.error((Object)"getFctnEntry", (Throwable)((Object)e));
            return 1;
        }
    }

    public boolean isGrouped() {
        try {
            return this.getFctnEntry().isGrouped(this.getActiveSeq());
        }
        catch (CfgException e) {
            log.error((Object)"getFctnEntry", (Throwable)((Object)e));
            return false;
        }
    }

    @Override
    public int isRunnable(boolean ignoreFc) throws NextJobStepException, CfgException {
        CfgJobStepRcReaction rc;
        if (this.getRetry() < this.getMaxRetry()) {
            return 1;
        }
        if (this.lastFC == null) {
            return 1;
        }
        if (this.getName().equals("NEXT_JOB_STEP")) {
            throw new NextJobStepException();
        }
        if (ignoreFc) {
            return 0;
        }
        if (this.lastFC.getSeqRetry() < this.getFctnEntry().getMaxSeqRetry(this.lastFC.getSeqNo())) {
            return 1;
        }
        if (this.lastFC.getSeqNo() < this.getFctnEntry().getSeqCount()) {
            return 1;
        }
        if (this.getLevel() <= 0 && (rc = ((CfgJobStep)this.cfg).getRcReaction(this.lastFC.getRc())) != null) {
            switch (rc.getAction()) {
                case FCTN: 
                case ON_JS_RETRY_FULL: {
                    return 2;
                }
                case NEXT_JOB_STEP: {
                    throw new NextJobStepException();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isRunnable(" + this.getJobId() + "." + this.getStepNo() + "): false"));
        }
        return 0;
    }

    public String getLastRcName() {
        try {
            if (this.lastFC == null) {
                return "";
            }
            return this.getLastFctnEntry().getRcName(this.lastFC.getSeqNo(), this.lastFC.getRc(), this.lastFC.getLevel());
        }
        catch (CfgException e) {
            log.error((Object)"getFctnEntry", (Throwable)((Object)e));
            return "";
        }
    }

    @Override
    public CfgFctnRcReaction getLastRc() {
        try {
            if (this.lastFC == null) {
                return null;
            }
            return this.getLastFctnEntry().getRcReaction(this.lastFC.getSeqNo(), this.lastFC.getRc(), this.lastFC.getLevel());
        }
        catch (CfgException e) {
            log.error((Object)"getFctnEntry", (Throwable)((Object)e));
            return null;
        }
    }

    private CtrlFunctionCall nextSeq(CtrlFunctionCall lastFc) throws CfgException, SQLException {
        if (lastFc.getSeqNo() >= this.getFctnEntry().getSeqCount()) {
            throw new CfgException("end of sequence");
        }
        return this.getFctnEntry().createFc(this, lastFc.getSeqNo() + 1, 1, 0);
    }

    private CtrlFunctionCall nextSeqRetry(CtrlFunctionCall lastFc) throws CfgException, SQLException {
        return this.getFctnEntry().createFc(this, lastFc.getSeqNo(), lastFc.getSeqRetry() + 1, 0);
    }

    public void termJs(Connection con) throws SQLException {
        this.setTerminated();
        this.updateStatus(con);
    }

    public void retryFull(Connection con) throws SQLException {
        this.setRetryFull();
        this.updateStatus(con);
    }

    public void stopped(Connection con) throws SQLException {
        this.setStopped();
        this.updateStatus(con);
    }

    public void suspended(Connection con) throws SQLException {
        this.setSuspended();
        this.updateStatus(con);
    }

    public void activate(Connection con) throws SQLException {
        this.setActivate();
        this.updateStatus(con);
    }

    public void setActive(Connection con, boolean active) throws SQLException {
        this.setActive(active);
        this.updateStatus(con);
    }

    public void setDelayed(Connection con, boolean delayed) throws SQLException {
        this.setDelayed(delayed);
        this.updateStatus(con);
    }

    public void setReadyToRun(Connection con) throws SQLException {
        this.setStatus(1);
        this.updateStatus(con);
    }

    @Override
    public synchronized CtrlFunctionCall createFc(Connection con, boolean runJs) throws CfgException, SQLException {
        if (this.assignModeContainsBefore()) {
            this.execAssign(con);
        }
        if (this.lastFC == null || this.lastFC.getStepLevel() != this.getLevel()) {
            if (this.getLevel() == 0) {
                this.incRetry();
            }
            this.lastFC = this.getFctnEntry().createFc(this, 1, 1, 0);
        } else {
            switch (this.getLastRc().getAction()) {
                case RETURN: 
                case STOP_JOB: 
                case SUSPEND_JOB: {
                    if (!runJs) {
                        throw new CfgException("create fc on " + (Object)((Object)this.getLastRc().getAction()));
                    }
                    this.incRetry();
                    this.lastFC = this.getFctnEntry().createFc(this, 1, 1, 0);
                    break;
                }
                case RETRY: {
                    if (this.lastFC.getSeqRetry() < this.getFctnEntry().getMaxSeqRetry(this.lastFC.getSeqNo())) {
                        this.lastFC = this.nextSeqRetry(this.lastFC);
                        break;
                    }
                    if (this.lastFC.getSeqNo() < this.getFctnEntry().getSeqCount()) {
                        this.lastFC = this.nextSeq(this.lastFC);
                        break;
                    }
                    if (this.getRetry() < this.getMaxRetry() || runJs) {
                        this.incRetry();
                        this.lastFC = this.getFctnEntry().createFc(this, 1, 1, 0);
                        break;
                    }
                    throw new CfgException("create fc on RETRYFULL without runjs");
                }
                case FAIL: {
                    this.incRetry();
                    this.lastFC = this.getFctnEntry().createFc(this, 1, 1, 0);
                    break;
                }
                case SKIP: {
                    if (this.lastFC.getSeqNo() < this.getFctnEntry().getSeqCount()) {
                        this.lastFC = this.nextSeq(this.lastFC);
                        break;
                    }
                    this.incRetry();
                    this.lastFC = this.getFctnEntry().createFc(this, 1, 1, 0);
                    break;
                }
                case EXCEPTION: {
                    this.lastFC = this.getFctnEntry().createFc(this, this.lastFC.getSeqNo(), this.lastFC.getSeqRetry(), this.getFctnEntry().getLevel(this.lastFC.getSeqNo(), this.lastFC.getRc()));
                    break;
                }
                default: {
                    throw new CfgException("unknown rc: " + (Object)((Object)this.getLastRc().getAction()));
                }
            }
        }
        return this.lastFC;
    }

    public synchronized CtrlFunctionCall getLastFc() {
        return this.lastFC;
    }

    public void updateStatus(Connection con) throws SQLException {
        String sql = "update ctrl_jobstep set status=? where jobid = ? AND step = ?";
        DebPrepStmt update = new DebPrepStmt(con, sql, dbLog);
        try {
            update.setInt(1, this.getStatus());
            update.setLong(2, this.getJobId());
            update.setInt(3, this.getStepNo());
            update.executeUpdate();
        }
        catch (SQLException e) {
            String sqlLog = sql + " values= (" + this.getJobId() + "," + this.getStepNo() + "," + this.isSeq() + "," + (this.isSeq() ? 1 : 0) + ")";
            throw new SQLException(sqlLog, e);
        }
        finally {
            try {
                update.close();
            }
            catch (SQLException e) {
                log.warn((Object)e);
            }
        }
    }

    public void insert(Connection con) throws SQLException {
        String sql = "insert into ctrl_jobstep (jobid, step, seq, status) values (?,?,?,?)";
        DebPrepStmt insert = null;
        insert = new DebPrepStmt(con, sql, dbLog);
        try {
            insert.setLong(1, this.getJobId());
            insert.setInt(2, this.getStepNo());
            insert.setInt(3, this.isSeq() ? 1 : 0);
            insert.setInt(4, this.getStatus());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + insert));
            }
            insert.executeUpdate();
        }
        catch (SQLException e) {
            String sqlLog = sql + " values= (" + this.getJobId() + "," + this.getStepNo() + "," + this.isSeq() + "," + (this.isSeq() ? 1 : 0) + ")";
            throw new SQLException(sqlLog, e);
        }
        finally {
            try {
                insert.close();
            }
            catch (SQLException e) {
                log.warn((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection con, long jobid) throws SQLException {
        CtrlFunctionCall.remove(con, jobid);
        String sql = "delete from ctrl_jobstep where jobid=?";
        try (DebPrepStmt delete = new DebPrepStmt(con, sql, dbLog);){
            delete.setLong(1, jobid);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + delete));
            }
            delete.executeUpdate();
        }
    }

    public void setNextExecTime(long creationDate) {
        this.nextRun = creationDate + (long)this.getDelay() * 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("nextRun: " + new Date(this.nextRun)));
        }
    }

    public int getActiveSeq() {
        try {
            if (this.lastFC == null || this.getLastRc() == null) {
                return 1;
            }
            if (this.getJob().isRunJs() && this.getLastRc().getAction() == CfgFctnRcReaction.Action.RETURN) {
                return 1;
            }
            if (this.getJob().getStatus() == 5) {
                return this.lastFC.getSeqNo();
            }
            switch (this.getLastRc().getAction()) {
                case FAIL: {
                    return 1;
                }
                case RETRY: 
                case SKIP: {
                    if (this.lastFC.getSeqNo() < this.getFctnEntry().getSeqCount()) {
                        return this.lastFC.getSeqNo() + 1;
                    }
                }
                case EXCEPTION: {
                    return this.lastFC.getSeqNo();
                }
            }
            return 1;
        }
        catch (CfgException e) {
            log.error((Object)"getFctnEntry", (Throwable)((Object)e));
            return 1;
        }
    }

    @Override
    public long getNextExecTime() {
        log.debug((Object)("getNextExecTime start: jobid/name: " + this.getJobId() + "/" + this.getJobName() + ", step/name: " + this.getStepNo() + "/" + this.getName()));
        return Math.max(this.getNextExecTimeWoWindow(), this.getNextExecTimeWithWindow());
    }

    public long getNextExecTimeWithWindow() {
        Date nearest;
        log.debug((Object)("getNextExecTimeWithWindow start: jobid/name: " + this.getJobId() + "/" + this.getJobName() + ", step/name: " + this.getStepNo() + "/" + this.getName()));
        NormalizedTimewindow window = this.getNormalizedTimewindow();
        if (window == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getnextExecTimeWithWindow: no JS time window defined");
            }
            if ((window = this.getJob().getNormalizedTimewindow()) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"getnextExecTimeWithWindow: no job time window defined too, return 0");
                }
                return 0L;
            }
        }
        if (log.isDebugEnabled()) {
            if (this.getJob().getTimeWindow() != null) {
                log.debug((Object)("getNextExecTimeWithWindow: look for next valid execution time of time window: " + this.getJob().getTimeWindow().getName()));
            } else {
                log.debug((Object)"no job time window");
            }
        }
        if ((nearest = window.getNearest(new Date(), null)) == null) {
            return 2147483647000L;
        }
        long when = nearest.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNextExecTimeWithWindow: end: " + new Date(when)));
        }
        return when;
    }

    public long getNextExecTimeWoWindow() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        if (this.lastFC == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("New step on " + new Date(this.nextRun)));
            }
            return this.nextRun;
        }
        CfgFctnRcReaction lastRc = this.getLastRc();
        if (lastRc == null) {
            return 0L;
        }
        if (lastRc.getAction() == CfgFctnRcReaction.Action.EXCEPTION) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Next SeqRetry on " + new Date(this.nextRun)));
            }
            return this.nextRun;
        }
        try {
            if (this.lastFC.getSeqRetry() < this.getFctnEntry().getMaxSeqRetry(this.lastFC.getSeqNo())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Next SeqRetry on " + new Date(this.nextRun)));
                }
                return this.nextRun;
            }
            if (this.lastFC.getSeqNo() < this.getFctnEntry().getSeqCount()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("next Seq on " + new Date(this.nextRun)));
                }
                return this.nextRun;
            }
        }
        catch (CfgException e) {
            log.error((Object)"getFctnEntry", (Throwable)((Object)e));
            return 0L;
        }
        if (this.getRetry() < this.getMaxRetry()) {
            long next = this.lastFC.getReadyDate() + (long)this.getRetryDelay() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Next step retry on " + new Date(next)));
            }
            return next;
        }
        return this.lastFC.getReadyDate();
    }

    public CfgTimeWindowEntry getTimeWindow() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getTimeWindow start:");
        }
        CfgTimeWindowEntry window = null;
        window = ((CfgJobStep)this.cfg).getTimeWindow();
        if (log.isDebugEnabled()) {
            if (window == null) {
                log.debug((Object)"getTimeWindow(step): window: null");
            } else {
                log.debug((Object)("getTimeWindow(step): window: " + window.getName()));
            }
        }
        return window;
    }

    public NormalizedTimewindow getNormalizedTimewindow() {
        NormalizedTimewindow window = null;
        window = ((CfgJobStep)this.cfg).getNormalizedTimewindow();
        return window;
    }

    public CfgFctnEntry getLastFctnEntry() throws CfgException {
        if (this.cfgFctn == null || this.getCfg() == null) {
            throw new CfgException("getLastFctnEntry: no cfg available: " + this.getJobId() + "." + this.getStepNo());
        }
        return this.cfgFctn.getEntry(this.getCfg().getName(this.lastFC.getStepLevel()));
    }

    public CfgFctnEntry getFctnEntry() throws CfgException {
        if (this.cfgFctn == null || this.cfg == null) {
            throw new CfgException("getFctnEntry: no cfg available: " + this.getJobId() + "." + this.getStepNo());
        }
        return this.cfgFctn.getEntry(this.getName());
    }

    public String getProtfileName() {
        return CtrlJobStep.getProtfileName(this.getJobId(), this.getStepNo(), this.getRetry());
    }

    public static String getProtfileName(long jobId, int stepNo, int stepRetry) {
        String protfileDirName = null;
        protfileDirName = CtrlJob.getProtDirName(jobId);
        if (protfileDirName != null) {
            return protfileDirName + "/" + stepNo + '.' + stepRetry;
        }
        return null;
    }
}

