/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Slave;
import de.axway.aim.controller.master.SyncSlave;
import de.axway.aim.controller.master.cfg.CfgSlaveEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.lockDaemon.LockDaemon;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.SyncObject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CtrlSlave
extends Slave
implements Comparable<CtrlSlave> {
    private static Log log = LogFactory.getLog((String)"master.CtrlSlave");
    private LockDaemon ld;
    private Set<InetAddress> ips = new HashSet<InetAddress>();
    private Set<InetAddress> srcIps = new HashSet<InetAddress>();
    private InetAddress lastIp = null;
    private boolean isLocal = false;
    private ConnectionType connectionType = ConnectionType.LOGPROT;
    private Type type = Type.SLAVE;

    public CtrlSlave(CfgSlaveEntry cfgSlave, LockDaemon ld) throws UnknownHostException {
        this(cfgSlave.getName(), cfgSlave.getHost(), cfgSlave.getPort(), cfgSlave.getMax(), cfgSlave.getConnection(), cfgSlave.getType(), cfgSlave.getSrcAddress(), ld);
    }

    private CtrlSlave(String name, String host, int port, int max, ConnectionType ct, Type type, String srcAddress, LockDaemon ld) throws UnknownHostException {
        super(name, host, port, max);
        this.update(ct, type);
        this.ld = ld;
        if (srcAddress != null) {
            log.debug((Object)("setting src addresses: " + srcAddress));
            String[] src = srcAddress.split("[ \t,;]");
            for (int x = 0; x < src.length; ++x) {
                String s = src[x].trim();
                if (s.length() <= 0) continue;
                try {
                    this.setIp(s, true);
                    continue;
                }
                catch (UnknownHostException e) {
                    log.warn((Object)("src host <" + s + "> for slave " + this.getName() + ": " + e));
                }
            }
        }
    }

    public void updateSlave(CfgSlaveEntry cse) throws UnknownHostException {
        this.setHostname(cse.getHost());
        this.setPort(cse.getPort());
        this.setMax(cse.getMax());
        this.update(cse.getConnection(), cse.getType());
        this.srcIps.clear();
        String srcAddress = cse.getSrcAddress();
        if (srcAddress != null) {
            log.debug((Object)("setting src addresses: " + srcAddress));
            String[] src = srcAddress.split("[ \t,;]");
            for (int x = 0; x < src.length; ++x) {
                String s = src[x].trim();
                if (s.length() <= 0) continue;
                try {
                    this.setIp(s, true);
                    continue;
                }
                catch (UnknownHostException e) {
                    log.warn((Object)("src host <" + s + "> for slave " + this.getName() + ": " + e));
                }
            }
        }
    }

    private void update(ConnectionType ct, Type type) throws UnknownHostException {
        this.type = type;
        String host = this.getHostname();
        if (this.getName().equalsIgnoreCase("BIC_SLAVE") || ct == ConnectionType.BUILTIN) {
            this.isLocal = false;
            this.setConnection(ConnectionType.BUILTIN);
        } else {
            this.ips.clear();
            this.setIp(host, false);
            this.setConnection(ct);
        }
    }

    public Socket connect(Ediboss ediboss) throws IOException, InterruptedException {
        log.debug((Object)"CtrlSlave.connect start:");
        IOException last = null;
        if (this.isBomSlave()) {
            InetAddress[] ia = InetAddress.getAllByName(this.getHostname());
            for (int x = 0; x < ia.length; ++x) {
                try {
                    return this.connectTo(ediboss, ia[x]);
                }
                catch (IOException e) {
                    log.warn((Object)("No connect to slave (" + ia[x].getHostAddress() + ") possible."));
                    last = e;
                    continue;
                }
            }
        } else {
            if (this.lastIp != null) {
                try {
                    return this.connectTo(ediboss, this.lastIp);
                }
                catch (IOException e) {
                    log.warn((Object)String.format("No connect to last slave (%s, %s) possible. (%s)", this.lastIp.getHostName(), this.lastIp.getHostAddress(), e.getMessage()));
                }
            }
            for (InetAddress currentIp : this.ips) {
                try {
                    return this.connectTo(ediboss, currentIp);
                }
                catch (IOException e) {
                    log.warn((Object)("No connect to slave (" + currentIp.getHostAddress() + ") possible."));
                    last = e;
                }
            }
        }
        if (last == null) {
            throw new IOException("Can not resolv hostname: " + this.getHostname());
        }
        throw last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket connectTo(Ediboss ediboss, InetAddress ip) throws IOException, InterruptedException {
        SocketChannel sc = SocketChannel.open();
        try {
            sc.configureBlocking(false);
            sc.socket().setSoTimeout(1000 * ediboss.getIpcConnectTimeout());
            sc.socket().setTcpNoDelay(ediboss.getIpcNoDelay());
            try (Selector s = Selector.open();){
                SelectionKey key = sc.register(s, 8);
                boolean connected = sc.connect(new InetSocketAddress(ip, this.getPort()));
                while (!connected) {
                    int rc = s.select();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (rc <= 0) continue;
                    Iterator<SelectionKey> it = s.selectedKeys().iterator();
                    while (it.hasNext() && !connected) {
                        if (!it.next().isConnectable() || !sc.finishConnect()) continue;
                        connected = true;
                    }
                }
            }
            sc.socket().setSoTimeout(1000 * ediboss.getIpcRwTimeout());
            this.lastIp = ip;
            sc.configureBlocking(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ipcConnectTineout: " + 1000 * ediboss.getIpcConnectTimeout() + ", ipcRwTimeout: " + 1000 * ediboss.getIpcRwTimeout() + ", ipcRwTimeout: " + 1000 * ediboss.getIpcRwTimeout() + ", ipcNoDelay: " + ediboss.getIpcNoDelay()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("CtrlSlave.connect end: " + sc.socket()));
            }
        }
        catch (IOException e) {
            sc.close();
            throw e;
        }
        catch (InterruptedException e) {
            sc.close();
            throw e;
        }
        return sc.socket();
    }

    public void removeAllJobLocks() {
        while (this.size() > 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("CtrlSlave:removeAllJobLocks[slave=" + this.getName() + "]: unlocked slave."));
                }
                this.delRunningJob();
            }
            catch (LockException e) {
                log.info((Object)"delRunningJob", (Throwable)e);
            }
        }
    }

    public void addActiveJob() {
        this.ld.addLock((SyncObject)new SyncSlave(this));
    }

    public void addRunningJob() throws LockException {
        this.ld.globalLock((SyncObject)new SyncSlave(this));
    }

    public void delRunningJob() throws LockException {
        this.ld.globalUnLock((SyncObject)new SyncSlave(this));
    }

    public int size() {
        return this.ld.getCurrent((SyncObject)new SyncSlave(this));
    }

    private void setIp(String hostname, boolean src) throws UnknownHostException {
        if (hostname == null || hostname.length() <= 0) {
            throw new UnknownHostException("no hostname");
        }
        if (!src) {
            this.isLocal = false;
        }
        this.lastIp = null;
        if (this.isBomSlave()) {
            return;
        }
        InetAddress[] ia = InetAddress.getAllByName(hostname);
        for (int x = 0; x < ia.length; ++x) {
            if (src) {
                this.srcIps.add(ia[x]);
            } else {
                this.ips.add(ia[x]);
            }
            if (this.isLocal || !CtrlSlave.isLocalAddress(ia[x])) continue;
            this.isLocal = true;
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean containsIp(InetAddress ip) {
        if (this.getConnectionType() == ConnectionType.BUILTIN) {
            return false;
        }
        boolean isLocal = CtrlSlave.isLocalAddress(ip);
        if (isLocal && !this.isBomSlave()) {
            return this.isLocal();
        }
        if (this.ips.contains(ip) || this.srcIps.contains(ip)) {
            return true;
        }
        if (this.isBomSlave()) {
            try {
                InetAddress[] ia = InetAddress.getAllByName(this.getHostname());
                for (int x = 0; x < ia.length; ++x) {
                    if (ip.equals(ia[x])) {
                        return true;
                    }
                    if (!isLocal || !CtrlSlave.isLocalAddress(ia[x])) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return false;
    }

    public void setConnection(ConnectionType ct) {
        this.connectionType = ct;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isBomSlave() {
        return this.type == Type.BOMSLAVE;
    }

    public String getHostname() {
        if (this.getConnectionType() == ConnectionType.BUILTIN) {
            return "BIC_SLAVE";
        }
        return super.getHostname();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getConnectionType() != ConnectionType.BUILTIN) {
            Iterator<InetAddress> it;
            boolean first;
            buf.append(super.toString());
            buf.append("\nConnType: ");
            buf.append((Object)this.connectionType);
            if (!this.isBomSlave()) {
                buf.append(", [");
                first = true;
                it = this.ips.iterator();
                while (it.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(it.next().getHostAddress());
                }
                buf.append("]");
            }
            if (this.srcIps.size() > 0) {
                buf.append(", src[");
                first = true;
                it = this.srcIps.iterator();
                while (it.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(it.next().getHostAddress());
                }
                buf.append("]");
            }
            if (this.type == Type.BOMSLAVE) {
                buf.append(", BOM-Slave! ");
            } else if (this.isLocal) {
                buf.append(", LOCAL");
            } else {
                buf.append(", REMOTE");
            }
        } else {
            buf.append(this.getName());
            buf.append(", BUILTIN, maxCalls: ");
            buf.append(this.getMax());
        }
        return buf.toString();
    }

    private static boolean isLocalAddress(InetAddress address) {
        if (address == null) {
            return false;
        }
        if (address.isLoopbackAddress()) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
            while (eni.hasMoreElements()) {
                Enumeration<InetAddress> eia = eni.nextElement().getInetAddresses();
                while (eia.hasMoreElements()) {
                    if (!eia.nextElement().equals(address)) continue;
                    return true;
                }
            }
        }
        catch (SocketException e) {
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(CtrlSlave slave) {
        if (this.getConnectionType() == ConnectionType.BUILTIN && slave.getConnectionType() != ConnectionType.BUILTIN) {
            return 1;
        }
        if (this.getConnectionType() != ConnectionType.BUILTIN && slave.getConnectionType() == ConnectionType.BUILTIN) {
            return -1;
        }
        if (this.isBomSlave() && !slave.isBomSlave()) {
            return 1;
        }
        if (!this.isBomSlave() && slave.isBomSlave()) {
            return -1;
        }
        return this.getName().compareTo(slave.getName());
    }

    public static enum ConnectionType {
        LOGPROT,
        CLIENTCONNECTION,
        BUILTIN;

    }

    public static enum Type {
        SLAVE,
        BOMSLAVE;

    }
}

