/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.lib.Variable;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.cfg.CfgException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class CtrlVar
extends Variable<String, Connection> {
    private static Pattern ediCompPattern = Pattern.compile("EDIOBJ\\..*");
    protected long jobid;
    protected String name;
    protected int num;

    protected CtrlVar(String value, String name, long jobid, int num, boolean saved) {
        super((Object)value, saved);
        this.jobid = jobid;
        this.name = name.length() > 32 ? name.substring(0, 32).intern() : name.intern();
        this.num = num;
    }

    private CtrlVar(CtrlVar var) {
        super((Variable)var);
        this.jobid = var.jobid;
        this.name = var.name;
        this.num = var.num;
    }

    public CtrlVar clone() {
        return new CtrlVar(this);
    }

    public String getName() {
        return this.name;
    }

    public long getJobId() {
        return this.jobid;
    }

    protected static String eval(String value, CtrlJob job4comp, Map<String, ? extends Value> ... attr) throws CfgException, SQLException {
        return CtrlVar.eval(value, false, false, job4comp, attr);
    }

    public static String eval(String value, boolean removeEmpty, boolean quoteEmpty, CtrlJob job4comp, Map<String, ? extends Value> ... attr) throws CfgException, SQLException {
        return CtrlVar.eval(value, removeEmpty, quoteEmpty, job4comp, -1, attr);
    }

    public static String eval(String value, boolean keepUnknownVars, boolean keepEmptyVars, CtrlJob job4comp, int from, Map<String, ? extends Value> ... attr) throws CfgException, SQLException {
        if (value == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        boolean dollar = false;
        boolean klammer = false;
        StringBuilder name = new StringBuilder();
        StringBuilder parameter = new StringBuilder();
        block7: for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            switch (c) {
                case '$': {
                    if (klammer) {
                        throw new CfgException("$ not allowed in parameter name: " + value);
                    }
                    if (dollar) {
                        parameter.append("$");
                    }
                    dollar = true;
                    continue block7;
                }
                case '(': {
                    if (dollar) {
                        klammer = true;
                        continue block7;
                    }
                    parameter.append(c);
                    continue block7;
                }
                case ')': {
                    if (klammer) {
                        String val = "";
                        boolean found = false;
                        String varName = name.toString();
                        if (!ediCompPattern.matcher(varName).matches()) {
                            if (attr != null) {
                                int y;
                                int n = y = from < 0 ? 0 : from;
                                while (y < attr.length && !found) {
                                    try {
                                        Value tmp;
                                        if (attr[y] != null && (tmp = attr[y].get(varName)) != null) {
                                            val = (String)tmp.get();
                                            if (from >= 0 && val != null && val.length() > 0) {
                                                val = CtrlVar.eval(val, keepUnknownVars, false, job4comp, y + 1, attr);
                                            }
                                            found = true;
                                        }
                                    }
                                    catch (NoSuchElementException e) {
                                        found = false;
                                    }
                                    ++y;
                                }
                            }
                            if (found && val != null && val.length() > 0) {
                                parameter.append(val);
                            } else if (!found && !keepUnknownVars) {
                                parameter.append("$(");
                                parameter.append(varName);
                                parameter.append(')');
                            } else if (keepEmptyVars) {
                                parameter.append("\"\"");
                            }
                        } else if (job4comp != null) {
                            String comp = job4comp.evalEdiObjComp(varName);
                            if (comp != null) {
                                parameter.append(comp);
                            } else if (!keepUnknownVars) {
                                parameter.append("$(");
                                parameter.append(varName);
                                parameter.append(')');
                            }
                        } else {
                            parameter.append("$(");
                            parameter.append(varName);
                            parameter.append(')');
                        }
                        name = new StringBuilder();
                        klammer = false;
                        dollar = false;
                        continue block7;
                    }
                    parameter.append(c);
                    continue block7;
                }
                default: {
                    if (klammer) {
                        name.append(c);
                        continue block7;
                    }
                    if (dollar) {
                        dollar = false;
                        parameter.append('$');
                    }
                    parameter.append(c);
                }
            }
        }
        if (dollar) {
            parameter.append("$");
            dollar = false;
        }
        String ret = parameter.toString();
        WorkerThread.addEvalTime(System.currentTimeMillis() - start);
        if (klammer) {
            throw new CfgException("')' expected");
        }
        return ret;
    }

    public String toString() {
        return "CtrlVar/" + super.toString() + ", jobid: " + this.jobid + ", name: " + this.name + ", num: " + this.num;
    }
}

