/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.Status;
import de.axway.aim.controller.master.WorkflowResultConnection;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EventLoader
extends ManagedRunnableImpl {
    private static Log log = LogFactory.getLog((String)"master.Loader.Event");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.EventLoader");
    private CtrlDispAppl dispatcher;
    private Status status = Status.START;
    private Map<Long, CtrlEvent> events = new Hashtable<Long, CtrlEvent>();
    private SQLException e = null;
    private Hashtable<Long, WorkflowResultConnection> oldWfrConn;

    public EventLoader(CtrlDispAppl dispatcher, Hashtable<Long, WorkflowResultConnection> oldWfrConn) {
        this.dispatcher = dispatcher;
        this.oldWfrConn = oldWfrConn;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEnd() throws InterruptedException {
        Map<Long, CtrlEvent> map = this.events;
        synchronized (map) {
            while (this.status != Status.READY) {
                this.events.wait();
            }
        }
    }

    public Map<Long, CtrlEvent> getAll() {
        return this.events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRun() {
        this.setName("Event Loader");
        this.status = Status.RUN;
        try (Connection con = this.dispatcher.getConnection();){
            String sql = "select jobid, removedate, type, initiator, reference_no, initiator_host, corefunc_id from ctrl_event order by jobid";
            PreparedStatement stmt = con.prepareStatement(sql);
            stmt.setFetchSize(this.dispatcher.getEdiboss().getLoadFetchSize());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + sql));
            }
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    CtrlEvent event = new CtrlEvent(rs);
                    event.setWFRConnection(this.oldWfrConn.remove(event.getId()));
                    Map<Long, CtrlEvent> map = this.events;
                    synchronized (map) {
                        this.events.put(event.getId(), event);
                        this.events.notifyAll();
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.e = e;
        }
        log.info((Object)("unused old wfr connections: " + this.oldWfrConn.size()));
        Iterator<WorkflowResultConnection> it = this.oldWfrConn.values().iterator();
        while (true) {
            if (!it.hasNext()) {
                this.status = Status.READY;
                Map<Long, CtrlEvent> map = this.events;
                synchronized (map) {
                    this.events.notify();
                    return;
                }
            }
            it.next().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtrlEvent get(long id) throws SQLException {
        Map<Long, CtrlEvent> map;
        CtrlEvent event = null;
        do {
            map = this.events;
            synchronized (map) {
                event = this.events.get(id);
                if (event != null) {
                    this.events.remove(id);
                    return event;
                }
                if (this.status != Status.READY && this.e != null) {
                    try {
                        this.events.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } while (event == null && this.status != Status.READY && this.e == null);
        if (this.e != null) {
            throw this.e;
        }
        map = this.events;
        synchronized (map) {
            event = this.events.get(id);
            if (event != null) {
                this.events.remove(id);
                return event;
            }
        }
        throw new SQLException("event " + id + " not found in db");
    }
}

