/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.FcId;
import de.axway.aim.controller.master.Status;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FcLoad
extends ManagedRunnableImpl {
    private static Log log = LogFactory.getLog((String)"master.Loader.Fc");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.FcLoad");
    private LinkedList<FcId> fc = new LinkedList();
    private Status status = Status.START;
    private SQLException e = null;
    private CtrlDispAppl dispatcher;

    public FcLoad(CtrlDispAppl dispatcher) {
        this.dispatcher = dispatcher;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcId getFirst() throws SQLException {
        LinkedList<FcId> linkedList;
        do {
            linkedList = this.fc;
            synchronized (linkedList) {
                if (this.fc.size() > 0) {
                    return this.fc.removeFirst();
                }
                if (this.status != Status.READY && this.e == null) {
                    try {
                        this.fc.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } while (this.status != Status.READY && this.e == null);
        if (this.e != null) {
            throw this.e;
        }
        linkedList = this.fc;
        synchronized (linkedList) {
            if (this.fc.size() > 0) {
                return this.fc.removeFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        this.setName("Functioncall Loader");
        this.status = Status.RUN;
        try (Connection con = this.dispatcher.getConnection();){
            String sql = "select stepretry, steplevel, seqnr, seqretry, rc, rctype, creationdate, readydate, slave, call_level, jobid, jobstep from ctrl_fc order by jobid, jobstep, stepretry desc, steplevel desc, seqnr desc, seqretry desc, call_level desc";
            PreparedStatement stmt = con.prepareStatement(sql);
            stmt.setFetchSize(this.dispatcher.getEdiboss().getLoadFetchSize());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + sql));
            }
            try (ResultSet rs = stmt.executeQuery();){
                long prevJobId = -1L;
                int prevStep = -1;
                while (rs.next()) {
                    long newJobId = rs.getLong(11);
                    int newStep = rs.getInt(12);
                    int stepRetry = rs.getInt(1);
                    int stepLevel = rs.getInt(2);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("new fc result: " + newJobId + '.' + newStep + '.' + stepRetry + '.' + stepLevel));
                    }
                    if (newJobId == prevJobId && newStep == prevStep) continue;
                    CtrlFunctionCall fc = new CtrlFunctionCall(null, rs, false, this.dispatcher);
                    if (stepRetry <= 0) {
                        log.error((Object)("invalid functioncall: " + newJobId + "." + newStep + "." + stepRetry));
                    }
                    if (fc.getSeqNo() <= 0) {
                        log.error((Object)("invalid functioncall(seqno <= 0): " + newJobId + "." + newStep + "." + stepRetry));
                    }
                    LinkedList<FcId> linkedList = this.fc;
                    synchronized (linkedList) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("new fc added: " + newJobId + '.' + newStep + '.' + stepRetry + '.' + stepLevel));
                        }
                        this.fc.add(new FcId(newJobId, newStep, stepRetry, stepLevel, fc));
                        this.fc.notifyAll();
                    }
                    prevJobId = newJobId;
                    prevStep = newStep;
                }
                this.status = Status.READY;
                LinkedList<FcId> linkedList = this.fc;
                synchronized (linkedList) {
                    this.fc.notifyAll();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.e = e;
        }
        this.status = Status.READY;
        LinkedList<FcId> linkedList = this.fc;
        synchronized (linkedList) {
            this.fc.notifyAll();
        }
    }
}

