/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.lib.FunctionCall;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.lib.JobStep;
import de.axway.aim.controller.lib.JslEntry;
import de.axway.aim.controller.master.CtrlEdiComp;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IRemovable;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.util.JSystem;
import de.axway.lib.util.JSystemStreamHandler;
import de.axway.lib.util.JSystemStreamHandlerImpl;
import de.axway.lockDaemon.LockException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IJob<Dest>
extends Job
implements IRemovable,
IExecutable,
Comparable<IExecutable> {
    private static final String archiveMsg = "%10d|%10d|%s|RC=%d errno=0 %s|Comp #%d %s=%s|";
    protected static Log log = LogFactory.getLog((String)"master.Job");
    protected static Log dbLog = LogFactory.getLog((String)"master.DB.Job");
    private static final String CRAZY_EDIOBJ_PATTERN = ".*(\\$\\(EDIOBJ\\.[0-9]+\\)).*";

    @Override
    public abstract long getRemoveDate();

    public abstract long getActivateDate();

    public abstract void suspend(long var1, Attributes<String> var3, Dest var4) throws SQLException;

    public abstract void activate(Dest var1) throws SQLException;

    public abstract boolean matchActivateAttr(Attribute<String> var1);

    public abstract void update(Dest var1) throws SQLException;

    public abstract void insert(Dest var1) throws SQLException, LockException;

    public abstract String evalPar(String var1, boolean var2, boolean var3) throws CfgException, SQLException;

    public abstract FunctionCall getLastFc();

    public IJob(IJob job) {
        super((Job)job);
    }

    public IJob(long creationDate, Event parent, CfgJSelectEntry jslEntry) {
        super(creationDate, parent, (JslEntry)jslEntry);
        if (jslEntry != null) {
            jslEntry.setUsed(true);
        }
    }

    @Override
    public int compareTo(IExecutable job) {
        if (this.getId() == job.getId()) {
            return 0;
        }
        if (this.getPrio() > job.getPrio()) {
            return -1;
        }
        if (this.getPrio() < job.getPrio()) {
            return 1;
        }
        if (this.getId() < job.getId()) {
            return -1;
        }
        if (this.getId() > job.getId()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getCurrentStepName() {
        JobStep js = this.getCurrentStep();
        if (js != null) {
            return js.getName();
        }
        return "<invalid>";
    }

    public String getSeqName() {
        return this.getEvt().getAttr(this.getEaSignific());
    }

    public int getStepCount() {
        return ((CfgJSelectEntry)this.getJsl()).getJobEntry().getStepCount();
    }

    public long getJslId() {
        if (this.jslEntry == null) {
            return -1L;
        }
        return ((CfgJSelectEntry)this.jslEntry).getId();
    }

    public String getOnError() {
        if (this.jslEntry == null) {
            return "";
        }
        return this.jslEntry.getOnError();
    }

    public boolean getAccountingOn() {
        if (this.jslEntry == null) {
            return false;
        }
        return ((CfgJSelectEntry)this.jslEntry).getAccountingOn();
    }

    public Set<String> getComps2Archive() {
        if (this.jslEntry == null) {
            return null;
        }
        return ((CfgJSelectEntry)this.jslEntry).getComps2Arch();
    }

    public Set<String> getComps2Keep() {
        if (this.jslEntry == null) {
            return null;
        }
        return ((CfgJSelectEntry)this.jslEntry).getComps2Keep();
    }

    public String getOnRetryFull() {
        if (this.jslEntry == null) {
            return "";
        }
        return this.jslEntry.getOnRetryFull();
    }

    public String getArchiveCmd() {
        if (this.jslEntry == null) {
            return "";
        }
        return ((CfgJSelectEntry)this.jslEntry).getArchiveCmd();
    }

    public CfgTimeWindowEntry getTimeWindow() {
        if (this.jslEntry == null) {
            return null;
        }
        return ((CfgJSelectEntry)this.jslEntry).getTimeWindow();
    }

    public void execOnError() {
        this.execOnError(-1);
    }

    public void execOnRetryFull() {
        this.execOnRetryFull(-1);
    }

    public void execOnError(int timeout) {
        log.debug((Object)"execOnError start:");
        this.execShell("onError", this.getOnError(), timeout);
    }

    public void execOnRetryFull(int timeout) {
        log.debug((Object)"execOnRetryFull start:");
        this.execShell("onRetryFull", this.getOnRetryFull(), timeout);
    }

    public Set<String> execArchiveCmd() {
        return this.execArchiveCmd(-1);
    }

    public Set<String> execArchiveCmd(int timeout) {
        int rc;
        int i;
        Iterator it;
        CtrlEdiComp comp2;
        log.debug((Object)"execArchiveCmd start: ");
        HashSet<String> archFailed = new HashSet<String>();
        Set<String> comps2Arch = null;
        HashSet<String> currCompNames = null;
        LinkedList<CtrlEdiComp> currComps = new LinkedList<CtrlEdiComp>();
        String archCmdPattern = null;
        String archCmd = null;
        Pattern p = null;
        Matcher m = null;
        StringBuilder fileNames = null;
        TreeSet<CtrlEdiComp> sortedComp = new TreeSet<CtrlEdiComp>();
        archCmdPattern = this.getArchiveCmd();
        if (log.isDebugEnabled()) {
            log.debug((Object)("archive command pattern: '" + archCmdPattern + "'"));
        }
        if (archCmdPattern == null || archCmdPattern.length() == 0 || archCmdPattern.equalsIgnoreCase("n")) {
            log.debug((Object)"No archive shell script defined!");
            return null;
        }
        comps2Arch = this.getComps2Archive();
        if (comps2Arch == null || comps2Arch.size() == 0) {
            log.debug((Object)"No components to archive defined.");
            return null;
        }
        Iterator<String> strIt = comps2Arch.iterator();
        while (strIt.hasNext()) {
            comp2 = (CtrlEdiComp)this.getComp(strIt.next());
            if (comp2 == null) continue;
            sortedComp.add(comp2);
        }
        if (sortedComp.size() == 0) {
            log.debug((Object)"All EDI object components to be archived do not exist!");
            return null;
        }
        if (archCmdPattern.contains("$(EDIOBJ.*)")) {
            fileNames = new StringBuilder();
            it = sortedComp.iterator();
            i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    fileNames.append(" ");
                }
                fileNames.append(((CtrlEdiComp)((Object)it.next())).getFileName());
                ++i;
            }
            archCmd = archCmdPattern.replace("$(EDIOBJ.*)", fileNames);
            rc = this.execShell("ARCHIVE EDI file", archCmd, timeout);
            if (rc == 0) {
                for (CtrlEdiComp comp2 : sortedComp) {
                    Logbook.getLogbook().info(String.format(archiveMsg, this.getId(), this.getId(), "ARCHIVE EDI file", 0, "OK", 1 + comp2.getNum(), comp2.getName(), comp2.getFileName()));
                }
            } else {
                for (CtrlEdiComp comp2 : sortedComp) {
                    archFailed.add(comp2.getName());
                    Logbook.getLogbook().error(String.format(archiveMsg, this.getId(), this.getId(), "ARCHIVE EDI file", rc, "FAILED", 1 + comp2.getNum(), comp2.getName(), comp2.getFileName()));
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Look for pattern '.*(\\$\\(EDIOBJ\\.[0-9]+\\)).*'");
            }
            if ((m = (p = Pattern.compile(CRAZY_EDIOBJ_PATTERN)).matcher(archCmdPattern)).matches()) {
                String ediObjPat = m.group(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found EDIOBJ.n: " + ediObjPat));
                }
                i = ediObjPat.indexOf(46);
                int j = ediObjPat.indexOf(41);
                int numPerCall = Integer.valueOf(ediObjPat.substring(i + 1, j));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number per archive call: " + numPerCall));
                }
                currCompNames = new HashSet<String>();
                it = sortedComp.iterator();
                while (it.hasNext()) {
                    fileNames = new StringBuilder();
                    currComps.clear();
                    for (i = 0; i < numPerCall && it.hasNext(); ++i) {
                        if (i > 0) {
                            fileNames.append(" ");
                        }
                        comp2 = (CtrlEdiComp)((Object)it.next());
                        fileNames.append(comp2.getFileName());
                        currCompNames.add(comp2.getName());
                        currComps.add(comp2);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("File group: " + fileNames));
                    }
                    archCmd = archCmdPattern.replace(ediObjPat, fileNames);
                    rc = this.execShell("ARCHIVE EDI file", archCmd, timeout);
                    if (rc != 0) {
                        archFailed.addAll(currCompNames);
                        for (j = 0; j < currComps.size(); ++j) {
                            comp2 = (CtrlEdiComp)((Object)currComps.get(j));
                            Logbook.getLogbook().error(String.format(archiveMsg, this.getId(), this.getId(), "ARCHIVE EDI file", rc, "FAILED", 1 + comp2.getNum(), comp2.getName(), comp2.getFileName()));
                        }
                    } else {
                        for (j = 0; j < currComps.size(); ++j) {
                            comp2 = (CtrlEdiComp)((Object)currComps.get(j));
                            Logbook.getLogbook().info(String.format(archiveMsg, this.getId(), this.getId(), "ARCHIVE EDI file", 0, "OK", 1 + comp2.getNum(), comp2.getName(), comp2.getFileName()));
                        }
                    }
                    currCompNames.clear();
                }
            } else {
                log.warn((Object)"Neither $(EDIOBJ.*) nor $(EDIOBJ.n) pattern found in archive command line!");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Archive of " + archFailed.size() + " components failed."));
            strIt = archFailed.iterator();
            while (strIt.hasNext()) {
                log.debug((Object)("Archive failed for: " + strIt.next()));
            }
        }
        return archFailed;
    }

    private int execShell(String what, String cmd, int timeout) {
        int rc = -1;
        String currCmd = null;
        String stderrData = null;
        String stdoutData = null;
        CtrlFunctionCall fc = null;
        if (cmd != null && cmd.length() > 0 && !cmd.equalsIgnoreCase("N")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Call shell-" + what + " command: " + cmd));
            }
            JSystem jsystem = new JSystem((JSystemStreamHandler)new JSystemStreamHandlerImpl());
            long startTime = System.currentTimeMillis();
            try {
                currCmd = this.evalPar(cmd, true, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(what + ": Evaluated command line: " + currCmd));
                }
                rc = jsystem.exec(currCmd, timeout);
                stdoutData = jsystem.getStdoutData();
                stderrData = jsystem.getStderrData();
            }
            catch (Exception e) {
                rc = -1;
            }
            if (cmd == this.getOnError()) {
                fc = (CtrlFunctionCall)this.getLastFc();
                Logbook.getLogbook().onError(this.getName(), this.getId(), this.getCurrentStepName(), fc != null ? fc.getInstanceNameWOL() : "", rc, (System.currentTimeMillis() - startTime) / 1000L, currCmd);
            } else if (cmd.equals(this.getOnRetryFull())) {
                fc = (CtrlFunctionCall)this.getLastFc();
                Logbook.getLogbook().onRetryFull(this.getName(), this.getId(), this.getCurrentStepName(), fc != null ? fc.getInstanceNameWOL() : "", rc, (System.currentTimeMillis() - startTime) / 1000L, currCmd);
            } else {
                Logbook.getLogbook().systemCall(what, this.getId(), "", rc, (System.currentTimeMillis() - startTime) / 1000L, currCmd);
            }
            if (stderrData != null && stderrData.length() > 0 || stdoutData != null && stdoutData.length() > 0) {
                Logbook.getLogbook().error("Cannot execute '" + currCmd + "'\nstderr: " + stderrData + "\nstdout: " + stdoutData);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No shell script for " + what + " defined!"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("execShell: rc: " + rc));
        }
        return rc;
    }
}

