/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.CtrlVar;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.lib.aim.AIMObject;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class JAIMObject
extends AIMObject {
    private static Log log = LogFactory.getLog((String)"master.JAIMObject");
    private int ea_signific = -1;
    private String initiatorHost;
    private int step;
    private int xx = 0;
    private static String[] USER_DATA_NAMES = new String[]{"USER_DATA1", "USER_DATA2", "USER_DATA3", "USER_DATA4", "USER_DATA5"};

    public JAIMObject(CtrlJob job, Attributes<String> evtAttr, Attributes<String> evtPar, Attributes<String> jobVar, String refNo) {
        int i;
        this.setSeq(job.getCurrentStep(), evtAttr, evtPar, jobVar);
        this.setObjectID((int)job.getId());
        this.setJobID((int)job.getId());
        this.setState(job.getObjectStatus());
        this.setJobName(job.getName());
        this.setCreationDate(new Date(job.getCreationDate()));
        this.initiatorHost = job.getEvt().getInitiatorHost();
        if (evtAttr != null) {
            this.setSender((String)evtAttr.get("SENDER"));
            this.setObjectClass((String)evtAttr.get("OBJ_CLASS"));
            this.setReceiver((String)evtAttr.get("RECEIVER"));
            this.setReferenceNo(refNo);
        } else if (job.getEvt() != null && job.getEvt().getAttr() != null) {
            this.setSender(job.getEvt().getAttr("SENDER"));
            this.setObjectClass(job.getEvt().getAttr("OBJ_CLASS"));
            this.setReceiver(job.getEvt().getAttr("RECEIVER"));
            this.setReferenceNo(job.getEvt().getRefNo());
        }
        if (jobVar != null) {
            for (i = 0; i < USER_DATA_NAMES.length; ++i) {
                String v = (String)jobVar.get(USER_DATA_NAMES[i]);
                if ((v == null || v.length() == 0) && evtPar != null) {
                    v = (String)evtPar.get(USER_DATA_NAMES[i]);
                }
                this.setUserField(i, v == null ? "" : v);
            }
        } else {
            for (i = 0; i < USER_DATA_NAMES.length; ++i) {
                Value vVal = job.getVar(USER_DATA_NAMES[i]);
                String v = null;
                if ((vVal == null || ((String)vVal.get()).length() == 0) && job.getEvt() != null) {
                    v = job.getEvt().getVar(USER_DATA_NAMES[i]);
                    if ((v == null || v.length() == 0) && evtPar != null) {
                        v = (String)evtPar.get(USER_DATA_NAMES[i]);
                    }
                } else {
                    v = (String)vVal.get();
                }
                this.setUserField(i, v == null ? "" : v);
            }
        }
        this.setJsName(job.getCurrentStepName());
        this.ea_signific = job.getEaSignific();
        this.step = job.getActiveStep();
        if (this.seqJob() || this.seqJobStep()) {
            int x;
            Iterator it = evtAttr != null ? evtAttr.iterator(0) : job.getEvt().getAttrList().iterator();
            int n = x = this.ea_signific > 0 ? this.ea_signific : Integer.MAX_VALUE;
            while (it.hasNext() && x > 0) {
                Attribute a = (Attribute)it.next();
                this.addEvtAttr(a.getName(), (String)a.get());
                --x;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("created: " + (Object)((Object)this)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + this.getObjectID() + ", sender: " + this.getSender() + ", receive: " + this.getReceiver() + ", obj class: " + this.getObjectClass()));
        }
    }

    public void setSeq(CtrlJobStep js, Attributes<String> evtAttr, Attributes<String> evtPar, Attributes<String> jobVar) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        if (js == null) {
            this.setFunctionHandler(-1);
        } else {
            if (js.isGrouped()) {
                try {
                    if (evtAttr != null) {
                        String cfgName = js.getRealGroupName();
                        this.setGroupName(CtrlVar.eval(cfgName, false, false, js.getJob(), 0, new Map[]{js.getVars(), js.getJob().getVarTable(), evtAttr, js.getJob().getJsl().getPar(), evtPar, jobVar}));
                    } else {
                        this.setGroupName(js.getGroupName());
                    }
                }
                catch (Exception e) {
                    this.setGroupName("*** invalid ***");
                    log.warn((Object)"getGroupName", (Throwable)e);
                }
                this.setMaxCalls(js.getMaxGroupCalls());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("JS name: " + this.getJsName() + " set group,maxCalls: " + this.getGroup() + "/" + this.getMaxCalls()));
            }
            try {
                List<SlaveHandler> sl = js.getSlaves();
                if (sl != null && sl.size() > 0) {
                    this.setFunctionHandler((int)sl.get(0).getId());
                }
            }
            catch (CfgException e) {
                this.setFunctionHandler(-1);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end:");
        }
    }

    public int getEaSignific() {
        return this.ea_signific;
    }

    public int getStep() {
        return this.step;
    }

    public int strlen(String str) {
        return str == null ? 0 : str.length();
    }

    private void setUserField(int fieldNo, String val) {
        switch (fieldNo) {
            case 0: {
                this.setUserField1(val);
                break;
            }
            case 1: {
                this.setUserField2(val);
                break;
            }
            case 2: {
                this.setUserField3(val);
                break;
            }
            case 3: {
                this.setUserField4(val);
                break;
            }
            case 4: {
                this.setUserField5(val);
                break;
            }
            default: {
                log.error((Object)("Invalid user field number: " + fieldNo));
            }
        }
    }

    public int getLength() {
        return 36 + this.strlen(this.getJsName()) + this.strlen(this.getReferenceNo()) + this.strlen(this.getUserField1()) + this.strlen(this.getUserField2()) + this.strlen(this.getUserField3()) + this.strlen(this.getUserField4()) + this.strlen(this.getUserField5()) + this.strlen(this.getGroup()) + this.strlen(this.getSender()) + this.strlen(this.getObjectClass()) + this.strlen(this.getReceiver()) + this.strlen(this.getJobName());
    }
}

