/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.master.BoCycleId;
import de.axway.aim.controller.master.BoTo;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.FpCurrentTime;
import de.axway.aim.controller.master.FpEvtAttrSize;
import de.axway.aim.controller.master.FpEvtType;
import de.axway.aim.controller.master.FpJobId;
import de.axway.aim.controller.master.FpJobPrio;
import de.axway.aim.controller.master.FpJobSeq;
import de.axway.aim.controller.master.FpJobStepMaxRetry;
import de.axway.aim.controller.master.FpJobStepName;
import de.axway.aim.controller.master.FpJobStepNo;
import de.axway.aim.controller.master.FpJobStepRemain;
import de.axway.aim.controller.master.FpJobStepRetry;
import de.axway.aim.controller.master.FpJobTil;
import de.axway.aim.controller.master.FpJsFcCount;
import de.axway.aim.controller.master.FpLastRc;
import de.axway.aim.controller.master.WfCycleId;
import de.axway.aim.controller.master.WfTo;
import de.axway.aim.controller.master.account.Tsim2Sentinel;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.util.ActisFile;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobConst {
    private static Log log = LogFactory.getLog((String)"master.JobConst");
    public static final Value actisEdi = new Value((Object)ActisFile.getACTISEDI());
    public static final String ACTISEDI = "ACTISEDI";
    public static final String LAST_RC = "LAST_RC";
    public static final String CURRENT_TIME = "CURRENT_TIME";
    public static final String OBJ_CLASS = "OBJ_CLASS";
    public static final String OBJECT_CLASS = "OBJECT_CLASS";
    public static final String SEQ = "SEQUENTIALIZIED";
    public static final String PRIO = "PRIORITY";
    public static final String ID = "JOB_ID";
    public static final String TIL_JID = "TIL_JID";
    public static final String JOB_NAME = "JOB_NAME";
    public static final String JOBNAME = "JOBNAME";
    public static final String EVENT_ID = "EVENT_ID";
    public static final String EVENT_TYPE = "EVENT_TYPE";
    public static final String EVT_INITIATOR = "EVT_INITIATOR";
    public static final String EVT_CF_ID = "EVT_CF_ID";
    public static final String EVT_HOSTNAME = "EVT_HOSTNAME";
    public static final String EVT_ATTR_ITEMS = "EVT_ATTR_ITEMS";
    public static final String OBJECT_ID = "OBJECT_ID";
    public static final String REFNO = "REFNO";
    public static final String JOBSTEP_NO = "JOBSTEP_NO";
    public static final String JS_NAME = "JS_NAME";
    public static final String JS_RETRY = "JS_RETRY";
    public static final String JS_MAXRETRY = "JS_MAXRETRY";
    public static final String JS_REMAIN = "JS_REMAIN";
    public static final String JS_FC_COUNT = "JS_FC_COUNT";
    public static final String WF_CYCLE_ID = "WF_CYCLE_ID";
    public static final String WF_TO = "WF_TO";
    public static final String EXT_CYCLE_ID = "EXT_CYCLE_ID";
    public static final String EXT_TO = "EXT_TO";
    public static final String BO_CYCLE_ID = "BO_CYCLE_ID";
    public static final String BO_TO = "BO_TO";
    public static final String INITIATOR = "INITIATOR";
    private Hashtable<String, Value<String>> table = new Hashtable(24);

    public JobConst(CtrlJob job) {
        this.table.put(ACTISEDI, (Value<String>)actisEdi);
        this.table.put(LAST_RC, new FpLastRc(job));
        this.table.put(CURRENT_TIME, new FpCurrentTime(job));
        this.addAttr(OBJECT_CLASS, OBJ_CLASS, (Attributes<String>)job.getEvt().getAttr());
        this.table.put(SEQ, new FpJobSeq(job));
        this.table.put(PRIO, new FpJobPrio(job));
        this.table.put(ID, new FpJobId(job));
        this.table.put(TIL_JID, new FpJobTil(job));
        Value jobname = new Value((Object)job.getName());
        this.table.put(JOB_NAME, (Value<String>)jobname);
        this.table.put(JOBNAME, (Value<String>)jobname);
        this.table.put(EVENT_ID, new FpJobId(job));
        this.table.put(EVENT_TYPE, new FpEvtType(job.getEvt().isTimeEvent()));
        this.table.put(EVT_INITIATOR, (Value<String>)new Value((Object)job.getEvt().getInitiator()));
        this.table.put(EVT_CF_ID, (Value<String>)new Value((Object)job.getEvt().getCorefuncId()));
        this.table.put(EVT_HOSTNAME, (Value<String>)new Value((Object)job.getEvt().getInitiatorHost()));
        if (job.getEvt().getAttr() == null) {
            log.warn((Object)("Event Attributes for job " + job.getId() + " are missing"));
            Logbook.getLogbook().warning("Event Attributes missing for job " + job.getId());
            this.table.put(EVT_ATTR_ITEMS, new FpEvtAttrSize(0));
        } else {
            this.table.put(EVT_ATTR_ITEMS, new FpEvtAttrSize(job.getEvt().getAttr().size()));
        }
        this.table.put(OBJECT_ID, new FpJobId(job));
        this.table.put(REFNO, (Value<String>)new Value((Object)job.getEvt().getRefNo()));
        this.table.put(JOBSTEP_NO, new FpJobStepNo(job));
        this.table.put(JS_NAME, new FpJobStepName(job));
        this.table.put(JS_RETRY, new FpJobStepRetry(job));
        this.table.put(JS_MAXRETRY, new FpJobStepMaxRetry(job));
        this.table.put(JS_REMAIN, new FpJobStepRemain(job));
        this.table.put(JS_FC_COUNT, new FpJsFcCount(job));
        if (Tsim2Sentinel.initialized()) {
            this.table.put(WF_TO, new WfTo());
            this.table.put(WF_CYCLE_ID, new WfCycleId(job));
            this.table.put(BO_TO, new BoTo());
            this.table.put(BO_CYCLE_ID, new BoCycleId(job));
        }
    }

    public Hashtable<String, Value<String>> getTable() {
        return this.table;
    }

    private void addAttr(String name, String attrName, Attributes<String> attr) {
        String v = null;
        if (attr == null) {
            return;
        }
        try {
            v = (String)attr.get(attrName);
        }
        catch (NoSuchElementException e) {
            return;
        }
        if (v == null) {
            v = "";
        }
        this.table.put(name, (Value<String>)new Value((Object)v));
    }
}

