/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.JslBuiltin;
import de.axway.aim.controller.master.LockJob;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lockDaemon.LockDaemon;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.SyncObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class JobRunner
extends WorkerThread {
    private static Log log = LogFactory.getLog((String)"master.SlaveHandler");
    private static final int maxCalls = 25;
    private static final long minTime = 40L;
    private static long lastCall = 0L;
    private IExecutable executable;
    private SlaveHandler sh;
    private LockDaemon ld;
    private String myName;
    protected boolean isRunning = false;

    public JobRunner(SlaveHandler sh, IExecutable job) {
        super(1);
        this.executable = job;
        this.sh = sh;
        this.ld = sh.getLockDaemon();
        this.myName = job.getName() + "/" + job.getCurrentStepName() + "/" + job.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() {
        block54: {
            try {
                this.setName(this.myName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LockJob lj = new LockJob(this.executable.getId());
            CtrlSlave slave = this.sh.getSlave();
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("JobRunner:doRun[job=" + this.executable.getId() + ", slave=" + slave.getName() + "]"));
                }
                if (!this.sh.dispatcher.getHealthStatus().proceed(false)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("JobRunner:doRun[job=" + this.executable.getId() + ", slave=" + slave.getName() + "]: stopped processing. Workflow " + this.executable.getId() + " has been reset and rescheduled to be rerun when the system has recovered from the temporary database failure."));
                    }
                    this.sh.getQueue().runJob(this.executable);
                    this.sh.delQueuedJob(this.executable.getId(), this);
                    return;
                }
                if (this.ld.globalLock((SyncObject)lj)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("JobRunner:doRun[job=" + this.executable.getId() + ", slave=" + slave.getName() + "]: locked job."));
                    }
                    if (!this.sh.runningJobsContains(this.executable.getId(), this)) {
                        try {
                            this.ld.globalUnLock((SyncObject)lj);
                        }
                        catch (LockException ee) {
                            log.error((Object)("JobRunner:doRun - lockException at unlocking job id=" + this.executable.getId() + ", slave=" + slave.getName()), (Throwable)ee);
                        }
                        try {
                            slave.delRunningJob();
                        }
                        catch (LockException ee) {
                            log.error((Object)"remove slave slot  .", (Throwable)ee);
                            Logbook.getLogbook().error("remove slave slot: " + (Object)((Object)ee));
                        }
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("JobRunner:doRun[job=" + this.executable.getId() + ", slave=" + slave.getName() + "]: unlocked slave."));
                        }
                        return;
                    }
                } else {
                    this.sh.getQueue().runJob(this.executable);
                    this.sh.delQueuedJob(this.executable.getId(), this);
                    return;
                }
                this.isRunning = true;
                if (!this.sh.getEdiboss().hasMultiThread()) {
                    Class<?> e = this.getClass();
                    synchronized (e) {
                        long wait = lastCall + 40L - System.currentTimeMillis();
                        if (wait > 0L) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("JobRunner:doRun[job=" + this.executable.getId() + ", slave=" + slave.getName() + "]: wait for " + wait + " milliseconds."));
                            }
                            try {
                                Thread.sleep(wait);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        lastCall = System.currentTimeMillis();
                    }
                }
                if (this.executable instanceof JslBuiltin) {
                    try {
                        this.sh.execBuiltin((JslBuiltin)this.executable);
                    }
                    catch (Throwable e) {
                        Logbook.getLogbook().error(this.sh.getName() + " execute builtin " + this.executable.getId() + ": " + e);
                    }
                    try {
                        this.sh.getSlave().delRunningJob();
                    }
                    catch (LockException e) {
                        log.error((Object)"remove slave slot", (Throwable)e);
                        Logbook.getLogbook().error("remove slave slot: " + (Object)((Object)e));
                    }
                    this.sh.delQueuedJob(this.executable.getId(), this);
                    break block54;
                }
                CtrlJob job = (CtrlJob)this.executable;
                try {
                    this.processRegularFunctioncall(job, slave, lj);
                }
                finally {
                    this.sh.delQueuedJob(this.executable.getId(), this);
                }
            }
            finally {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("JobRunner:doRun[job=" + this.executable.getId() + ", slave=" + slave.getName() + "]: unlocked job."));
                    }
                    this.ld.globalUnLock((SyncObject)lj);
                }
                catch (Throwable e) {
                    log.error((Object)"remove lock in finally block ", e);
                    Logbook.getLogbook().error("Cannot unlock job " + this.executable.getId() + ": " + e);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("JobRunner:doRun[job=" + this.executable.getId() + ", slave=" + slave.getName() + "]: Exit doRun."));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void processRegularFunctioncall(CtrlJob job, CtrlSlave slave, LockJob lj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resheduleJob(CtrlJob job, CtrlJob savedJobState) {
        job.rollback(savedJobState);
        this.sh.getQueue().runJob(job);
        log.error((Object)("Workflow " + job.getId() + " has been reset and rescheduled to be rerun when the system has recovered from the temporary database failure."));
        Logbook.getLogbook().error("Workflow " + job.getId() + " has been reset and rescheduled to be rerun when the system has recovered from the temporary database failure.");
    }

    @Override
    public String toString() {
        return "JobRunner:  " + this.myName;
    }
}

