/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlDispAppl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JoseLoader {
    private static int QUEUE_SIZE = 1000;
    protected static Log log = LogFactory.getLog((String)"master.JoseLoader");
    private AttrLoader eaLoader;
    private AttrLoader epLoader;
    private AttrLoader jvLoader;
    private RefNoLoader refNoLoader;
    private LinkedBlockingQueue<IdObj<Attributes>> eventAttr = new LinkedBlockingQueue(QUEUE_SIZE);
    private LinkedBlockingQueue<IdObj<Attributes>> eventPar = new LinkedBlockingQueue(QUEUE_SIZE);
    private LinkedBlockingQueue<IdObj<Attributes>> jobVar = new LinkedBlockingQueue(QUEUE_SIZE);
    private CtrlDispAppl dispatcher;

    public JoseLoader(CtrlDispAppl dispatcher) {
        this.dispatcher = dispatcher;
        this.refNoLoader = new RefNoLoader();
        this.eaLoader = new AttrLoader(this.eventAttr, "select jobid, name, value from ctrl_evtattr order by jobid, attrno", "event attr");
        this.epLoader = new AttrLoader(this.eventPar, "select jobid, name, value from ctrl_evtparam order by jobid, attrno", "event par");
        this.jvLoader = new AttrLoader(this.jobVar, "select jobid, name, value from ctrl_jobvar order by jobid, num", "job var");
    }

    public void stop() {
        this.refNoLoader.ready = true;
        this.refNoLoader.interrupt();
        this.eaLoader.ready = true;
        this.eaLoader.interrupt();
        this.epLoader.ready = true;
        this.epLoader.interrupt();
        this.jvLoader.ready = true;
        this.jvLoader.interrupt();
    }

    public Attributes getEventAttr(long id) throws SQLException, InterruptedException {
        return this.eaLoader.getAttr(id);
    }

    public Attributes getEventPar(long id) throws SQLException, InterruptedException {
        return this.epLoader.getAttr(id);
    }

    public Attributes getJobVar(long id) throws SQLException, InterruptedException {
        return this.jvLoader.getAttr(id);
    }

    public String getRefNo(long id) throws SQLException, InterruptedException {
        return this.refNoLoader.getRefNo(id);
    }

    static /* synthetic */ int access$000() {
        return QUEUE_SIZE;
    }

    class AttrLoader
    extends Thread {
        private LinkedBlockingQueue<IdObj<Attributes>> attr;
        private String sql;
        private SQLException sqle = null;
        private InterruptedException ie = null;
        private boolean ready = false;
        private String name;

        public AttrLoader(LinkedBlockingQueue<IdObj<Attributes>> attr, String sql, String name) {
            this.attr = attr;
            this.sql = sql;
            this.name = name;
            this.setName("jose " + name + " loader");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Attributes getAttr(long id) throws SQLException, InterruptedException {
            IdObj<Attributes> a = null;
            LinkedBlockingQueue<IdObj<Attributes>> linkedBlockingQueue = this.attr;
            synchronized (linkedBlockingQueue) {
                while (((a = this.attr.peek()) == null && !this.ready || a != null && a.getId() < id) && this.sqle == null && this.ie == null) {
                    if (a != null && a.getId() < id) {
                        a = this.attr.take();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("remove unused " + this.name + ", id = " + a.getId() + ", getAttr (" + id + ")"));
                        continue;
                    }
                    this.attr.wait();
                }
            }
            if (this.sqle != null) {
                throw this.sqle;
            }
            if (this.ie != null) {
                throw this.ie;
            }
            if (a != null && a.getId() == id) {
                a = this.attr.take();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get " + this.name + "(" + id + "): " + a.getObj().toString()));
                }
                return a.getObj();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("no " + this.name + " found, id = " + id));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Connection c = JoseLoader.this.dispatcher.getConnection();){
                c.setReadOnly(true);
                stmt.setFetchSize(JoseLoader.this.dispatcher.getEdiboss().getLoadFetchSize());
                try (PreparedStatement stmt = c.prepareStatement(this.sql);
                     ResultSet rs = stmt.executeQuery();){
                    Attributes as = null;
                    long prevJobId = -1L;
                    while (rs.next() && !this.ready) {
                        long newJobId = rs.getLong(1);
                        if (prevJobId != newJobId) {
                            if (prevJobId != -1L) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("new " + this.name + ", id = " + prevJobId + ", " + as.toString()));
                                }
                                this.attr.put(new IdObj<Attributes>(prevJobId, as));
                                LinkedBlockingQueue<IdObj<Attributes>> linkedBlockingQueue = this.attr;
                                synchronized (linkedBlockingQueue) {
                                    this.attr.notify();
                                }
                            }
                            as = new Attributes(Attributes.Type.PAR);
                            prevJobId = newJobId;
                        }
                        String value = rs.getString(3);
                        as.put(new Attribute(rs.getString(2), (Object)(value == null ? "" : value)));
                    }
                    if (prevJobId != -1L) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("new " + this.name + ", id = " + prevJobId + ", " + as.toString()));
                        }
                        this.attr.put(new IdObj<Object>(prevJobId, as));
                    }
                }
            }
            catch (InterruptedException ie) {
                this.ie = ie;
            }
            catch (SQLException e) {
                this.sqle = e;
            }
            finally {
                LinkedBlockingQueue<IdObj<Attributes>> ie = this.attr;
                synchronized (ie) {
                    this.ready = true;
                    this.attr.notify();
                }
                log.info((Object)"ready");
            }
        }
    }

    class RefNoLoader
    extends Thread {
        private LinkedBlockingQueue<IdObj<String>> refNo = new LinkedBlockingQueue(JoseLoader.access$000());
        private SQLException sqle = null;
        private InterruptedException ie = null;
        private boolean ready = false;

        public RefNoLoader() {
            this.setName("jose refNo loader");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try (Connection con = JoseLoader.this.dispatcher.getConnection();){
                con.setReadOnly(true);
                stmt.setFetchSize(JoseLoader.this.dispatcher.getEdiboss().getLoadFetchSize());
                try (PreparedStatement stmt = con.prepareStatement("select jobid, reference_no from ctrl_event order by jobid");
                     ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        if (this.ready) return;
                        String val = rs.getString(2);
                        val = val == null ? "" : val.intern();
                        this.refNo.put(new IdObj<String>(rs.getLong(1), val));
                        LinkedBlockingQueue<IdObj<String>> linkedBlockingQueue = this.refNo;
                        synchronized (linkedBlockingQueue) {
                            this.refNo.notify();
                        }
                    }
                    return;
                }
            }
            catch (InterruptedException ie) {
                this.ie = ie;
                return;
            }
            catch (SQLException e) {
                this.sqle = e;
                return;
            }
            finally {
                LinkedBlockingQueue<IdObj<String>> ie = this.refNo;
                synchronized (ie) {
                    this.ready = true;
                    this.refNo.notify();
                }
                log.info((Object)"ready");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String getRefNo(long id) throws SQLException, InterruptedException {
            IdObj<String> a = null;
            LinkedBlockingQueue<IdObj<String>> linkedBlockingQueue = this.refNo;
            synchronized (linkedBlockingQueue) {
                while (((a = this.refNo.peek()) == null && !this.ready || a != null && a.getId() < id) && this.sqle == null && this.ie == null) {
                    if (a != null && a.getId() < id) {
                        a = this.refNo.take();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("remove unused refno for job " + a.getId() + ", getRefNo (" + id + ")"));
                        continue;
                    }
                    this.refNo.wait();
                }
            }
            if (this.sqle != null) {
                throw this.sqle;
            }
            if (this.ie != null) {
                throw this.ie;
            }
            if (a != null && a.getId() == id) {
                return this.refNo.take().getObj();
            }
            return null;
        }
    }

    class IdObj<Type> {
        private long id;
        private Type obj;

        public IdObj(long id, Type obj) {
            this.id = id;
            this.obj = obj;
        }

        public long getId() {
            return this.id;
        }

        public Type getObj() {
            return this.obj;
        }
    }
}

