/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.builtin.Builtin;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JslBuiltin
extends CtrlBuiltin
implements IExecutable,
Comparable<IExecutable> {
    private static Log log = LogFactory.getLog((String)"master.JslBuiltin");
    private Event event = null;
    private CfgJSelectEntry jslEntry = null;
    private List<SlaveHandler> slaves = null;

    public JslBuiltin(Builtin builtin, Event event, CfgJSelectEntry jslEntry) {
        super(builtin);
        this.event = event;
        this.jslEntry = jslEntry;
    }

    @Override
    public boolean isGrouped() {
        return false;
    }

    @Override
    public boolean suspendJob(String ids, String activateAttr, long time) throws CfgException, InterruptedException {
        long suspTime = time;
        String timep = this.event.getVar("TIME_UNTIL");
        if (timep != null) {
            try {
                suspTime = TextCfg.getTime(timep);
            }
            catch (NumberFormatException e) {
                log.error((Object)e);
            }
        }
        return super.suspendJob(ids, activateAttr, suspTime);
    }

    public void setSlaves(List<SlaveHandler> bicSlaves) {
        this.slaves = bicSlaves;
    }

    @Override
    public int getPrio() {
        return 0;
    }

    @Override
    public long getNextExecTime() {
        NormalizedTimewindow window = this.jslEntry.getNormalizedTimewindow();
        if (window == null) {
            return 0L;
        }
        Date nearest = window.getNearest(new Date(), null);
        if (nearest == null) {
            return 2147483647000L;
        }
        return nearest.getTime();
    }

    @Override
    public List<SlaveHandler> getSlaves() {
        return this.slaves;
    }

    @Override
    public int compareTo(IExecutable job) {
        if (this.getId() == job.getId()) {
            return 0;
        }
        if (this.getPrio() > job.getPrio()) {
            return -1;
        }
        if (this.getPrio() < job.getPrio()) {
            return 1;
        }
        if (this.getId() < job.getId()) {
            return -1;
        }
        if (this.getId() > job.getId()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected EdiComp getEdiComp(String param) {
        return null;
    }

    @Override
    protected CtrlSlave getCompSlave() {
        return null;
    }

    @Override
    public long getId() {
        return this.event.getId();
    }

    @Override
    public boolean exec(CtrlDispAppl dispatcher, Connection con) throws Exception {
        boolean ret = super.exec(dispatcher, con, !this.isHidden());
        if (((CtrlEvent)this.event).isWrfConnected()) {
            if (ret) {
                ((CtrlEvent)this.event).sendWorkflowResult(true, 0, new Attributes("TEXT=\"Job ID: " + this.getId() + " successfully ended\""));
            } else {
                ((CtrlEvent)this.event).sendWorkflowResult(true, 1, new Attributes("TEXT=\"Job ID: " + this.getId() + " aborted\""));
            }
        }
        return ret;
    }

    public Attributes getEvtAttr() {
        return this.event.getAttr();
    }

    @Override
    public String[] getParam(String paramList, String paramName) throws CfgException {
        String param = this.event.getVar(paramName);
        if (param != null) {
            return param.split(" *, *");
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return this.builtin.isHidden();
    }
}

