/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.ISequence;
import de.axway.aim.controller.master.SequenceLock;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.lockDaemon.LockDaemon;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.SyncObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sequence
implements ISequence {
    private static Log log = LogFactory.getLog((String)"master.Sequence");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.Sequence");
    private static final String SQL_GETCURRENT = "select seq_value from ctrl_globals where sequence=?";
    private static final String SQL_UPDATE = "update ctrl_globals set seq_value=? where sequence=?";
    private static final String SQL_CREATE = "insert into ctrl_globals (seq_value,sequence) values (0,?)";
    public static final int SEQ_UNKNOWN = 0;
    public static final int SEQ_EVENT = 1;
    public static final int SEQ_CMD = 2;
    public static final int SEQ_APPL = 3;
    public static final int SEQ_JSL = 4;
    public static final int SEQ_JS = 5;
    private LockDaemon ld;
    private int sequence = 0;
    private int value = -1;

    public Sequence(LockDaemon ld, int sequence, Connection con) throws SQLException {
        this.ld = ld;
        this.sequence = sequence;
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + this));
        }
        this.setStartId(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextId(DataSource dataSource) throws SQLException, LockException {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: " + this));
        }
        SequenceLock seqLock = new SequenceLock(this.sequence);
        this.ld.globalLock((SyncObject)seqLock);
        int id = ++this.value;
        try (Connection con = dataSource.getConnection();){
            con.setAutoCommit(false);
            DebPrepStmt update = null;
            update = new DebPrepStmt(con, SQL_UPDATE, dbLog);
            try {
                update.setInt(1, id);
                update.setInt(2, this.sequence);
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeUpdate: " + update));
                }
                if (update.executeUpdate() != 1) {
                    throw new SQLException("could not update Sequence " + this.sequence);
                }
            }
            finally {
                update.close();
            }
            con.commit();
        }
        finally {
            this.ld.globalUnLock((SyncObject)seqLock);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + this + " ID val: " + id));
        }
        WorkerThread.addSeqTime(System.currentTimeMillis() - start);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStartId(Connection con) throws SQLException {
        block14: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: " + this));
            }
            try (DebPrepStmt select = new DebPrepStmt(con, SQL_GETCURRENT, dbLog);){
                select.setInt(1, this.sequence);
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeQuery: " + select));
                }
                try (ResultSet rs = select.executeQuery();){
                    if (!rs.next()) {
                        try (DebPrepStmt create = new DebPrepStmt(con, SQL_CREATE, dbLog);){
                            create.setInt(1, this.sequence);
                            if (dbLog.isDebugEnabled()) {
                                dbLog.debug((Object)("executeUpdate: " + create));
                            }
                            create.executeUpdate();
                            this.value = 0;
                            break block14;
                        }
                    }
                    this.value = rs.getInt(1);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + this + " ID val: " + this.value));
        }
    }

    public String toString() {
        String myName;
        switch (this.sequence) {
            case 1: {
                myName = "EVENT/";
                break;
            }
            case 2: {
                myName = "CMD/";
                break;
            }
            case 3: {
                myName = "APPL/";
                break;
            }
            case 4: {
                myName = "JSL/";
                break;
            }
            case 5: {
                myName = "SEQ_JS/";
                break;
            }
            default: {
                myName = "invalid/";
            }
        }
        return "Sequence SEQ_" + myName + this.sequence;
    }
}

