/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.lockDaemon.LockException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class StarterThreads {
    private CtrlDispAppl disp;
    private Set<StarterThread> threads = new HashSet<StarterThread>();
    private SQLException se = null;
    private LockException le = null;

    public StarterThreads(CtrlDispAppl disp) {
        this.disp = disp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newJob(IJob job) throws SQLException, LockException {
        this.isok();
        StarterThread st = new StarterThread(job);
        Set<StarterThread> set = this.threads;
        synchronized (set) {
            this.threads.add(st);
        }
        this.disp.getThreadPool().execute(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait4ready() throws SQLException, LockException {
        Set<StarterThread> set = this.threads;
        synchronized (set) {
            while (!this.threads.isEmpty() && this.le == null && this.se == null) {
                try {
                    this.threads.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.isok();
    }

    private void isok() throws SQLException, LockException {
        if (this.le != null) {
            throw this.le;
        }
        if (this.se != null) {
            throw this.se;
        }
    }

    private void setSQLException(SQLException e) {
        this.se = e;
    }

    private void setLockException(LockException e) {
        this.le = e;
    }

    class StarterThread
    extends WorkerThread {
        private IJob job;

        public StarterThread(IJob job) {
            super(0);
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            try {
                StarterThreads.this.disp.newJob(this.job, true);
            }
            catch (SQLException e) {
                StarterThreads.this.setSQLException(e);
            }
            catch (LockException e) {
                StarterThreads.this.setLockException(e);
            }
            finally {
                Set e = StarterThreads.this.threads;
                synchronized (e) {
                    StarterThreads.this.threads.remove(this);
                    StarterThreads.this.threads.notify();
                }
            }
        }
    }
}

