/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.CtrlDispAppl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WorkerThread
implements Runnable,
Comparable<WorkerThread> {
    protected static Log log = LogFactory.getLog((String)"master.WorkerThread");
    private static final String DEFAULT_NAME = "JMWT-";
    public static final int LOGPROT = 0;
    public static final int SENDFC = 1;
    public static final int SLEEP = 2;
    public static final int REMOVE = 3;
    public static final int TYPE_END = 4;
    private static final int ACTIVE_COUNT = 0;
    private static final int CREATE_COUNT = 1;
    private static long[][] stat = new long[4][2];
    private static long runtime = 0L;
    private static long runtime5 = 0L;
    private static long runtimeEval = 0L;
    private static long runtimeDb = 0L;
    private static long runtimeTcp = 0L;
    private static long runtimeLock = 0L;
    private static long runtimeSeq = 0L;
    private static long runtimeLog = 0L;
    private static long runtimeJsl = 0L;
    private static long runtimeAcc = 0L;
    private static long runtimeSen = 0L;
    private static long runtimeRcb = 0L;
    private static Set<Thread> threads = Collections.synchronizedSet(new HashSet());
    private static long num = 0L;
    private int type;
    private Status status = Status.WAIT;
    private long create = System.currentTimeMillis();
    private long id;
    private String name = "JMWT-";
    private Thread thread = null;
    private Object threadSync = new Object();

    public static String getTypeName(int type) {
        switch (type) {
            case 0: {
                return "LogProt";
            }
            case 1: {
                return "SendFc";
            }
            case 2: {
                return "Sleep";
            }
            case 3: {
                return "Remove";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvalTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeEval += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDbTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeDb += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTcpTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeTcp += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLockTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeLock += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSeqTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeSeq += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeLog += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJslTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeJsl += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAccTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeAcc += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSenTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeSen += ms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRcbTime(long ms) {
        if (threads.contains(Thread.currentThread())) {
            Set<Thread> set = threads;
            synchronized (set) {
                runtimeRcb += ms;
            }
        }
    }

    public static float getPct(long ms) {
        return runtime > 0L ? (float)ms / (float)runtime * 100.0f : 0.0f;
    }

    public static String getStatus() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n\tRuntime: ");
        CtrlDispAppl.appendTimeString(buf, runtime / 1000L);
        buf.append(String.format(" (Eval: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeEval))));
        buf.append(String.format("DB: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeDb))));
        buf.append(String.format("TCP: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeTcp))));
        buf.append(String.format("Lock: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeLock))));
        buf.append(String.format("Seq: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeSeq))));
        buf.append(String.format("Log: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeLog))));
        buf.append(String.format("Jsl: %.2f%%,\n\t\t\t", Float.valueOf(WorkerThread.getPct(runtimeJsl))));
        buf.append(String.format("   Acc: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeAcc))));
        buf.append(String.format("Sen: %.2f%%, ", Float.valueOf(WorkerThread.getPct(runtimeSen))));
        buf.append(String.format("RCB: %.2f%%)\n\t", Float.valueOf(WorkerThread.getPct(runtimeRcb))));
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(WorkerThread.getTypeName(i));
            buf.append(": ");
            buf.append(stat[i][0]);
            buf.append("/");
            buf.append(stat[i][1]);
        }
        return buf.toString();
    }

    public String toString() {
        return "WorkerThread: " + WorkerThread.getStatus();
    }

    public WorkerThread(int type) {
        this(null, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerThread(String name, int type) {
        this.type = type;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.id = ++num;
            long[] lArray = stat[type];
            lArray[1] = lArray[1] + 1L;
            if (name == null) {
                this.name = DEFAULT_NAME + WorkerThread.getTypeName(type) + ":" + this.id;
            } else {
                this.setName(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanStat() {
        Class<WorkerThread> clazz = WorkerThread.class;
        synchronized (WorkerThread.class) {
            for (int x = 0; x < 4; ++x) {
                WorkerThread.stat[x][0] = 0L;
                WorkerThread.stat[x][1] = 0L;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            long[] lArray = stat[this.type];
            lArray[1] = lArray[1] - 1L;
        }
    }

    public void setName(String name) {
        this.name = name;
        Thread.currentThread().setName(name);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return WorkerThread.getTypeName(this.type);
    }

    public boolean isWaiting() {
        return this.status == Status.WAIT;
    }

    public boolean isReady() {
        return this.status == Status.READY;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    @Override
    public int compareTo(WorkerThread wt) {
        if (this.type == wt.type) {
            return this.compareCreate(wt);
        }
        if (this.type < wt.type) {
            return this.type - wt.type - 2;
        }
        return this.type - wt.type + 2;
    }

    private int compareCreate(WorkerThread wt) {
        if (this.create < wt.create) {
            return -2;
        }
        if (this.create > wt.create) {
            return 2;
        }
        if (this.id < wt.id) {
            return -1;
        }
        if (this.id > wt.id) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceElement[] getStackTrace() {
        Object object = this.threadSync;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.getStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.threadSync;
        synchronized (object) {
            this.thread = Thread.currentThread();
        }
        long start = System.currentTimeMillis();
        this.status = Status.RUNNING;
        this.thread.setName(this.name);
        Object object2 = this.getClass();
        synchronized (object2) {
            long[] lArray = stat[this.type];
            lArray[0] = lArray[0] + 1L;
        }
        try {
            threads.add(this.thread);
            this.doRun();
            threads.remove(this.thread);
        }
        catch (Throwable e) {
            try {
                log.error((Object)" Error at running WorkerThread: ", e);
                throw e;
            }
            catch (Throwable throwable) {
                threads.remove(this.thread);
                this.status = Status.READY;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    long[] lArray = stat[this.type];
                    lArray[1] = lArray[1] - 1L;
                    long[] lArray2 = stat[this.type];
                    lArray2[0] = lArray2[0] - 1L;
                }
                this.thread.setName("wait4job");
                clazz = this.getClass();
                synchronized (clazz) {
                    long rt = System.currentTimeMillis() - start;
                    runtime += rt;
                    runtime5 += rt;
                }
                throw throwable;
            }
        }
        this.status = Status.READY;
        object2 = this.getClass();
        synchronized (object2) {
            long[] lArray = stat[this.type];
            lArray[1] = lArray[1] - 1L;
            long[] lArray3 = stat[this.type];
            lArray3[0] = lArray3[0] - 1L;
        }
        this.thread.setName("wait4job");
        object2 = this.getClass();
        synchronized (object2) {
            long rt = System.currentTimeMillis() - start;
            runtime += rt;
            runtime5 += rt;
        }
        object2 = this.threadSync;
        synchronized (object2) {
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readClearRuntime() {
        Class<WorkerThread> clazz = WorkerThread.class;
        synchronized (WorkerThread.class) {
            long rt = runtime5;
            runtime5 = 0L;
            // ** MonitorExit[var2] (shouldn't be in output)
            return rt;
        }
    }

    public abstract void doRun();

    private static enum Status {
        WAIT,
        RUNNING,
        READY;

    }
}

