/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import de.axway.aim.controller.lib.JMasterUtil;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.account.IAccounting;
import de.axway.aim.controller.master.account.JobAccountSums;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.common.api.IDBIPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbAccounting
implements IAccounting {
    private static final String VERSION = "$Id: DbAccounting.java 230561 2017-05-12 08:52:47Z lvcraciun $";
    private static Log log = LogFactory.getLog((String)"master.account.DbAccounting");
    private static final int ACCSTAT_STARTED = 0;
    private static final int ACCSTAT_LOG_END = 1;
    private static final int ACCSTAT_TOTAL_END = 2;
    private static final int ACCSTAT_ERROR = 3;
    private static final int MAX_USER_FIELDS = 16;
    private ILogbook logbook;
    private IDBIPool dbiPool = null;
    private DataSource dataSource = null;
    private String driver;
    private String url;
    private String user;
    private String pass;
    private boolean accOn = false;
    private static final String DB_ACC_INSERT = "insert into CTRL_ACCOUNTING (jobid, date_create, job_status, sender, object_class, receiver, job_name, components, size_sum, component_sizes) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String DB_ACC_UPDATE_LOG_END = "update CTRL_ACCOUNTING set date_log_end=?, job_status=?, job_duration=?, fc_dur_second=?, fc_dur_milli=?, fc_exec_total=?, fc_retry=?, components=?, size_sum=?, component_sizes=? where jobid=?";
    private static final String DB_ACC_UPDATE_END = "update CTRL_ACCOUNTING set date_end=?, job_status=? where jobid=?";

    public DbAccounting(ILogbook logbook, boolean accOn, DataSource dataSource, Ediboss ediboss) {
        log.debug((Object)"DbAccouting.<init>: start");
        this.logbook = logbook;
        this.accOn = accOn;
        this.url = ediboss.getAccountingDbUrl();
        this.driver = ediboss.getAccountingDbDriver();
        this.user = ediboss.getAccountingDbUser();
        this.pass = ediboss.getAccountingDbPass();
        if (this.url == null || this.driver == null || this.user == null || this.pass == null || this.url.length() == 0 || this.driver.length() == 0 || this.user.length() == 0 || this.pass.length() == 0) {
            log.debug((Object)"Use Master's DataSource for Accounting.");
            this.dataSource = dataSource;
            this.dbiPool = null;
        } else if (accOn) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create DataSource for Accounting:" + this.getJDBCParam()));
            }
            try {
                this.dbiPool = JMasterUtil.createDbiPool((String)this.driver, (String)this.url, (String)this.user, (String)this.pass, (int)(ediboss.getThreadPool() + ediboss.getRemoveThreadPool() + 10));
                this.dataSource = this.dbiPool.getDataSource();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created DataSource: " + dataSource));
                }
            }
            catch (Throwable e) {
                this.accOn = false;
                this.errorMsg2("Cannot open Accounting Database", e);
            }
        }
    }

    private void errorMsg2(String msg) {
        this.errorMsg2(msg, null);
    }

    private void errorMsg2(String msg, Throwable t) {
        if (t == null) {
            this.logbook.error(msg + "!");
            log.error((Object)(msg + "!"));
        } else {
            this.logbook.error(msg + "!, " + t);
            log.error((Object)(msg + ":"), t);
        }
    }

    private static String buildUserDataUpdCmdString(String[] accUserFields) {
        int cnt = 0;
        StringBuilder sb = new StringBuilder();
        if (accUserFields == null || accUserFields.length == 0) {
            return null;
        }
        sb.append("update CTRL_ACCOUNTING set ");
        for (int i = 0; i < accUserFields.length; ++i) {
            if (accUserFields[i] == null) continue;
            if (cnt > 0) {
                sb.append(", ");
            }
            ++cnt;
            sb.append("USER_DEF_ACC" + (i + 1) + "=?");
        }
        if (cnt == 0) {
            return null;
        }
        sb.append(" where JOBID=?");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateUserData(Connection con, CtrlJob job) throws SQLException, CfgException {
        String[] accUserData = null;
        boolean okFlag = false;
        DebPrepStmt updateUData = null;
        String udCmdStr = null;
        accUserData = ((CfgJSelectEntry)job.getJsl()).getAccUsrCol();
        udCmdStr = DbAccounting.buildUserDataUpdCmdString(accUserData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("user data update command: " + udCmdStr));
        }
        try {
            if (udCmdStr != null) {
                int pos = 1;
                updateUData = new DebPrepStmt(con, udCmdStr, log);
                for (int i = 0; i < accUserData.length; ++i) {
                    if (accUserData[i] == null) continue;
                    String val = job.evalPar(accUserData[i], false, true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("user data[" + i + "]=" + accUserData[i] + "/" + val));
                    }
                    updateUData.setString(pos, val);
                    ++pos;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set jobId as parameter " + pos + " in update stmt."));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("accounting user data update done: " + updateUData));
                }
                updateUData.setLong(pos, job.getId());
                if (updateUData.executeUpdate() == 1) {
                    okFlag = true;
                } else {
                    this.errorMsg2("Adding Accoounting User Data to records did return RC: 1");
                }
            } else {
                okFlag = true;
            }
        }
        finally {
            if (updateUData != null) {
                try {
                    updateUData.close();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot close update User Data statement", e);
                }
            }
        }
        return okFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeBegin(CtrlJob job, Connection masterCon) {
        boolean okFlag = false;
        JobAccountSums jas = null;
        DebPrepStmt insert = null;
        Connection con = null;
        log.debug((Object)"writeBegin: start");
        if (!this.accOn) {
            log.debug((Object)"writeBegin: end (noop)");
            return true;
        }
        try {
            jas = job.getJobAccounting(masterCon);
        }
        catch (Exception e) {
            this.errorMsg2("Cannot access Job Accounting Sums", e);
        }
        if (jas == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("writeBegin: end rc: " + okFlag));
            }
            return okFlag;
        }
        try {
            con = this.dataSource.getConnection();
            insert = new DebPrepStmt(con, DB_ACC_INSERT, log);
            insert.setLong(1, job.getId());
            insert.setTimestamp(2, new Timestamp(new Date().getTime()));
            insert.setInt(3, 0);
            insert.setString(4, JMasterUtil.null2Empty((String)job.getEvt().getAttr("SENDER")));
            insert.setString(5, JMasterUtil.null2Empty((String)job.getEvt().getAttr("OBJ_CLASS")));
            insert.setString(6, JMasterUtil.null2Empty((String)job.getEvt().getAttr("RECEIVER")));
            insert.setString(7, job.getName());
            insert.setInt(8, jas.getNoOfComps());
            insert.setLong(9, jas.getTotalCompSize());
            insert.setString(10, jas.getCompsSizesStr());
            if (log.isTraceEnabled()) {
                log.trace((Object)("accounting insert command: " + insert));
            }
            if (insert.executeUpdate() == 1) {
                if (this.updateUserData(con, job)) {
                    okFlag = true;
                }
            } else {
                this.errorMsg2("Insert accouning records did return RC: 1!");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("insert: " + insert));
            }
            this.errorMsg2("Cannot insert accounting record into DB", e);
            okFlag = false;
        }
        finally {
            if (okFlag) {
                try {
                    con.commit();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot commit failed accounting log transaction", e);
                    okFlag = false;
                }
            } else if (con != null) {
                try {
                    con.rollback();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot rollback failed accounting log transaction", e);
                }
            }
            if (insert != null) {
                try {
                    insert.close();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot close insert Accounting Data statement", e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot close connection", e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeBegin: end rc: " + okFlag));
        }
        return okFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeLogicalEnd(CtrlJob job, Connection masterCon) {
        boolean okFlag = false;
        JobAccountSums jas = null;
        DebPrepStmt update = null;
        Connection con = null;
        long now = 0L;
        log.debug((Object)"writeLogicalEnd: start");
        if (!this.accOn) {
            log.debug((Object)"writeLogicalEnd: end (noop)");
            return true;
        }
        try {
            jas = job.getJobAccounting(masterCon);
        }
        catch (Exception e) {
            this.errorMsg2("Cannot access Job Accounting Sums", e);
        }
        if (jas == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("writeLogicalEnd: end rc: " + okFlag));
            }
            return okFlag;
        }
        try {
            long fcTime = 0L;
            con = this.dataSource.getConnection();
            update = new DebPrepStmt(con, DB_ACC_UPDATE_LOG_END, log);
            update.setTimestamp(1, new Timestamp(new Date().getTime()));
            update.setInt(2, 1);
            now = new Date().getTime();
            log.debug((Object)("job: " + job.getId() + " creationDate: " + job.getCreationDate()));
            update.setLong(3, (now - job.getCreationDate()) / 1000L);
            update.setLong(4, jas.getFcTime() / 1000L);
            update.setLong(5, jas.getFcTime() - jas.getFcTime() / 1000L * 1000L);
            update.setInt(6, jas.getFcCount());
            update.setInt(7, jas.getFailedFcCount());
            update.setInt(8, jas.getNoOfComps());
            update.setLong(9, jas.getTotalCompSize());
            update.setString(10, jas.getCompsSizesStr());
            update.setLong(11, job.getId());
            if (log.isTraceEnabled()) {
                log.trace((Object)("accounting updatet command: " + update));
            }
            if (update.executeUpdate() == 1) {
                if (this.updateUserData(con, job)) {
                    okFlag = true;
                }
            } else {
                this.errorMsg2("Update accouning record did return RC: 1!");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("update: " + update));
            }
            this.errorMsg2("Cannot update accounting record intDB", e);
            okFlag = false;
        }
        finally {
            if (okFlag) {
                try {
                    con.commit();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot commit failed accounting log transaction", e);
                    okFlag = false;
                }
            } else if (con != null) {
                try {
                    con.rollback();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot rollback failed accounting log transaction", e);
                }
            }
            if (update != null) {
                try {
                    update.close();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot close insert Accounting Data statement", e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot close connection", e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeLogicalEnd: end rc: " + okFlag));
        }
        return okFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeEnd(CtrlJob job, Connection masterCon) {
        Connection con = null;
        boolean okFlag = false;
        DebPrepStmt update = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"writeEnd: start");
        }
        if (!this.accOn) {
            log.debug((Object)"writeEnd: end (noop)");
            return true;
        }
        try {
            if (job.getStatus() != 4) {
                this.writeLogicalEnd(job, masterCon);
            }
            con = this.dataSource.getConnection();
            update = new DebPrepStmt(con, DB_ACC_UPDATE_END, log);
            update.setTimestamp(1, new Timestamp(new Date().getTime()));
            if (job.getStatus() == 4) {
                update.setInt(2, 2);
            } else {
                update.setInt(2, 3);
            }
            update.setLong(3, job.getId());
            if (update.executeUpdate() == 1) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("update done: " + update));
                }
                okFlag = true;
            } else {
                this.errorMsg2("Update accouning records did return RC: 1!");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("update: " + update));
            }
            this.errorMsg2("Cannot update accounting record in DB", e);
            okFlag = false;
        }
        finally {
            if (okFlag) {
                try {
                    con.commit();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot commit failed accounting log transaction", e);
                    okFlag = false;
                }
            } else if (con != null) {
                try {
                    con.rollback();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot rollback failed accounting log transaction", e);
                }
            }
            if (update != null) {
                try {
                    update.close();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot close update User Data statement", e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    this.errorMsg2("Cannot close connection", e);
                }
            }
        }
        return okFlag;
    }

    @Override
    public void close() {
        log.debug((Object)"close: start");
        if (this.dbiPool != null) {
            try {
                this.dbiPool.close();
                this.dbiPool = null;
                this.dataSource = null;
                this.accOn = false;
            }
            catch (Exception e) {
                this.errorMsg2("Cannot close Accounting Database pool", e);
            }
        } else {
            this.dataSource = null;
            this.accOn = false;
        }
        log.debug((Object)"close: end");
    }

    @Override
    public boolean isActive() {
        return this.accOn;
    }

    private String getJDBCParam() {
        return this.driver + "/" + this.url + "/" + this.user + "/****";
    }

    @Override
    public String getCurrAccFilename() {
        if (this.dbiPool == null) {
            return "" + this.dataSource;
        }
        return this.getJDBCParam();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DbAccounting: ");
        sb.append("accOn: ");
        sb.append(this.accOn);
        sb.append(", dataSource; ");
        sb.append(this.dataSource);
        sb.append(", driver: ");
        sb.append(this.driver);
        sb.append(", url: ");
        sb.append(this.url);
        sb.append(", user: ");
        sb.append(this.user);
        return sb.toString();
    }
}

