/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import de.axway.aim.controller.master.account.RcbRecord;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RcbErrRec
extends RcbRecord {
    private static final String VERSION = "$Header$";
    private static Log log = LogFactory.getLog((String)"master.account.RcbErrRec");
    public static final char TYPE_ERR = 'E';
    private String send;
    private String recv;
    private String errClass;
    private int errCnt;
    private int contErrCnt;
    private String jsName;
    private long jobId;
    private int rc;
    private String lastFailTime;
    private String lastOkTime;
    private String lastErrLog;

    public RcbErrRec(String send, String recv, String errClass) {
        super('E');
        this.send = send;
        this.recv = recv;
        this.errClass = errClass;
        this.errCnt = 0;
        this.contErrCnt = 0;
        this.jsName = "";
        this.jobId = 0L;
        this.rc = 0;
        this.lastFailTime = "";
        this.lastOkTime = "";
        this.lastErrLog = "";
    }

    public RcbErrRec(byte[] data) {
        this(String.valueOf(data));
    }

    public RcbErrRec(String data) {
        super('E');
        String[] token = data.split("\\|");
        if (log.isDebugEnabled()) {
            for (int i = 0; i < token.length; ++i) {
                log.debug((Object)("RCB error record token " + i + " = '" + token[i] + "'"));
            }
        }
        this.send = token[1];
        this.recv = token[2];
        this.errClass = token[3];
        this.errCnt = Integer.valueOf(token[4]);
        this.contErrCnt = Integer.valueOf(token[5]);
        this.jsName = token[6];
        this.jobId = Long.valueOf(token[7]);
        this.rc = Integer.valueOf(token[8]);
        this.lastFailTime = token[9];
        this.lastOkTime = token[10];
        this.lastErrLog = token[11];
    }

    public static RcbErrRec createFromString(String str) {
        if (str != null && str.length() > 0 && str.charAt(0) == 'E') {
            return new RcbErrRec(str);
        }
        return null;
    }

    @Override
    public String getHashVal() {
        return RcbErrRec.buildHashVal(this.send, this.recv, this.errClass);
    }

    public static String buildHashVal(String send, String recv, String errClass) {
        return "E|" + send + "|" + recv + "|" + errClass + "|";
    }

    @Override
    public String getData() {
        return this.getHashVal() + this.errCnt + "|" + this.contErrCnt + "|" + this.jsName + "|" + this.jobId + "|" + this.rc + "|" + this.lastFailTime + "|" + this.lastOkTime + "|" + this.lastErrLog + "|";
    }

    public void incrErrCnt() {
        ++this.errCnt;
    }

    public void incrContErrCnt() {
        ++this.contErrCnt;
    }

    public void resetContErrCnt() {
        this.contErrCnt = 0;
    }

    public void setJsName(String jsName) {
        this.jsName = jsName;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public void setRc(int rc) {
        this.rc = rc;
    }

    public void setLastOkTime(String timeStr) {
        this.lastOkTime = timeStr;
    }

    public void setLastOkTime(Date time) {
        this.lastOkTime = DATE_FORMAT.format(time);
    }

    public void setLastOkTime(long time) {
        this.lastOkTime = DATE_FORMAT.format(new Date(time));
    }

    public void setLastFailTime(String timeStr) {
        this.lastFailTime = timeStr;
    }

    public void setLastFailTime(long time) {
        this.lastFailTime = DATE_FORMAT.format(new Date(time));
    }

    public void setLastFailTime(Date time) {
        this.lastFailTime = DATE_FORMAT.format(time);
    }

    public void setLastErrLog(String logfileName) {
        this.lastErrLog = logfileName;
    }
}

