/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import de.axway.aim.controller.master.account.RcbRecord;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RcbStatRec
extends RcbRecord {
    private static final String VERSION = "$Header$";
    private static Log log = LogFactory.getLog((String)"master.account.RcbStatRec");
    public static final char TYPE_STAT = 'S';
    private String send;
    private String recv;
    private int cntJobs;
    private int cntFailed;
    private String jobCreateTime;

    public RcbStatRec(String send, String recv) {
        this(send, recv, null);
    }

    public RcbStatRec(String send, String recv, Date date) {
        super('S');
        this.send = send;
        this.recv = recv;
        this.cntJobs = 0;
        this.cntFailed = 0;
        this.jobCreateTime = date != null ? DATE_FORMAT.format(date) : "";
    }

    public RcbStatRec(byte[] data) {
        this(String.valueOf(data));
    }

    public RcbStatRec(String data) {
        super('S');
        String[] token = data.split("\\|");
        if (log.isDebugEnabled()) {
            for (int i = 0; i < token.length; ++i) {
                log.debug((Object)("RCB status record token " + i + " = '" + token[i] + "'"));
            }
        }
        this.send = token[1];
        this.recv = token[2];
        this.cntJobs = Integer.valueOf(token[3]);
        this.jobCreateTime = token[4];
        this.cntFailed = Integer.valueOf(token[5]);
    }

    public static RcbStatRec createFromString(String str) {
        if (str != null && str.length() > 0 && str.charAt(0) == 'S') {
            return new RcbStatRec(str);
        }
        return null;
    }

    @Override
    public String getHashVal() {
        return RcbStatRec.buildHashVal(this.send, this.recv);
    }

    public static String buildHashVal(String send, String recv) {
        return "S|" + send + "|" + recv + "|";
    }

    @Override
    public String getData() {
        return this.getHashVal() + this.cntJobs + "|" + this.jobCreateTime + "|" + this.cntFailed + "|";
    }

    public void incrJobs() {
        ++this.cntJobs;
    }

    public void incrFailed() {
        ++this.cntFailed;
    }

    public void setJobCreateTime(String timeStr) {
        this.jobCreateTime = timeStr;
    }

    public void setJobCreateTime(Date time) {
        this.jobCreateTime = DATE_FORMAT.format(time);
    }
}

