/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.account.TsimSentinelClient;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.aim.controller.master.cfg.CfgFctnRcReaction;
import de.axway.aim.controller.master.cfg.TextTrkApiPar;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.common.sentinelrouter.api.ISentinelClient;
import de.axway.common.sentinelrouter.api.ITrkMessageUAEvent;
import de.axway.common.sentinelrouter.api.ITrkMessageUALink;
import de.axway.common.sentinelrouter.utils.JndiSentinelClient;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tsim2Sentinel {
    private static Log log = LogFactory.getLog((String)"master.account.Tsim2Sentinel");
    private static final int CMD_LINE_LEN = 256;
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat DATE_FORMAT_SHORT = new SimpleDateFormat("yyMMddHHmmss");
    private static final String EXT_TRKOBJ_VAR = "$(EXT_TO)";
    private static final String EXT_CYCLEID_VAR = "$(EXT_CYCLE_ID)";
    private static final String QUOTED_EMPTY = "\"\"";
    public static final String TRACE_CATEGORY_WORKFLOW = "Workflow";
    public static final String TRACE_CATEGORY_EDIOBJECT = "Ediobject";
    private static ISentinelClient sentinelClient = null;
    private static String wfToName = null;
    private static String boToName = null;
    private static String productName = null;
    private ILogbook logbook = null;
    private int trkThrowEx = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Tsim2Sentinel(ILogbook logbook, String trkApiParName) {
        TextTrkApiPar trkApiPar = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tsim2Sentinel.init start: trkApiParName: " + trkApiParName));
        }
        this.logbook = logbook;
        if (trkApiParName != null && trkApiParName.length() > 0) {
            block14: {
                Class<Tsim2Sentinel> clazz = Tsim2Sentinel.class;
                // MONITORENTER : de.axway.aim.controller.master.account.Tsim2Sentinel.class
                if (sentinelClient != null) {
                    log.error((Object)"Tsim2Sentinel already initialized.");
                } else {
                    try {
                        try {
                            trkApiPar = new TextTrkApiPar(trkApiParName);
                            productName = trkApiPar.getTrkProductName();
                            this.trkThrowEx = trkApiPar.getTrkThrowEx();
                        }
                        catch (Exception e) {
                            trkApiPar = null;
                            Exception ex = new Exception("Cannot open Sentinel parameters file '" + trkApiParName + "', Reason: " + e);
                            throw ex;
                        }
                        if ("de.axway.aim.controller.master.account.TsimSentinelClient".equals(trkApiPar.getJavaSentinelClient())) {
                            trkApiPar.checkContent();
                            wfToName = trkApiPar.getWfTrackedObj();
                            boToName = trkApiPar.getEoTrackedObj();
                            if (wfToName != null && wfToName.length() > 0) {
                                sentinelClient = new TsimSentinelClient(trkApiPar);
                            }
                            break block14;
                        }
                        if (!"de.axway.common.sentinelrouter.utils.JndiSentinelClient".equals(trkApiPar.getJavaSentinelClient())) {
                            Exception ex = new Exception("Cannot instantiate sentinel client: " + trkApiPar.getJavaSentinelClient());
                            throw ex;
                        }
                        sentinelClient = new JndiSentinelClient(productName);
                        wfToName = sentinelClient.getTrackedObject(sentinelClient.createNewTrkMessageEvent(TRACE_CATEGORY_WORKFLOW));
                        boToName = sentinelClient.getTrackedObject(sentinelClient.createNewTrkMessageEvent(TRACE_CATEGORY_EDIOBJECT));
                        if (wfToName == null || wfToName.length() == 0) {
                            sentinelClient = null;
                        }
                    }
                    catch (Throwable e) {
                        sentinelClient = null;
                        logbook.error("Tsim2Sentinel initialization error: " + e.toString());
                        log.error((Object)e.toString(), e.getCause());
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)("Tsim2Sentinel.init end: active:" + Tsim2Sentinel.initialized()));
    }

    public static String getWfCycleId(CtrlJob job) {
        Date jobCreateDate = new Date(job.getCreationDate());
        return String.format("TSIM_WF%s%012d", DATE_FORMAT_SHORT.format(jobCreateDate), job.getId());
    }

    public static String getBoCycleId(CtrlJob job) {
        Date jobCreateDate = new Date(job.getCreationDate());
        return String.format("TSIM_BO%s%012d", DATE_FORMAT_SHORT.format(jobCreateDate), job.getId());
    }

    public static String getWfToName() {
        return wfToName;
    }

    public static String getBoToName() {
        return boToName;
    }

    private void setTrkParams(ITrkMessageUAEvent jobEvent, CtrlJob job) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTrkparams: start: jobId: " + job.getId()));
        }
        if (jobEvent != null && job != null) {
            Enumeration<String> paramNames = job.getVarKeys();
            while (paramNames.hasMoreElements()) {
                String name = paramNames.nextElement();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("setTrkparams: found param: '" + name + "'"));
                }
                if (!name.toUpperCase().startsWith("TRK")) continue;
                String value = (String)job.getVar(name).get();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("setTrkparams: add param: '" + name + "' = '" + value + "'"));
                }
                if (value == null) {
                    jobEvent.setAttribute(name, "");
                    continue;
                }
                jobEvent.setAttribute(name, value);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTrkparams: end: jobId: " + job.getId()));
        }
    }

    private String getStateString(CtrlJob job) {
        if (job.isSuspended()) {
            return "SUSPENDED";
        }
        switch (job.getStatus()) {
            case 1: 
            case 5: {
                return "ACTIVE";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "RETRY";
            }
            case 4: {
                return "OK";
            }
            case 6: {
                return "STOPPED";
            }
        }
        return "unknown";
    }

    public boolean sendJobStartMsg(CtrlJob job) {
        boolean result;
        block12: {
            ITrkMessageUAEvent jobEvent = null;
            ITrkMessageUALink jobLink = null;
            String cycleId = null;
            String extTo = null;
            String extCycleId = null;
            int rc = -1;
            CtrlEvent event = null;
            result = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendJobStartMsg start: job: " + job.getId()));
            }
            if (!Tsim2Sentinel.initialized()) {
                log.debug((Object)"sendJobStartMsg end: no message sent");
                return result;
            }
            try {
                event = (CtrlEvent)job.getEvt();
                jobEvent = sentinelClient.createNewTrkMessageEvent(TRACE_CATEGORY_WORKFLOW);
                cycleId = Tsim2Sentinel.getWfCycleId(job);
                jobEvent.setAttribute("CycleId", cycleId);
                jobEvent.setAttribute("State", "INITIATED");
                jobEvent.setAttribute("UserObjectId", cycleId + "_");
                jobEvent.setAttribute("Job_id", String.valueOf(job.getId()));
                jobEvent.setAttribute("Sequence_no", "0");
                jobEvent.setAttribute("Function_class_name", "Workflow " + job.getId());
                jobEvent.setAttribute("Jobstep_status", "Initiate");
                jobEvent.setAttribute("Job_name", job.getName());
                jobEvent.setAttribute("SENDER", event.getAttr("SENDER"));
                jobEvent.setAttribute("RECEIVER", event.getAttr("RECEIVER"));
                jobEvent.setAttribute("OBJCLASS", event.getAttr("OBJ_CLASS"));
                this.setTrkParams(jobEvent, job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jobEvent: " + jobEvent));
                }
                rc = sentinelClient.sendMessage(jobEvent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("trkapiua.sendMessage(jobEvent) RC: " + rc));
                }
                extTo = job.evalPar(EXT_TRKOBJ_VAR, false, false);
                extCycleId = job.evalPar(EXT_CYCLEID_VAR, false, false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("$(EXT_TO): '" + extTo + "', " + EXT_CYCLEID_VAR + ": '" + extCycleId + "'"));
                }
                if (rc == 0 && extTo != null && extTo.length() > 0 && !extTo.equals(QUOTED_EMPTY) && extCycleId != null && extCycleId.length() > 0 && !extCycleId.equals(QUOTED_EMPTY)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Create and send link message for: " + wfToName + "/" + cycleId + " -> " + extTo + "/" + extCycleId));
                    }
                    jobLink = sentinelClient.createNewTrkMessageLink(extTo, extCycleId, Tsim2Sentinel.getWfToName(), cycleId);
                    rc = sentinelClient.sendMessage(jobLink);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("trkapiua.sendMessage(jobLink) RC: " + rc));
                    }
                }
            }
            catch (Exception e) {
                this.logbook.error("Tsim2Sentinel.sendJobStartMsg error: " + e.toString());
                log.error((Object)"sendJobStartMsg failed:", (Throwable)e);
                result = false;
            }
            catch (Throwable e) {
                this.logbook.error("Tsim2Sentinel.sendJobStartMsg error: " + e.toString());
                log.error((Object)"FATAL: sendJobStartMsg failed:", e);
                result = false;
                if (this.trkThrowEx == 0) break block12;
                throw e;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendJobStartMsg end:");
        }
        return result;
    }

    public boolean sendJobStepStartMsg(CtrlJobStep step) {
        boolean result;
        block12: {
            result = true;
            String cycleId = null;
            int rc = -1;
            ITrkMessageUAEvent jobEvent = null;
            CtrlJob job = null;
            CtrlEvent event = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendJobStepStartMsg start: step: " + (Object)((Object)step)));
            }
            if (!Tsim2Sentinel.initialized()) {
                log.debug((Object)"sendJobStepStartMsg end: no message sent");
                return result;
            }
            try {
                job = step.getJob();
                CfgFctnEntry cfgFctn = step.getFctnEntry();
                event = (CtrlEvent)job.getEvt();
                jobEvent = sentinelClient.createNewTrkMessageEvent(TRACE_CATEGORY_WORKFLOW);
                cycleId = Tsim2Sentinel.getWfCycleId(job);
                jobEvent.setAttribute("CycleId", cycleId);
                jobEvent.setAttribute("State", this.getStateString(job));
                jobEvent.setAttribute("UserObjectId", cycleId + "_" + step.getStepNo());
                if (step.getStepNo() == 1) {
                    jobEvent.setAttribute("UserParentId", cycleId + "_");
                } else {
                    jobEvent.setAttribute("UserParentId", cycleId + "_" + (step.getStepNo() - 1));
                }
                jobEvent.setAttribute("Job_id", String.valueOf(job.getId()));
                jobEvent.setAttribute("Sequence_no", String.valueOf(step.getStepNo()));
                jobEvent.setAttribute("Function_class_name", step.getName());
                jobEvent.setAttribute("Jobstep_status", "READY");
                jobEvent.setAttribute("Job_name", job.getName());
                jobEvent.setAttribute("FC_instance", "1." + cfgFctn.getSeqCount() + "/1." + cfgFctn.getMaxSeqRetry(1));
                jobEvent.setAttribute("Retry_counter", "1");
                jobEvent.setAttribute("Max_retry", String.valueOf(step.getMaxRetry()));
                if (cfgFctn.getCmdLine(1).length() > 256) {
                    jobEvent.setAttribute("Current_FCall", cfgFctn.getCmdLine(1).substring(0, 253) + "...");
                } else {
                    jobEvent.setAttribute("Current_FCall", cfgFctn.getCmdLine(1));
                }
                jobEvent.setAttribute("JS_START_TIME", DATE_FORMAT.format(new Date(step.getNextExecTime())));
                jobEvent.setAttribute("JS_END_TIME", "");
                jobEvent.setAttribute("Exit_Code", "");
                jobEvent.setAttribute("SENDER", event.getAttr("SENDER"));
                jobEvent.setAttribute("RECEIVER", event.getAttr("RECEIVER"));
                jobEvent.setAttribute("OBJCLASS", event.getAttr("OBJ_CLASS"));
                this.setTrkParams(jobEvent, job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jobEvent: " + jobEvent));
                }
                rc = sentinelClient.sendMessage(jobEvent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("trkapiua.sendMessage(jobEvent) RC: " + rc));
                }
            }
            catch (Exception e) {
                this.logbook.error("Tsim2Sentinel.sendJobStepStartMsg error: " + e.toString());
                log.error((Object)"sendJobStepJobStartMsg failed:", (Throwable)e);
                result = false;
            }
            catch (Throwable e) {
                this.logbook.error("Tsim2Sentinel.sendJobStepStartMsg error: " + e.toString());
                log.error((Object)"FATAL: sendJobStepJobStartMsg failed:", e);
                result = false;
                if (this.trkThrowEx == 0) break block12;
                throw e;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendJobStepStartMsg end:");
        }
        return result;
    }

    public boolean sendFcStartMsg(CtrlFunctionCall fc) {
        boolean result;
        block14: {
            String cycleId = null;
            int rc = -1;
            ITrkMessageUAEvent jobEvent = null;
            result = true;
            CtrlJob job = null;
            CtrlJobStep step = null;
            CtrlEvent event = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendFcStartMsg start: FC: " + (Object)((Object)fc)));
            }
            if (!Tsim2Sentinel.initialized()) {
                log.debug((Object)"sendFcStartMsg end: no message sent");
                return result;
            }
            try {
                job = (CtrlJob)fc.getJob();
                step = (CtrlJobStep)fc.getJobStep();
                event = (CtrlEvent)job.getEvt();
                jobEvent = sentinelClient.createNewTrkMessageEvent(TRACE_CATEGORY_WORKFLOW);
                cycleId = Tsim2Sentinel.getWfCycleId(job);
                jobEvent.setAttribute("CycleId", cycleId);
                jobEvent.setAttribute("State", this.getStateString(job));
                jobEvent.setAttribute("UserObjectId", cycleId + "_" + step.getStepNo());
                if (step.getStepNo() == 1) {
                    jobEvent.setAttribute("UserParentId", cycleId + "_");
                } else {
                    jobEvent.setAttribute("UserParentId", cycleId + "_" + (step.getStepNo() - 1));
                }
                jobEvent.setAttribute("Job_id", String.valueOf(job.getId()));
                jobEvent.setAttribute("Sequence_no", String.valueOf(step.getStepNo()));
                jobEvent.setAttribute("Function_class_name", fc.getStepName());
                jobEvent.setAttribute("Jobstep_status", "ACTIVE");
                jobEvent.setAttribute("Job_name", job.getName());
                jobEvent.setAttribute("FC_instance", fc.getFcInstance());
                jobEvent.setAttribute("Retry_counter", step.getRetry());
                jobEvent.setAttribute("Max_retry", String.valueOf(step.getMaxRetry()));
                if (fc.getReal().length() > 256) {
                    jobEvent.setAttribute("Current_FCall", fc.getReal().substring(0, 253) + "...");
                } else {
                    jobEvent.setAttribute("Current_FCall", fc.getReal());
                }
                if (step.getRetry() == 1) {
                    jobEvent.setAttribute("JS_START_TIME", DATE_FORMAT.format(new Date(fc.getCreationDate())));
                } else {
                    jobEvent.setAttribute("JS_START_TIME", DATE_FORMAT.format(new Date(fc.getCreationDate())) + "*");
                }
                jobEvent.setAttribute("JS_END_TIME", "");
                jobEvent.setAttribute("Exit_Code", "");
                jobEvent.setAttribute("SENDER", event.getAttr("SENDER"));
                jobEvent.setAttribute("RECEIVER", event.getAttr("RECEIVER"));
                jobEvent.setAttribute("OBJCLASS", event.getAttr("OBJ_CLASS"));
                this.setTrkParams(jobEvent, job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jobEvent: " + jobEvent));
                }
                rc = sentinelClient.sendMessage(jobEvent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("trkapiua.sendMessage(jobEvent) RC: " + rc));
                }
            }
            catch (Exception e) {
                this.logbook.error("Tsim2Sentinel.sendFcStartMsg error: " + e.toString());
                log.error((Object)"sendFcStartMsg failed:", (Throwable)e);
                result = false;
            }
            catch (Throwable e) {
                this.logbook.error("Tsim2Sentinel.sendFcStartMsg error: " + e.toString());
                log.error((Object)"FATAL: sendFcStartMsg failed:", e);
                result = false;
                if (this.trkThrowEx == 0) break block14;
                throw e;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendFcStartMsg end:");
        }
        return result;
    }

    public boolean sendFcEndMsg(CtrlFunctionCall fc) {
        boolean result;
        block19: {
            result = true;
            String cycleId = null;
            int rc = -1;
            ITrkMessageUAEvent jobEvent = null;
            CtrlJob job = null;
            CtrlJobStep step = null;
            CtrlEvent event = null;
            CfgFctnRcReaction rcr = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendFcEndMsg start: FC: " + (Object)((Object)fc)));
            }
            if (!Tsim2Sentinel.initialized()) {
                log.debug((Object)"sendFcEndMsg end: no message sent");
                return result;
            }
            try {
                job = (CtrlJob)fc.getJob();
                step = (CtrlJobStep)fc.getJobStep();
                rcr = step.getLastRc();
                event = (CtrlEvent)job.getEvt();
                jobEvent = sentinelClient.createNewTrkMessageEvent(TRACE_CATEGORY_WORKFLOW);
                cycleId = Tsim2Sentinel.getWfCycleId(job);
                jobEvent.setAttribute("CycleId", cycleId);
                jobEvent.setAttribute("State", this.getStateString(job));
                jobEvent.setAttribute("UserObjectId", cycleId + "_" + step.getStepNo());
                if (step.getStepNo() == 1) {
                    jobEvent.setAttribute("UserParentId", cycleId + "_");
                } else {
                    jobEvent.setAttribute("UserParentId", cycleId + "_" + (step.getStepNo() - 1));
                }
                jobEvent.setAttribute("Job_id", String.valueOf(job.getId()));
                jobEvent.setAttribute("Sequence_no", String.valueOf(step.getStepNo()));
                jobEvent.setAttribute("Function_class_name", fc.getStepName());
                if (rcr.getAction() == CfgFctnRcReaction.Action.RETURN) {
                    jobEvent.setAttribute("JS_END_TIME", DATE_FORMAT.format(new Date(fc.getReadyDate())));
                    jobEvent.setAttribute("Jobstep_status", "OK");
                    if (job.getStatus() == 4) {
                        jobEvent.setAttribute("isEnd", "1");
                    }
                } else if (job.getStatus() == 2) {
                    jobEvent.setAttribute("Jobstep_status", "ERROR");
                    jobEvent.setAttribute("isAlert", "1");
                    jobEvent.setAttribute("isException", "1");
                } else {
                    jobEvent.setAttribute("Jobstep_status", "RETRY");
                    jobEvent.setAttribute("isException", "1");
                }
                jobEvent.setAttribute("Job_name", job.getName());
                jobEvent.setAttribute("FC_instance", fc.getFcInstance());
                jobEvent.setAttribute("Retry_counter", step.getRetry());
                jobEvent.setAttribute("Max_retry", String.valueOf(step.getMaxRetry()));
                if (fc.getReal().length() > 256) {
                    jobEvent.setAttribute("Current_FCall", fc.getReal().substring(0, 253) + "...");
                } else {
                    jobEvent.setAttribute("Current_FCall", fc.getReal());
                }
                if (step.getRetry() == 1) {
                    jobEvent.setAttribute("JS_START_TIME", DATE_FORMAT.format(new Date(fc.getCreationDate())));
                } else {
                    jobEvent.setAttribute("JS_START_TIME", DATE_FORMAT.format(new Date(fc.getCreationDate())) + "*");
                }
                jobEvent.setAttribute("Exit_Code", String.valueOf(fc.getRc()));
                jobEvent.setAttribute("SENDER", event.getAttr("SENDER"));
                jobEvent.setAttribute("RECEIVER", event.getAttr("RECEIVER"));
                jobEvent.setAttribute("OBJCLASS", event.getAttr("OBJ_CLASS"));
                this.setTrkParams(jobEvent, job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jobEvent: " + jobEvent));
                }
                rc = sentinelClient.sendMessage(jobEvent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("trkapiua.sendMessage(jobEvent) RC: " + rc));
                }
            }
            catch (Exception e) {
                this.logbook.error("Tsim2Sentinel.sendFcEndMsg error: " + e.toString());
                log.error((Object)"sendFcEndtMsg failed:", (Throwable)e);
                result = false;
            }
            catch (Throwable e) {
                this.logbook.error("Tsim2Sentinel.sendFcEndMsg error: " + e.toString());
                log.error((Object)"FATAL: sendFcEndtMsg failed:", e);
                result = false;
                if (this.trkThrowEx == 0) break block19;
                throw e;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendFcEndMsg end:");
        }
        return result;
    }

    public void close() {
        if (sentinelClient != null) {
            if (sentinelClient.isActive()) {
                sentinelClient.stop();
            }
            sentinelClient = null;
        }
    }

    public static boolean initialized() {
        return sentinelClient != null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Tsim2Sentinel: TsimSentinelClient: ");
        buf.append(sentinelClient);
        return buf.toString();
    }
}

