/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import com.axway.trkapiua.TrkApiUA;
import com.axway.trkapiua.TrkMessageUA;
import com.axway.trkapiua.TrkMessageUAEvent;
import com.axway.trkapiua.TrkMessageUALink;
import de.axway.aim.controller.master.account.TsimTrkMessageUAEvent;
import de.axway.aim.controller.master.account.TsimTrkMessageUALink;
import de.axway.aim.controller.master.cfg.TextTrkApiPar;
import de.axway.common.sentinelrouter.api.ISentinelClient;
import de.axway.common.sentinelrouter.api.ITrkMessageUAEvent;
import de.axway.common.sentinelrouter.api.ITrkMessageUALink;
import de.axway.common.sentinelrouter.api.SentinelRouterException;
import de.axway.lib.util.ActisFile;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TsimSentinelClient
implements ISentinelClient {
    private static Log log = LogFactory.getLog((String)"master.account.TSIMSentinelClient");
    private TextTrkApiPar trkApiPar = null;
    private boolean trkApiActive = false;
    private TrkApiUA trkApiUa = null;
    private Map<String, String> categoryToTrackedObject = new Hashtable<String, String>();

    public ITrkMessageUAEvent createNewTrkMessageEvent(String traceCategory) {
        String trackedObjectName = this.categoryToTrackedObject.get(traceCategory);
        return new TsimTrkMessageUAEvent(this.trkApiUa, trackedObjectName, "1.0");
    }

    public int sendMessage(ITrkMessageUAEvent event) {
        return this.trkApiUa.sendMessage((TrkMessageUA)((TrkMessageUAEvent)event));
    }

    public ITrkMessageUALink createNewTrkMessageLink(String parentToName, String parentCycleID, String childToName, String childCycleID) {
        return new TsimTrkMessageUALink(this.trkApiUa, parentToName, parentCycleID, childToName, childCycleID);
    }

    public int sendMessage(ITrkMessageUALink cycleLink) {
        return this.trkApiUa.sendMessage((TrkMessageUA)((TrkMessageUALink)cycleLink));
    }

    public TsimSentinelClient(TextTrkApiPar trkApiParameter) {
        this.trkApiPar = trkApiParameter;
        String boToName = trkApiParameter.getEoTrackedObj();
        String wfToName = trkApiParameter.getWfTrackedObj();
        if (boToName != null && boToName.length() > 0) {
            this.categoryToTrackedObject.put("Ediobject", boToName);
        }
        this.categoryToTrackedObject.put("Workflow", wfToName);
        this.trkApiUa = TsimSentinelClient.getSentinelConn(log, this.trkApiPar);
        this.trkApiActive = true;
    }

    private static TrkApiUA getSentinelConn(Log log, TextTrkApiPar param) {
        TrkApiUA trkApiUa = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getSentinelConn start: " + param));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"getSentinelConn start: ");
        }
        String overFlowFilename = new ActisFile(param.getTrkOvfFilename()).toString();
        trkApiUa = new TrkApiUA(param.getTrkIpAddr(), param.getTrkIpPort());
        int rc = trkApiUa.setOverflowFile(overFlowFilename, (long)param.getTrkOvfFileSize());
        if (rc != 0) {
            log.error((Object)("Cannot set Tracked API overflow file. RC: " + rc));
        }
        trkApiUa.setLocalAddr(param.getTrkLocalAddr());
        trkApiUa.setProductName(param.getTrkProductName());
        if (param.getTrkTrace() > 0) {
            trkApiUa.setUATrace(param.getTrkTrace(), new ActisFile(param.getTrkTrcFilename()).toString());
        }
        log.debug((Object)"getSentinelConn end: ");
        return trkApiUa;
    }

    public boolean isActive() {
        return this.trkApiActive;
    }

    public void stop() {
        this.trkApiUa.stopUA();
        this.trkApiActive = false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TsimSentinelClient: trkApiPar: ");
        buf.append(this.trkApiPar);
        buf.append("\ntrkApiActive: ");
        buf.append(this.trkApiActive);
        buf.append(", trkApiUa:");
        buf.append(this.trkApiUa);
        return buf.toString();
    }

    public String getTrackedObject(ITrkMessageUAEvent event) throws SentinelRouterException {
        throw new SentinelRouterException("Method getTrackedObject is not implemented for TsimSentinelClient.");
    }
}

