/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.builtin;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.builtin.Builtin;
import de.axway.aim.controller.master.builtin.CtrlJobBuiltin;
import de.axway.aim.controller.master.builtin.RedirectException;
import de.axway.aim.controller.master.builtin.UnknownBuiltinException;
import de.axway.aim.controller.master.cfg.CfgException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CtrlJob
extends Builtin {
    private List builtins;
    private String[] ids;

    protected CtrlJob(Attributes<String> attr) throws UnknownBuiltinException {
        block10: {
            this.builtins = new ArrayList();
            String sids = (String)attr.elementAt(0).get();
            if (sids == null) {
                throw new UnknownBuiltinException("no jobid");
            }
            this.ids = sids.split(" *, *");
            if (this.ids.length < 1) {
                throw new UnknownBuiltinException("no jobid");
            }
            attr.remove(0);
            try {
                while (attr.size() > 0) {
                    try {
                        this.builtins.add(CtrlJobBuiltin.create(attr));
                    }
                    catch (UnknownBuiltinException e) {
                        Attribute a = new Attribute("BUILT_IN", (Object)attr.elementAt(0).getName());
                        int attrSize = attr.size();
                        attr.insert(0, a);
                        try {
                            this.builtins.add(Builtin.create(attr));
                        }
                        catch (UnknownBuiltinException ne) {
                            throw e;
                        }
                        if (attrSize != attr.size()) continue;
                        log.warn((Object)("remove attr(stop endless loop): " + attr.elementAt(0)));
                        attr.remove(0);
                    }
                    catch (RedirectException e) {
                        attr.clear();
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            catch (UnknownBuiltinException e) {
                log.error((Object)"CtrlJob", (Throwable)((Object)e));
                if (this.builtins.size() != 0) break block10;
                throw e;
            }
        }
    }

    @Override
    public boolean exec(CtrlBuiltin handler) throws Exception {
        boolean lastRc = true;
        for (int x = 0; x < this.ids.length; ++x) {
            long jobId;
            String id = this.ids[x].trim();
            try {
                jobId = Long.parseLong(id);
            }
            catch (NumberFormatException e) {
                throw new CfgException("unknown jobid: " + this.ids[x].trim());
            }
            for (Object builtin : this.builtins) {
                if (builtin instanceof CtrlJobBuiltin) {
                    lastRc = ((CtrlJobBuiltin)builtin).exec(jobId, handler);
                    continue;
                }
                if (builtin instanceof Builtin) {
                    lastRc = ((Builtin)builtin).exec(handler);
                    continue;
                }
                throw new UnknownBuiltinException("unknown type");
            }
        }
        return lastRc;
    }

    @Override
    public String getRealFc() {
        StringBuffer ret = new StringBuffer();
        ret.append("(CTRL_JOB=");
        for (int x = 0; x < this.ids.length; ++x) {
            if (x > 0) {
                ret.append(',');
            }
            ret.append(this.ids[x]);
        }
        ret.append(')');
        Iterator it = this.builtins.iterator();
        while (it.hasNext()) {
            ret.append(' ');
            Object b = it.next();
            if (b instanceof CtrlJobBuiltin) {
                ret.append(((CtrlJobBuiltin)b).getRealFc());
                continue;
            }
            if (!(b instanceof Builtin)) continue;
            ret.append(((Builtin)b).getRealFc());
        }
        return ret.toString();
    }
}

