/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.builtin;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.builtin.Builtin;
import de.axway.aim.controller.master.builtin.UnknownAttributeException;
import de.axway.aim.controller.master.builtin.UnknownBuiltinException;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.TextCfg;
import java.util.Hashtable;

class SuspendJob
extends Builtin {
    private static Hashtable<String, AttrType> attrTypes = new Hashtable();
    private String ids;
    private String activateAttr = null;
    private long time = 864000L;

    protected SuspendJob(Attributes<String> attr) throws UnknownBuiltinException {
        while (attr.size() > 0) {
            AttrType type = attrTypes.get(attr.elementAt(0).getName());
            if (type == null) {
                return;
            }
            switch (type) {
                case SUSPEND_JOB: {
                    this.ids = (String)attr.elementAt(0).get();
                    break;
                }
                case ACTIVATE_ATTR: {
                    this.activateAttr = (String)attr.elementAt(0).get();
                    break;
                }
                case TIME_UNTIL: {
                    try {
                        this.time = TextCfg.getTime((String)attr.elementAt(0).get());
                        break;
                    }
                    catch (CfgException e) {
                        throw new UnknownBuiltinException(e.getMessage());
                    }
                }
                default: {
                    throw new UnknownAttributeException("SUSPEND_JOB", attr.elementAt(0).getName());
                }
            }
            attr.remove(0);
        }
    }

    @Override
    public boolean exec(CtrlBuiltin handler) throws Exception {
        return handler.suspendJob(this.ids, this.activateAttr, this.time);
    }

    @Override
    public String getRealFc() {
        StringBuilder ret = new StringBuilder();
        ret.append("(SUSPEND_JOB=");
        ret.append(this.ids);
        if (this.activateAttr != null && this.activateAttr.length() > 0) {
            ret.append(") (ACTIVATE_JOB=");
            ret.append(this.activateAttr);
        }
        if (this.time > 0L) {
            ret.append(") (TIME_UNTIL=");
            ret.append(String.format("%02d:%02d:%02d:%02d", this.time / 86400L, this.time % 86400L / 3600L, this.time % 3600L / 60L, this.time % 60L));
        }
        ret.append(')');
        return ret.toString();
    }

    static {
        attrTypes.put("SUSPEND_JOB", AttrType.SUSPEND_JOB);
        attrTypes.put("ACTIVATE_ATTR", AttrType.ACTIVATE_ATTR);
        attrTypes.put("ACTIVATE_JOB", AttrType.ACTIVATE_ATTR);
        attrTypes.put("TIME_UNTIL", AttrType.TIME_UNTIL);
    }

    private static enum AttrType {
        SUSPEND_JOB,
        ACTIVATE_ATTR,
        TIME_UNTIL;

    }
}

