/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.TreeSlave;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.aim.controller.master.cfg.CfgRc;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class CfgFctn {
    private Map<String, CfgFctnEntry> entries = new Hashtable<String, CfgFctnEntry>();
    protected CfgRc cfgRc;

    public Map<String, CfgFctnEntry> getEntries() {
        return this.entries;
    }

    public CfgFctn(ClusterStream ois, CfgRc cfgRc, TreeSlave slaves) throws IOException {
        this.cfgRc = cfgRc;
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            CfgFctnEntry e = new CfgFctnEntry(ois, cfgRc, slaves);
            this.entries.put(e.getName(), e);
        }
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeInt(this.entries.size());
        for (String name : this.entries.keySet()) {
            this.entries.get(name).write(oos);
        }
    }

    public CfgFctn(CfgRc cfgRc) {
        if (cfgRc == null) {
            throw new IllegalArgumentException("cfgrc is null");
        }
        this.cfgRc = cfgRc;
    }

    public CfgFctnEntry getEntry(String name) throws CfgException {
        CfgFctnEntry e = this.entries.get(name);
        if (e == null) {
            throw new CfgException("fctn entry " + name + " not found");
        }
        return e;
    }

    public void newEntry(CfgFctnEntry entry) throws CfgException {
        CfgFctnEntry old = this.entries.put(entry.getName(), entry);
        if (old != null) {
            this.entries.put(old.getName(), old);
            throw new CfgException("fctn entry " + old.getName() + " already exists");
        }
    }
}

