/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.builtin.WriteJoeStat;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgJob;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.tcontrol.NormTimeWindow;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;

public class CfgJSelect {
    protected static Log log = LogFactory.getLog((String)"master.cfg.CfgJSelect");
    private List<Pattern> jselect = new ArrayList<Pattern>();
    private List<String> jselectEntries = new ArrayList<String>();
    private Map<Pattern, CfgJSelectEntry> entries = new Hashtable<Pattern, CfgJSelectEntry>();
    private List<CfgJSelectEntry> timeEntries = new ArrayList<CfgJSelectEntry>();
    protected CfgJob cfgJob = null;
    protected CfgTimeWindow timeWindow;
    private CfgTimeWindow normalizedRefTimewindow = null;
    private Map<String, NormalizedTimewindow> normalizedTimewindowHash = new Hashtable<String, NormalizedTimewindow>();
    private Ediboss ediboss;
    private Object writeSync = new Object();
    private int reader = 0;
    private Object writerWait = new Object();

    public Map<String, NormalizedTimewindow> getNormalizedTimewindow() {
        if (this.normalizedRefTimewindow != this.timeWindow) {
            if (this.timeWindow == null) {
                this.normalizedTimewindowHash = new Hashtable<String, NormalizedTimewindow>();
            } else {
                this.normalizedRefTimewindow = this.timeWindow;
                this.normalizedTimewindowHash = NormTimeWindow.normalize(this.timeWindow);
            }
        }
        return this.normalizedTimewindowHash;
    }

    public CfgJSelect(CfgTimeWindow timeWindow, Ediboss ediboss) {
        this.timeWindow = timeWindow;
        this.ediboss = ediboss;
        this.addHiddenBuiltin();
    }

    public Map<Pattern, CfgJSelectEntry> getEntries() {
        return this.entries;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Pattern p : this.jselect) {
            sb.append(p.toString() + ": \n");
            sb.append(this.entries.get(p).toString() + "\n\n");
        }
        return sb.toString();
    }

    public void setOld() {
        Iterator<CfgJSelectEntry> it = this.entries.values().iterator();
        while (it.hasNext()) {
            it.next().setOld();
        }
        it = this.timeEntries.iterator();
        while (it.hasNext()) {
            it.next().setOld();
        }
    }

    public Ediboss getEdiboss() {
        return this.ediboss;
    }

    public void updateTwCfg(CfgTimeWindow tw) {
        for (CfgJSelectEntry jsl : this.getEntries().values()) {
            try {
                jsl.updateTwCfg(tw);
            }
            catch (CfgException ce) {
                Logbook.getLogbook().error("reload jselect " + jsl.getId() + ": " + ce.getMessage());
            }
        }
        for (CfgJSelectEntry jsl : this.getTimeEntries()) {
            try {
                jsl.updateTwCfg(tw);
            }
            catch (CfgException ce) {
                Logbook.getLogbook().error("reload jselect " + jsl.getId() + ": " + ce.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutable createJob(CtrlEvent evt, JbpmConfiguration conf) throws CfgException, SQLException {
        long start = System.currentTimeMillis();
        IExecutable job = null;
        Object object = this.writeSync;
        synchronized (object) {
            ++this.reader;
        }
        String attr = evt.getAttr(-1);
        if (log.isTraceEnabled()) {
            log.trace((Object)("create job attr: " + attr));
        }
        Iterator<Pattern> it = this.jselect.iterator();
        while (it.hasNext() && job == null) {
            Pattern p = it.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Pattern: " + p.pattern()));
            }
            if (!p.matcher(attr).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(p.pattern() + " matched"));
            }
            if (this.cfgJob != null) {
                job = this.entries.get(p).createJob(evt, this.cfgJob);
                continue;
            }
            job = this.entries.get(p).createJob(evt, conf);
        }
        Object object2 = this.writeSync;
        synchronized (object2) {
            --this.reader;
            if (this.reader == 0) {
                Object object3 = this.writerWait;
                synchronized (object3) {
                    this.writerWait.notify();
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (job == null) {
                log.debug((Object)"createJob end: <null>");
            } else {
                log.debug((Object)("createJob end: " + job.getName()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("createJob end: " + job));
                }
            }
        }
        WorkerThread.addJslTime(System.currentTimeMillis() - start);
        return job;
    }

    protected void newEntry(String attr, CfgJSelectEntry cfg) throws CfgException {
        if (!(cfg.getName() != null && cfg.getName().length() > 0 || cfg.isBuiltIn())) {
            throw new CfgException("JOBN_PAR or BUILTIN not defined, entry ignored");
        }
        if (cfg.isTimeEvent()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("new time entry: " + attr));
            }
            cfg.setAttr(attr);
            cfg.setNum(this.timeEntries.size());
            this.timeEntries.add(cfg);
        } else {
            Pattern p;
            if (log.isDebugEnabled()) {
                log.debug((Object)("new user entry: " + attr));
            }
            Attributes a = new Attributes(attr, Attributes.Type.PAR);
            String sp = a.get(cfg.getEaSignific());
            if (cfg.getEaSignific() > 0 && !sp.endsWith(".*")) {
                sp = sp + "( .*)?";
            }
            try {
                p = Pattern.compile(sp);
            }
            catch (PatternSyntaxException e) {
                throw new CfgException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("new jselect <" + p.pattern() + ">"));
            }
            if (this.jselectEntries.contains(sp)) {
                throw new CfgException("Pattern " + attr + " already in jselect, entry ignored");
            }
            this.entries.put(p, cfg);
            this.jselectEntries.add(sp);
            this.jselect.add(p);
        }
    }

    public List<CfgJSelectEntry> getTimeEntries() {
        return this.timeEntries;
    }

    public CfgJob getCfgJob() {
        return this.cfgJob;
    }

    private void addHiddenBuiltin() {
        log.debug((Object)"addHiddenBuiltin start:");
        CfgJSelectEntry entry = null;
        String name = null;
        try {
            name = "WRITE_JOESTAT";
            entry = new CfgJSelectEntry(null, this.ediboss, -1, null, null);
            entry.setBuiltin(new WriteJoeStat());
            entry.setPrio(600);
            entry.setTimeEvent(true);
            entry.setTPeriode(TextCfg.getTime("05:00"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("addHiddenBuiltin: " + (Object)((Object)entry)));
            }
            this.newEntry("SENDER=CRONTAB RECEIVER=JAVAMASTER", entry);
        }
        catch (Exception e) {
            log.error((Object)("Cannot create hidden system builtin: " + name), (Throwable)e);
        }
        log.debug((Object)"addHiddenBuiltin end:");
    }

    public List<String> getJselectEntries() {
        return this.jselectEntries;
    }
}

