/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import java.util.Hashtable;

public class CfgJob {
    protected CfgTimeWindow timeWindow;
    private Hashtable<String, CfgJobEntry> entries = new Hashtable();

    public CfgJob(CfgTimeWindow timeWindow) {
        this.timeWindow = timeWindow;
    }

    public CfgJobEntry get(String name) {
        return this.entries.get(name);
    }

    public Hashtable<String, CfgJobEntry> getEntries() {
        return this.entries;
    }

    protected CtrlJob createJob(String jobName, Event evt, CfgJSelectEntry jslEntry) throws CfgException {
        if (jobName == null) {
            throw new CfgException("job name not set");
        }
        CfgJobEntry entry = this.entries.get(jobName);
        if (entry == null) {
            throw new CfgException("job " + jobName + " not found");
        }
        return entry.createJob(evt, jslEntry);
    }

    protected void newEntry(CfgJobEntry e) throws CfgException {
        CfgJobEntry old = this.entries.put(e.getName(), e);
        if (old != null) {
            this.entries.put(e.getName(), old);
            throw new CfgException("job " + e.getName() + " already in jobs, ignored");
        }
    }
}

