/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.lib.JobDcl;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.ISequence;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgJobStep;
import de.axway.aim.controller.master.cfg.CfgJobStepParameterReader;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.lockDaemon.LockException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CfgJobEntry
extends JobDcl {
    private static Log log = LogFactory.getLog((String)"master.cfg.CfgJobEntry");
    private List<CfgJobStep> steps = new ArrayList<CfgJobStep>();
    private int removeDelay = 172800;
    private long id = -1L;
    private boolean old = false;
    private int used = 0;
    private DataSource dataSource;
    private ISequence sequence;
    private Object usedSync = new Object();

    public CfgJobEntry(DataSource dataSource, ISequence seq, String name) {
        super(name);
        this.dataSource = dataSource;
        this.sequence = seq;
    }

    public int getStepCount() {
        return this.steps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsed() {
        Object object = this.usedSync;
        synchronized (object) {
            return this.used > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsed(boolean used) {
        Object object = this.usedSync;
        synchronized (object) {
            if (used) {
                ++this.used;
            } else {
                --this.used;
                if (this.used < 0) {
                    throw new IllegalArgumentException("used is now: " + this.used);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("set used(" + this.id + ") " + used + ", now " + this.used));
            }
        }
    }

    public void setOld() {
        this.old = true;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(Log dbLog, Connection con) throws SQLException, LockException, ParameterException {
        if (this.id > 0L) {
            return;
        }
        if (this.old) {
            throw new IllegalArgumentException("cfgjob " + this.id + " is old");
        }
        try {
            this.id = this.sequence.getNextId(this.dataSource);
            String sql = "insert into ctrl_cfgjob (id, removedelay, name) values (?,?,?)";
            try (PreparedStatement stmt = con.prepareStatement(sql);){
                stmt.setLong(1, this.id);
                stmt.setInt(2, this.removeDelay);
                stmt.setString(3, this.getName());
                stmt.executeUpdate();
            }
            Iterator<CfgJobStep> it = this.steps.iterator();
            while (it.hasNext()) {
                it.next().save(con, dbLog, this.id);
            }
            con.commit();
        }
        catch (SQLException e) {
            con.rollback();
            this.id = -1L;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, CfgJobEntry> load(DataSource dataSource, CfgTimeWindow tw, CfgRc cfgRc) throws SQLException, ParameterException {
        Hashtable<Long, CfgJobEntry> ret = new Hashtable<Long, CfgJobEntry>();
        String sql = "select id, removedelay, name from ctrl_cfgjob";
        try (Connection con = dataSource.getConnection();){
            con.setReadOnly(true);
            ResultSet rs = null;
            try (PreparedStatement stmt = con.prepareStatement(sql);){
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        CfgJobEntry je = new CfgJobEntry(dataSource, null, rs.getString(3));
                        je.id = rs.getLong(1);
                        je.removeDelay = rs.getInt(2);
                        je.old = true;
                        ret.put(je.getId(), je);
                    }
                }
                finally {
                    rs.close();
                }
            }
            sql = "select id, name, maxretry, retrydelay, delay, timewindow, maxexectime, assignmode, step, errorclass, rcblog, logical_end from ctrl_cfgjs order by step";
            stmt = con.prepareStatement(sql);
            rs = null;
            CfgJobStepParameterReader parReader = new CfgJobStepParameterReader(con);
            parReader.initialise();
            try {
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        long jsid = rs.getLong(1);
                        CfgJobEntry jobEntry = (CfgJobEntry)((Object)ret.get(jsid));
                        if (jobEntry == null) {
                            throw new SQLException("jsid " + jsid + " not in table");
                        }
                        CfgJobStep step = new CfgJobStep(rs.getString(2), rs.getInt(9));
                        jobEntry.addStep(step);
                        step.setMaxRetry(rs.getInt(3));
                        step.setRetryDelay(rs.getInt(4));
                        step.setDelay(rs.getInt(5));
                        step.setTimeWindow(tw.get(rs.getString(6)));
                        step.setMaxExecTime(rs.getInt(7));
                        step.setAssignModes(rs.getInt(8));
                        step.setErrorClass(rs.getString(10));
                        step.setRcbLog(rs.getInt(11) != 0);
                        step.setLogicalEndFlag(rs.getInt(12) != 0);
                        step.addAllParameter(jsid, cfgRc, parReader);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
                parReader = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CfgJobEntry load(Connection con, CfgRc cfgRc, CfgTimeWindow tw, long id) throws SQLException, ParameterException {
        CfgJobEntry cfgJobEntry;
        ResultSet rs;
        PreparedStatement stmt;
        String sql;
        block10: {
            sql = "select removedelay, name from ctrl_cfgjob where id = ?";
            stmt = con.prepareStatement(sql);
            rs = null;
            try {
                stmt.setLong(1, id);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    cfgJobEntry = new CfgJobEntry(null, null, rs.getString(2));
                    cfgJobEntry.removeDelay = rs.getInt(1);
                    cfgJobEntry.id = id;
                    cfgJobEntry.old = true;
                    break block10;
                }
                throw new SQLException("cfgjob " + id + " not found");
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                stmt.close();
            }
        }
        sql = "select name, maxretry, retrydelay, delay, timewindow, maxexectime, assignmode, step, errorclass, rcblog, logical_end from ctrl_cfgjs where id = ? order by step";
        stmt = con.prepareStatement(sql);
        rs = null;
        CfgJobStepParameterReader parReader = new CfgJobStepParameterReader(con);
        try {
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                CfgJobStep step = new CfgJobStep(rs.getString(1), rs.getInt(8));
                cfgJobEntry.addStep(step);
                step.setMaxRetry(rs.getInt(2));
                step.setRetryDelay(rs.getInt(3));
                step.setDelay(rs.getInt(4));
                step.setTimeWindow(tw.get(rs.getString(5)));
                step.setMaxExecTime(rs.getInt(6));
                step.setAssignModes(rs.getInt(7));
                step.setErrorClass(rs.getString(9));
                step.setRcbLog(rs.getInt(10) != 0);
                step.setLogicalEndFlag(rs.getInt(11) != 0);
                step.addAllParameter(id, cfgRc, parReader);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
            parReader = null;
        }
        return cfgJobEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeId(String sql, Connection con, long id, Log log) throws SQLException {
        try (DebPrepStmt stmt = new DebPrepStmt(con, sql, log);){
            stmt.setLong(1, id);
            stmt.executeUpdate();
        }
    }

    public boolean remove(Connection con) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cfg_job to remove: used=" + this.used + ", old=" + this.old + ", id=" + this.id));
        }
        if (this.isUsed() || !this.old || this.id < 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cfg_job not removed: used: " + this.used + ", old: " + this.old + ", id: " + this.id));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to remove cfg_job with id: " + this.id));
        }
        try {
            CfgJobEntry.removeId("delete from ctrl_cfgjspar where jsid = ?", con, this.id, log);
            CfgJobEntry.removeId("delete from ctrl_cfgjsassign where jsid=?", con, this.id, log);
            CfgJobEntry.removeId("delete from ctrl_cfgjsrcreaction where jsid=?", con, this.id, log);
            CfgJobEntry.removeId("delete from ctrl_cfgjs where id = ?", con, this.id, log);
            CfgJobEntry.removeId("delete from ctrl_cfgjsl where jsid = ?", con, this.id, log);
            CfgJobEntry.removeId("delete from ctrl_cfgjob where id = ?", con, this.id, log);
            con.commit();
        }
        catch (SQLException e) {
            con.rollback();
            log.error((Object)("error on cfgjob remove id " + this.id));
            throw e;
        }
        this.id = -1L;
        return true;
    }

    public void addStep(CfgJobStep js) {
        this.steps.add(js);
    }

    public List<CfgJobStep> getSteps() {
        return this.steps;
    }

    public void setRemoveDelay(int sec) {
        this.removeDelay = sec;
    }

    public int getRemoveDelay() {
        return this.removeDelay;
    }

    public CfgJobStep getJobStep(int step) {
        if (this.steps.size() < step) {
            return null;
        }
        return this.steps.get(step - 1);
    }

    public CtrlJob createJob(Event evt, CfgJSelectEntry jslEntry) throws CfgException {
        CtrlJob job = new CtrlJob(evt, jslEntry);
        if (this.steps.size() < 1) {
            throw new CfgException("job " + job.getName() + " has no jobsteps");
        }
        for (int x = 0; x < this.steps.size(); ++x) {
            try {
                job.addStep(this.steps.get(x).createJobStep(job));
                continue;
            }
            catch (Exception e) {
                CfgException ce = new CfgException("addStep");
                ce.initCause(e);
                throw ce;
            }
        }
        return job;
    }

    public int getUsed() {
        return this.used;
    }
}

