/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.CfgJobStepRcReaction;
import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.lib.JobStepCfg;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJobStepParameterReader;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.cfg.ParameterValue;
import de.axway.aim.controller.master.cfg.RcReactionValue;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.tcontrol.NormTimeWindow;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;

public class CfgJobStep
extends JobStepCfg {
    private static Hashtable<String, Integer> idAssignModes = new Hashtable();
    private boolean seq = false;
    private CfgTimeWindowEntry timeWindow = null;
    private Attributes<String> assign = new Attributes(Attributes.Type.PAR);
    private NormalizedTimewindow normalizedTimewindow;
    private CfgTimeWindowEntry normalizedRefTimeWindow = null;

    public CfgJobStep(String name, int step) {
        super(name, step);
    }

    private void saveAttr(long id, int level, Iterator<Attribute<String>> it, Connection con, Log dbLog) throws SQLException {
        int x = 0;
        try (DebPrepStmt insert = new DebPrepStmt(con, "insert into ctrl_cfgjspar (jsid, step, jslevel, name, value, nr) values (?,?,?,?,?,?)", dbLog);){
            insert.setLong(1, id);
            insert.setInt(2, this.getStep());
            insert.setInt(3, level);
            while (it.hasNext()) {
                Attribute<String> a = it.next();
                insert.setString(4, a.getName());
                insert.setString(5, (String)a.get());
                insert.setInt(6, x);
                insert.executeUpdate();
                ++x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Connection con, Log dbLog, long id) throws SQLException {
        int x;
        String sql = "insert into ctrl_cfgjs (id, step, name, maxretry, retrydelay, delay, timewindow, maxexectime, assignmode, errorclass, rcblog, logical_end)values (?,?,?,?,?,?,?,?,?,?,?,?)";
        try (DebPrepStmt insert = new DebPrepStmt(con, sql, dbLog);){
            insert.setLong(1, id);
            insert.setInt(2, this.getStep());
            insert.setString(3, this.getName(0));
            insert.setInt(4, this.getMaxRetry());
            insert.setInt(5, this.getRetryDelay());
            insert.setInt(6, this.getDelay());
            insert.setString(7, this.timeWindow == null ? "" : this.timeWindow.getName());
            insert.setInt(8, this.getMaxExecTime());
            insert.setInt(9, this.getAssignModes());
            insert.setString(10, this.getErrorClass());
            insert.setInt(11, this.getRcbLog() ? 1 : 0);
            insert.setInt(12, this.getLogicalEndFlag() ? 1 : 0);
            insert.executeUpdate();
        }
        this.saveAttr(id, 0, this.getParIt(), con, dbLog);
        insert = new DebPrepStmt(con, "insert into ctrl_cfgjsrcreaction (jsid, step, nr, rcname, action) values (?,?,?,?,?)", dbLog);
        try {
            insert.setLong(1, id);
            insert.setInt(2, this.getStep());
            x = 0;
            for (CfgRcEntry rce : this.getRclist()) {
                CfgJobStepRcReaction rcr = (CfgJobStepRcReaction)this.getRcClass().get(rce);
                insert.setInt(3, x);
                insert.setString(4, rce.getName());
                insert.setString(5, rcr.getName());
                insert.executeUpdate();
                if (rcr.getPar() != null) {
                    this.saveAttr(id, x + 1, rcr.getParIt(), con, dbLog);
                }
                ++x;
            }
        }
        catch (SQLException e) {
            dbLog.error((Object)("stmt: " + insert.toString()));
            throw e;
        }
        finally {
            insert.close();
        }
        sql = "insert into ctrl_cfgjsassign (jsid, step, nr, name, value) values (?,?,?,?,?)";
        insert = new DebPrepStmt(con, sql, dbLog);
        try {
            insert.setLong(1, id);
            insert.setInt(2, this.getStep());
            x = 0;
            for (Attribute attr : this.assign.get()) {
                insert.setInt(3, x);
                insert.setString(4, attr.getName());
                insert.setString(5, (String)attr.get());
                if (dbLog.isDebugEnabled()) {
                    dbLog.debug((Object)("executeUpdate: " + insert));
                }
                insert.executeUpdate();
                ++x;
            }
        }
        finally {
            insert.close();
        }
    }

    public Attributes getAssign() {
        return this.assign;
    }

    public void addAssign(String name, String val) {
        this.assign.put(new Attribute(name, (Object)val));
    }

    public void addAssign(String par) throws CfgException {
        Attributes as = new Attributes(par);
        Iterator it = as.iterator(0);
        while (it.hasNext()) {
            Attribute a = (Attribute)it.next();
            if (a.getName() == null || a.getName().length() <= 0 || a.get() == null || ((String)a.get()).length() <= 0) continue;
            this.assign.put(a);
        }
    }

    public void addAssignMode(String name) throws CfgException {
        Integer mode = idAssignModes.get(name);
        if (mode == null) {
            throw new CfgException("unknown assign mode " + name);
        }
        this.addAssignMode(mode);
    }

    public void setSeq(boolean seq) {
        this.seq = seq;
    }

    public void setTimeWindow(CfgTimeWindowEntry timeWindow) {
        this.timeWindow = timeWindow;
    }

    public CfgTimeWindowEntry getTimeWindow() {
        return this.timeWindow;
    }

    public NormalizedTimewindow getNormalizedTimewindow() {
        if (this.timeWindow == null) {
            this.normalizedRefTimeWindow = null;
            this.normalizedTimewindow = null;
        } else if (this.normalizedRefTimeWindow != this.timeWindow) {
            this.normalizedRefTimeWindow = this.timeWindow;
            this.normalizedTimewindow = NormTimeWindow.normalizeTimewindowEntry(this.timeWindow);
        }
        return this.normalizedTimewindow;
    }

    public void addRcClass(CfgRcEntry cfgRc, CfgJobStepRcReaction rcReaction) throws CfgException {
        CfgJobStepRcReaction old = this.getRcClass().put(cfgRc, rcReaction);
        if (old != null) {
            this.getRcClass().put(cfgRc, old);
            throw new CfgException(cfgRc.getName() + " already in list, ignored");
        }
        this.getRclist().add(cfgRc);
    }

    public CfgJobStepRcReaction getRcReaction(int rc) {
        CfgRcEntry crc = null;
        Iterator it = this.getRclist().iterator();
        while (it.hasNext() && crc == null) {
            CfgRcEntry rce = (CfgRcEntry)it.next();
            if (!rce.match(rc)) continue;
            crc = rce;
        }
        if (crc != null) {
            return (CfgJobStepRcReaction)this.getRcClass().get(crc);
        }
        return null;
    }

    public CtrlJobStep createJobStep(Job job) throws CfgException {
        CtrlJobStep js = new CtrlJobStep(job, this, this.getStep());
        js.setSeq(this.seq);
        return js;
    }

    protected void addAllParameter(long id, CfgRc cfgRc, CfgJobStepParameterReader parReader) throws SQLException, ParameterException {
        this.addParameter(id, parReader);
        this.addRcReactions(id, cfgRc, parReader);
        this.addAssigns(id, parReader);
    }

    private void addParameter(long jobsId, CfgJobStepParameterReader parReader) throws SQLException {
        List<ParameterValue> entries = parReader.getParameter(jobsId, this.getStep(), 0);
        if (entries != null) {
            for (ParameterValue val : entries) {
                this.addPar(new Attribute(val.name, (Object)(val.value == null ? "" : val.value.intern())));
            }
        }
    }

    public void addRcReactions(long jobsId, CfgRc cfgRc, CfgJobStepParameterReader parReader) throws SQLException, ParameterException {
        List<RcReactionValue> entries = parReader.getRcReaction(jobsId, this.getStep());
        if (entries != null) {
            int level = 0;
            for (RcReactionValue val : entries) {
                ++level;
                try {
                    CfgJobStepRcReaction rcReaction = new CfgJobStepRcReaction(val.value);
                    CfgRcEntry rcEntry = cfgRc.getEntry(val.name);
                    if (rcEntry == null) {
                        throw new CfgException("");
                    }
                    this.addRcClass(rcEntry, rcReaction);
                    List<ParameterValue> parEntries = parReader.getParameter(jobsId, this.getStep(), level);
                    if (parEntries == null) continue;
                    for (ParameterValue parVal : parEntries) {
                        rcReaction.addPar(new Attribute(parVal.name, (Object)(parVal.value == null ? "" : parVal.value.intern())));
                    }
                }
                catch (CfgException e) {
                    Logbook.getLogbook().error("can not find rc class " + val.name + " for rc " + val.value + " in rcclass");
                }
                catch (ParameterException e) {
                    Logbook.getLogbook().error(e.getMessage());
                }
            }
        }
    }

    public void addAssigns(long jobsId, CfgJobStepParameterReader parReader) throws SQLException {
        List<ParameterValue> entries = parReader.getAssign(jobsId, this.getStep());
        if (entries != null) {
            for (ParameterValue val : entries) {
                this.addAssign(val.name.intern(), val.value.intern());
            }
        }
    }

    static {
        idAssignModes.put("RETURN", 8);
        idAssignModes.put("OK", 8);
        idAssignModes.put("RETRY", 2);
        idAssignModes.put("SKIP", 4);
        idAssignModes.put("FAIL", 16);
        idAssignModes.put("EXCEPTION", 1);
        idAssignModes.put("ON_ERROR", 23);
        idAssignModes.put("ON_SUSPEND_JOB", 1024);
        idAssignModes.put("BEFORE_EXEC_ALSO", 4096);
        idAssignModes.put("ALWAYS", 5119);
        idAssignModes.put("BEFORE_EXEC_ONLY", 8192);
    }
}

