/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.cfg.ParameterKey;
import de.axway.aim.controller.master.cfg.ParameterValue;
import de.axway.aim.controller.master.cfg.RcReactionValue;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CfgJobStepParameterReader {
    private static Log log = LogFactory.getLog((String)"master.cfg.CfgJobStepParameterReader");
    Map<ParameterKey, List<ParameterValue>> parameters = null;
    Map<ParameterKey, List<RcReactionValue>> rcReactions = null;
    Map<ParameterKey, List<ParameterValue>> assigns = null;
    Connection connection;
    private static final String SQL_PARAMETER = "select name, value from ctrl_cfgjspar where jsid = ? AND step = ? AND jslevel=? order by nr";
    private static final String SQL_PARAMETERS = "select jsid, step, jslevel, name, value from ctrl_cfgjspar order by nr";
    private static final String SQL_RCREACTION = "select rcname, action from ctrl_cfgjsrcreaction where jsid = ? AND step = ? order by nr";
    private static final String SQL_RCREACTIONS = "select jsid, step, rcname, action from ctrl_cfgjsrcreaction order by nr";
    private static final String SQL_ASSIGN = "select name, value from ctrl_cfgjsassign where jsid = ? AND step = ? order by nr";
    private static final String SQL_ASSIGNS = "select jsid, step, name, value from ctrl_cfgjsassign order by nr";

    public CfgJobStepParameterReader(Connection connection) throws SQLException {
        this.connection = connection;
    }

    public void initialise() throws SQLException {
        this.readParameters();
        this.readRcReactions();
        this.readAssigns();
    }

    public List<ParameterValue> getParameter(long jobsId, int step, int level) throws SQLException {
        if (this.parameters == null) {
            return this.readParameter(jobsId, step, level);
        }
        return this.parameters.get(new ParameterKey(jobsId, step, level));
    }

    public List<RcReactionValue> getRcReaction(long jobsId, int step) throws SQLException {
        if (this.rcReactions == null) {
            return this.readRcReaction(jobsId, step);
        }
        return this.rcReactions.get(new ParameterKey(jobsId, step, 0));
    }

    public List<ParameterValue> getAssign(long jobsId, int step) throws SQLException {
        if (this.assigns == null) {
            return this.readAssign(jobsId, step);
        }
        return this.assigns.get(new ParameterKey(jobsId, step, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readParameters() throws SQLException {
        this.parameters = new HashMap<ParameterKey, List<ParameterValue>>();
        DebPrepStmt stmt = new DebPrepStmt(this.connection, SQL_PARAMETERS, log);
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executeQuery: " + stmt));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                ParameterKey key = new ParameterKey(rs.getLong(1), rs.getInt(2), rs.getInt(3));
                List<ParameterValue> entry = this.parameters.get(key);
                if (entry == null) {
                    entry = new ArrayList<ParameterValue>();
                    this.parameters.put(key, entry);
                }
                entry.add(new ParameterValue(rs.getString(4), rs.getString(5)));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ParameterValue> readParameter(long jobsId, int step, int level) throws SQLException {
        ResultSet rs = null;
        ArrayList<ParameterValue> ret = new ArrayList<ParameterValue>();
        DebPrepStmt parameterStmt = new DebPrepStmt(this.connection, SQL_PARAMETER, log);
        try {
            parameterStmt.setLong(1, jobsId);
            parameterStmt.setInt(2, step);
            parameterStmt.setInt(3, level);
            if (log.isDebugEnabled()) {
                log.debug((Object)("executeQuery: " + parameterStmt));
            }
            rs = parameterStmt.executeQuery();
            while (rs.next()) {
                ret.add(new ParameterValue(rs.getString(1), rs.getString(2)));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            parameterStmt.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRcReactions() throws SQLException {
        DebPrepStmt stmt = new DebPrepStmt(this.connection, SQL_RCREACTIONS, log);
        ResultSet rs = null;
        this.rcReactions = new HashMap<ParameterKey, List<RcReactionValue>>();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executeQuery: " + stmt));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                ParameterKey key = new ParameterKey(rs.getLong(1), rs.getInt(2), 0);
                List<RcReactionValue> entry = this.rcReactions.get(key);
                if (entry == null) {
                    entry = new ArrayList<RcReactionValue>();
                    this.rcReactions.put(key, entry);
                }
                entry.add(new RcReactionValue(rs.getString(3), rs.getString(4)));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RcReactionValue> readRcReaction(long jobsId, int step) throws SQLException {
        ResultSet rs = null;
        ArrayList<RcReactionValue> ret = new ArrayList<RcReactionValue>();
        DebPrepStmt rcreactionStmt = new DebPrepStmt(this.connection, SQL_RCREACTION, log);
        try {
            rcreactionStmt.setLong(1, jobsId);
            rcreactionStmt.setInt(2, step);
            if (log.isDebugEnabled()) {
                log.debug((Object)("executeQuery: " + rcreactionStmt));
            }
            rs = rcreactionStmt.executeQuery();
            while (rs.next()) {
                ret.add(new RcReactionValue(rs.getString(1), rs.getString(2)));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            rcreactionStmt.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAssigns() throws SQLException {
        DebPrepStmt stmt = new DebPrepStmt(this.connection, SQL_ASSIGNS, log);
        ResultSet rs = null;
        this.assigns = new HashMap<ParameterKey, List<ParameterValue>>();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executeQuery: " + stmt));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                ParameterKey key = new ParameterKey(rs.getLong(1), rs.getInt(2), 0);
                List<ParameterValue> entry = this.assigns.get(key);
                if (entry == null) {
                    entry = new ArrayList<ParameterValue>();
                    this.assigns.put(key, entry);
                }
                entry.add(new ParameterValue(rs.getString(3), rs.getString(4)));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ParameterValue> readAssign(long jobsId, int step) throws SQLException {
        ResultSet rs = null;
        ArrayList<ParameterValue> ret = new ArrayList<ParameterValue>();
        DebPrepStmt assignStmt = new DebPrepStmt(this.connection, SQL_ASSIGN, log);
        try {
            assignStmt.setLong(1, jobsId);
            assignStmt.setInt(2, step);
            if (log.isDebugEnabled()) {
                log.debug((Object)("executeQuery: " + assignStmt));
            }
            rs = assignStmt.executeQuery();
            while (rs.next()) {
                ret.add(new ParameterValue(rs.getString(1), rs.getString(2)));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            assignStmt.close();
        }
        return ret;
    }
}

