/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class CfgRc {
    private List<CfgRcEntry> entries = new ArrayList<CfgRcEntry>();
    private Hashtable<String, CfgRcEntry> values = new Hashtable();

    public CfgRc() {
    }

    public CfgRc(ClusterStream ois) throws IOException {
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            CfgRcEntry rce = new CfgRcEntry(ois);
            this.values.put(rce.getName(), rce);
            this.entries.add(rce);
        }
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeInt(this.entries.size());
        Iterator<CfgRcEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            it.next().write(oos);
        }
    }

    public List<CfgRcEntry> getEntries() {
        return this.entries;
    }

    public void newEntry(String name, CfgRcEntry value) throws CfgException {
        if (this.values.put(name.toUpperCase(), value) != null) {
            throw new CfgException("rc_class " + name + " already exists");
        }
        this.entries.add(value);
    }

    public CfgRcEntry getValue(String name) {
        return this.values.get(name.toUpperCase());
    }

    public CfgRcEntry getEntry(String name) {
        return this.values.get(name);
    }

    public CfgRcEntry getEntry(int value) {
        for (CfgRcEntry entry : this.entries) {
            if (!entry.match(value)) continue;
            return entry;
        }
        return null;
    }
}

