/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgTimeOneDate;
import de.axway.aim.controller.master.cfg.CfgTimeTime;
import de.axway.aim.controller.master.cfg.CfgTimeWeekday;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CfgTimeDate {
    private List<CfgTimeTime> time = new ArrayList<CfgTimeTime>();
    private CfgTimeOneDate date;
    private CfgTimeWeekday weekday = null;
    protected Log log = LogFactory.getLog((String)"master.cfg.CfgTimeDate");

    public List<CfgTimeTime> getTime() {
        return this.time;
    }

    public CfgTimeOneDate getDate() {
        return this.date;
    }

    public CfgTimeWeekday getWeekday() {
        if (this.weekday == null) {
            return CfgTimeWeekday.getDefault();
        }
        return this.weekday;
    }

    public CfgTimeDate(ClusterStream ois) throws IOException {
        this.date = new CfgTimeOneDate(ois);
        this.weekday = new CfgTimeWeekday(ois);
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            this.time.add(new CfgTimeTime(ois));
        }
    }

    public void write(ClusterStream oos) throws IOException {
        this.date.write(oos);
        this.weekday.write(oos);
        oos.writeInt(this.time.size());
        Iterator<CfgTimeTime> it = this.time.iterator();
        while (it.hasNext()) {
            it.next().write(oos);
        }
    }

    public CfgTimeDate(CfgTimeOneDate date) {
        this.date = date;
    }

    public void setWeekday(CfgTimeWeekday weekday) throws CfgException {
        this.weekday = weekday;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("DATE=");
        ret.append(this.date.toString() + '\n');
        ret.append("\tWEEKDAY=");
        ret.append(this.weekday.toString());
        Iterator<CfgTimeTime> it = this.time.iterator();
        while (it.hasNext()) {
            ret.append("\t\tTIME=");
            ret.append(it.next().toString());
            ret.append('\n');
        }
        ret.append('\n');
        return ret.toString();
    }

    public void addTime(CfgTimeTime time) {
        this.time.add(time);
    }

    public boolean isAllowed() {
        return this.date.isAllowed();
    }
}

