/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.cfg.Time;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CfgTimeTime {
    Calendar calendar = GregorianCalendar.getInstance();
    private boolean isAllowed = true;
    private Time to = null;
    private Time from = null;

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public Date getFrom() {
        this.calendar.clear();
        return this.from.getDate(this.calendar.getTime());
    }

    public Date getTo() {
        this.calendar.clear();
        return this.to.getDate(this.calendar.getTime());
    }

    public CfgTimeTime(ClusterStream ois) throws IOException {
        this.isAllowed = ois.readBoolean();
        if (ois.readBoolean()) {
            this.to = new Time(ois);
        }
        if (ois.readBoolean()) {
            this.from = new Time(ois);
        }
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeBoolean(this.isAllowed);
        if (this.to == null) {
            oos.writeBoolean(false);
        } else {
            oos.writeBoolean(true);
            this.to.write(oos);
        }
        if (this.from == null) {
            oos.writeBoolean(false);
        } else {
            oos.writeBoolean(true);
            this.from.write(oos);
        }
    }

    public CfgTimeTime(String param) throws CfgException {
        String[] ft;
        String p = param.trim();
        if (p.charAt(0) == '!') {
            this.isAllowed = false;
            p = p.substring(1);
        }
        if ((ft = p.split("-")).length > 2) {
            throw new CfgException("unknown format: " + param);
        }
        if (ft.length > 1) {
            this.to = CfgTimeTime.getValue(ft[1]);
        }
        if (ft.length <= 0) {
            throw new CfgException("unknown format: " + param);
        }
        this.from = CfgTimeTime.getValue(ft[0]);
    }

    public Date nearestEnabled(Date requestDate) {
        if (this.isAllowed) {
            if (this.from != null && this.from.after(requestDate)) {
                return this.from.getDate(requestDate);
            }
            if (this.to != null && this.to.before(requestDate)) {
                Calendar c = GregorianCalendar.getInstance();
                c.setTime(requestDate);
                c.add(6, 1);
                return this.from.getDate(c.getTime());
            }
            return requestDate;
        }
        if (this.from != null && this.from.after(requestDate)) {
            return requestDate;
        }
        if (this.to == null) {
            return null;
        }
        if (this.to.before(requestDate)) {
            return requestDate;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(this.to.getDate(requestDate));
        calendar.add(13, 1);
        calendar.set(14, 0);
        Date next = calendar.getTime();
        calendar.setTime(requestDate);
        int dof1 = calendar.get(6);
        calendar.setTime(next);
        int dof2 = calendar.get(6);
        if (dof1 == dof2) {
            return next;
        }
        return null;
    }

    private static Time getValue(String value) throws CfgException {
        String[] val = value.split(":");
        if (val.length != 3) {
            throw new CfgException("unknown format: " + value);
        }
        return new Time(TextCfg.getInt(val[0].trim()), TextCfg.getInt(val[1].trim()), TextCfg.getInt(val[2].trim()));
    }

    public String toString() {
        return (!this.isAllowed ? "!" : "") + this.from.toString() + "-" + this.to.toString();
    }
}

