/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.TextCfg;
import java.io.IOException;

public class CfgTimeWeekday {
    private static final int HDOC_SUNDAY_INDEX = 0;
    private static final int HDOC_MONDAY_INDEX = 1;
    private static final int HDOC_TUESDAY_INDEX = 2;
    private static final int HDOC_WEDNESDAY_INDEX = 3;
    private static final int HDOC_THURSDAY_INDEX = 4;
    private static final int HDOC_FRIDAY_INDEX = 5;
    private static final int HDOC_SATURDAY_INDEX = 6;
    private static final int WEEKDAY_COUNT = 7;
    private boolean[] days = new boolean[]{false, false, false, false, false, false, false};
    private static CfgTimeWeekday defaultWeekday;

    public boolean[] getDays() {
        return this.days;
    }

    public CfgTimeWeekday(ClusterStream ois) throws IOException {
        byte b = ois.readByte();
        int c = 1;
        for (int x = 0; x < this.days.length; ++x) {
            if ((b & c) == c) {
                this.days[x] = true;
            }
            c = (byte)(c << 1);
        }
    }

    public void write(ClusterStream oos) throws IOException {
        int b = 0;
        int c = 1;
        for (int x = 0; x < this.days.length; ++x) {
            if (this.days[x]) {
                b = (byte)(b | c);
            }
            c = (byte)(c << 1);
        }
        oos.writeByte(b);
    }

    public CfgTimeWeekday(String param) throws CfgException {
        if (param == null) {
            for (int i = 0; i < this.days.length; ++i) {
                this.days[i] = true;
            }
            return;
        }
        String[] days = param.trim().split("[ \t]+");
        for (int x = 0; x < days.length; ++x) {
            int len = days[x].length();
            if (len < 1 || len > 2) {
                throw new CfgException("Unknown format for weekday: '" + param + "'");
            }
            boolean active = true;
            int day = -1;
            if (days[x].charAt(0) == '!') {
                active = false;
                day = TextCfg.getInt(days[x].substring(1));
            } else {
                day = TextCfg.getInt(days[x]);
            }
            if (day < 0 || day > 6) {
                throw new CfgException("Unknown format for weekday: '" + param + "'");
            }
            this.days[day] = active;
        }
    }

    public static CfgTimeWeekday getDefault() {
        return defaultWeekday;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("CfgTimeWeekday: ");
        for (int x = 0; x < 7; ++x) {
            ret.append(this.days[x] ? "" + x : "!" + x);
            ret.append(' ');
        }
        ret.append('\n');
        return ret.toString();
    }

    static {
        try {
            defaultWeekday = new CfgTimeWeekday((String)null);
        }
        catch (CfgException cfgException) {
            // empty catch block
        }
    }
}

