/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class CfgTimeWindow {
    private Hashtable<String, CfgTimeWindowEntry> tw = new Hashtable();

    public CfgTimeWindow() {
    }

    public CfgTimeWindow(ClusterStream ois) throws IOException {
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            CfgTimeWindowEntry twe = new CfgTimeWindowEntry(ois);
            this.tw.put(twe.getName().toUpperCase().intern(), twe);
        }
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeInt(this.tw.size());
        Iterator<CfgTimeWindowEntry> it = this.tw.values().iterator();
        while (it.hasNext()) {
            it.next().write(oos);
        }
    }

    protected void newEntry(CfgTimeWindowEntry entry) throws CfgException {
        String name = entry.getName().toUpperCase().intern();
        CfgTimeWindowEntry old = this.tw.put(name, entry);
        if (old != null) {
            this.tw.put(name, old);
            throw new CfgException("timewindow " + entry.getName() + " already exists");
        }
    }

    public CfgTimeWindowEntry get(String name) {
        if (name == null) {
            return null;
        }
        return this.tw.get(name.toUpperCase());
    }

    public Enumeration<String> keys() {
        return this.tw.keys();
    }
}

