/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.TreeSlave;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctn;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.aim.controller.master.cfg.CfgFctnRcReaction;
import de.axway.aim.controller.master.cfg.CfgFctnSequence;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgSlaveEntry;
import de.axway.aim.controller.master.cfg.DummyLogbook;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextCfgFctn
extends CfgFctn {
    private static Log log = LogFactory.getLog((String)"master.cfg.TextCfgFctn");
    private static Map<String, Ident> identifier = new Hashtable<String, Ident>();
    private File file;
    private ILogbook logbook = null;
    private TreeSlave slaves = null;
    private List<CfgSlaveEntry> slaveEntryList = null;

    public TextCfgFctn(TreeSlave slaves, CfgRc cfgRc, File file) throws IOException, CfgException {
        super(cfgRc);
        this.file = file;
        this.slaves = slaves;
        this.logbook = Logbook.getLogbook();
        this.load();
    }

    public TextCfgFctn(List<CfgSlaveEntry> slaveEntryList, CfgRc cfgRc, File file) throws IOException {
        super(cfgRc);
        this.file = file;
        this.slaveEntryList = slaveEntryList;
        this.logbook = new DummyLogbook();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        File fctnLock = TextCfg.checkSetLock(this.logbook, log, Ediboss.fctnPath + ".lock");
        this.logbook.info("reading " + this.file.getAbsolutePath());
        if (!this.file.canRead()) {
            if (fctnLock.exists()) {
                fctnLock.delete();
            }
            throw new IOException("Can not read " + this.file.getAbsolutePath());
        }
        int count = 0;
        int lineNo = 0;
        CfgFctnEntry entry = null;
        CfgFctnSequence seq = null;
        CfgRcEntry inRcclass = null;
        CfgFctnRcReaction rcReaction = null;
        CfgRcEntry excInRcclass = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));){
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                String tLine = line.trim();
                if (tLine.length() > 0 && !tLine.startsWith("#")) {
                    String paramName = TextCfg.getParamName(tLine);
                    if (paramName == null) {
                        this.logbook.error("no parameter found, line " + lineNo);
                    } else {
                        Ident id = identifier.get(paramName);
                        String param = null;
                        String uParam = null;
                        try {
                            param = TextCfg.getParam(tLine);
                            uParam = param.toUpperCase();
                        }
                        catch (CfgException e) {
                            this.logbook.warning(e.getMessage() + " in line " + lineNo + ", ignored");
                        }
                        if (id == null) {
                            this.logbook.warning("unknown parameter " + tLine + " in line " + lineNo);
                        } else if (param != null && param.length() > 0) {
                            if (id != Ident.FCTNCLASS && entry == null) {
                                this.logbook.error("no FCTNCLASS defined, line: " + lineNo);
                            } else {
                                boolean seqParameter = false;
                                if (seq != null) {
                                    seqParameter = true;
                                    switch (id) {
                                        case FCTNCALL: {
                                            try {
                                                seq.setCmd(param);
                                            }
                                            catch (CfgException e) {
                                                this.logbook.error("" + e.getMessage() + ", ignored, line " + lineNo);
                                            }
                                            break;
                                        }
                                        case GROUP_NAME: {
                                            seq.setGroupName(param);
                                            break;
                                        }
                                        case MAX_CALLS: {
                                            seq.setMaxCalls(TextCfg.getInt(param));
                                            break;
                                        }
                                        case SLAVE: {
                                            String[] slave = param.split(",");
                                            for (int x = 0; x < slave.length; ++x) {
                                                String sl = slave[x].trim();
                                                if (sl.equals("$(BOMSLAVE)")) {
                                                    seq.setBomSlave();
                                                    continue;
                                                }
                                                if (this.slaves != null) {
                                                    SlaveHandler sh = this.slaves.get(sl);
                                                    if (sh == null) {
                                                        this.logbook.error("slave " + sl + " not found, ignored, line " + lineNo);
                                                        continue;
                                                    }
                                                    seq.addSlave(sh);
                                                    continue;
                                                }
                                                Iterator<CfgSlaveEntry> slaveEntryIterator = this.slaveEntryList.iterator();
                                                boolean isSlaveEntryFound = false;
                                                while (slaveEntryIterator.hasNext()) {
                                                    CfgSlaveEntry slaveEntry = slaveEntryIterator.next();
                                                    if (!slaveEntry.getName().equals(sl)) continue;
                                                    seq.addSlaveEntry(slaveEntry);
                                                    isSlaveEntryFound = true;
                                                    break;
                                                }
                                                if (isSlaveEntryFound) continue;
                                                this.logbook.error("slave " + sl + " not found, ignored, line " + lineNo);
                                            }
                                            break;
                                        }
                                        case MAX_RETRY: {
                                            seq.setMaxRetry(TextCfg.getInt(param));
                                            break;
                                        }
                                        case PRIO: {
                                            seq.setPrio(TextCfg.getInt(param));
                                            break;
                                        }
                                        case IN_RCCLASS: {
                                            inRcclass = this.cfgRc.getValue(uParam);
                                            if (inRcclass == null) {
                                                this.logbook.error("rcc_name " + uParam + " not defined, ignored, line " + lineNo);
                                            }
                                            rcReaction = null;
                                            break;
                                        }
                                        case RCC_REACTION: {
                                            if (inRcclass == null) {
                                                this.logbook.error("no in_rcclass defined, line: " + lineNo);
                                                break;
                                            }
                                            try {
                                                rcReaction = new CfgFctnRcReaction(param);
                                                seq.addRcClass(inRcclass, rcReaction);
                                            }
                                            catch (CfgException e) {
                                                this.logbook.error(e.getMessage() + ", line " + lineNo);
                                                rcReaction = null;
                                            }
                                            inRcclass = null;
                                            break;
                                        }
                                        case EXC_IN_RCCLASS: {
                                            if (rcReaction == null) {
                                                this.logbook.error("no rcc_reaction defined, line " + lineNo);
                                                break;
                                            }
                                            excInRcclass = this.cfgRc.getValue(uParam);
                                            if (excInRcclass != null) break;
                                            this.logbook.error("exc_in_rcclass " + uParam + " not defined, ignored, line " + lineNo);
                                            break;
                                        }
                                        case EXC_RCC_REACTION: {
                                            if (excInRcclass == null) {
                                                this.logbook.error("no exc_in_rcclass defined, line " + lineNo);
                                                break;
                                            }
                                            try {
                                                rcReaction.addReaction(excInRcclass, param);
                                            }
                                            catch (CfgException e) {
                                                this.logbook.error(e.getMessage() + ", line " + lineNo);
                                            }
                                            excInRcclass = null;
                                            break;
                                        }
                                        case CREATE_RESULT: 
                                        case USED_CF: 
                                        case MAXSLAVELOAD: 
                                        case NICE_PRIO: {
                                            break;
                                        }
                                        case HOSTID: {
                                            this.logbook.warning("parameter " + tLine + " in line " + lineNo + " not implemented");
                                            break;
                                        }
                                        default: {
                                            seqParameter = false;
                                        }
                                    }
                                }
                                if (!seqParameter) {
                                    switch (id) {
                                        case FCTNCLASS: {
                                            entry = new CfgFctnEntry(param, this.slaves, this.cfgRc);
                                            try {
                                                this.newEntry(entry);
                                                ++count;
                                            }
                                            catch (CfgException e) {
                                                entry = null;
                                                this.logbook.error(e.getMessage() + ", ignored, line " + lineNo);
                                            }
                                            seq = null;
                                            break;
                                        }
                                        case SEQUENCE: {
                                            seq = new CfgFctnSequence(param, this.cfgRc);
                                            entry.newSeq(seq);
                                            inRcclass = null;
                                            rcReaction = null;
                                            excInRcclass = null;
                                            break;
                                        }
                                        case COMMENT: {
                                            break;
                                        }
                                        default: {
                                            this.logbook.warning("parameter " + tLine + " in line " + lineNo + " not for FctnClass");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                line = br.readLine();
            }
        }
        if (fctnLock.exists()) {
            fctnLock.delete();
        }
        this.logbook.info(this.file.getName() + ": " + count + " entries");
    }

    static {
        identifier.put("FCTNCLASS", Ident.FCTNCLASS);
        identifier.put("COMMENT", Ident.COMMENT);
        identifier.put("SEQUENCE", Ident.SEQUENCE);
        identifier.put("USED_CF", Ident.USED_CF);
        identifier.put("FCTNCALL", Ident.FCTNCALL);
        identifier.put("SLAVE", Ident.SLAVE);
        identifier.put("MAX_CALLS", Ident.MAX_CALLS);
        identifier.put("GROUP_NAME", Ident.GROUP_NAME);
        identifier.put("MAXSLAVELOAD", Ident.MAXSLAVELOAD);
        identifier.put("NICE_PRIO", Ident.NICE_PRIO);
        identifier.put("MAX_RETRY", Ident.MAX_RETRY);
        identifier.put("CREATE_RESULT", Ident.CREATE_RESULT);
        identifier.put("HOSTID", Ident.HOSTID);
        identifier.put("IN_RCCLASS", Ident.IN_RCCLASS);
        identifier.put("RCC_REACTION", Ident.RCC_REACTION);
        identifier.put("EXC_IN_RCCLASS", Ident.EXC_IN_RCCLASS);
        identifier.put("EXC_RCC_REACTION", Ident.EXC_RCC_REACTION);
        identifier.put("PRIO", Ident.PRIO);
    }

    private static enum Ident {
        FCTNCLASS,
        COMMENT,
        SEQUENCE,
        USED_CF,
        FCTNCALL,
        SLAVE,
        MAX_CALLS,
        GROUP_NAME,
        MAXSLAVELOAD,
        NICE_PRIO,
        MAX_RETRY,
        CREATE_RESULT,
        HOSTID,
        IN_RCCLASS,
        RCC_REACTION,
        EXC_IN_RCCLASS,
        EXC_RCC_REACTION,
        PRIO;

    }
}

