/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.CfgJobStepRcReaction;
import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.ISequence;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJob;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.cfg.CfgJobStep;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextCfgJob
extends CfgJob {
    private static final String VERSION = "$Id: TextCfgJob.java 230684 2017-06-15 09:57:05Z stirca $";
    private static Log log = LogFactory.getLog((String)"master.cfg.TextCfgJob");
    private static Map<String, Ident> identifier = new Hashtable<String, Ident>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextCfgJob(File file, CfgTimeWindow timeWindow, CfgRc cfgRc, int globalRemoveDelay, DataSource dataSource, ISequence jsSequence) throws IOException {
        super(timeWindow);
        ILogbook logbook = Logbook.getLogbook();
        File jobLock = TextCfg.checkSetLock(logbook, log, Ediboss.jobPath + ".lock");
        logbook.info("Reading " + file.getAbsolutePath());
        if (!file.canRead()) {
            if (jobLock.exists()) {
                jobLock.delete();
            }
            throw new IOException("Cannot read " + file.getAbsolutePath());
        }
        int count = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            int lineNo = 0;
            CfgJobEntry entry = null;
            CfgJobStep jsEntry = null;
            CfgRcEntry inRcClass = null;
            String rcbErrorClass = null;
            String logEndStr = "";
            boolean rcbMsg = false;
            boolean logEndSet = false;
            int i = -1;
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                String tLine = line.trim();
                if (tLine.length() > 0 && !tLine.startsWith("#")) {
                    String paramName = TextCfg.getParamName(tLine);
                    if (paramName == null) {
                        logbook.error("No parameter found, line " + lineNo + ".");
                    } else {
                        Ident id = identifier.get(TextCfg.getParamName(tLine));
                        String param = null;
                        String uParam = null;
                        try {
                            param = TextCfg.getParam(tLine);
                            uParam = param.toUpperCase();
                        }
                        catch (CfgException e) {
                            logbook.warning(e.getMessage() + " in line " + lineNo + ", ignored");
                        }
                        if (id == null) {
                            if (param.length() > 0) {
                                logbook.warning("Unknown parameter " + tLine + " in line " + lineNo + ".");
                            }
                        } else if (param != null && param.length() > 0) {
                            if (id != Ident.JOBNAME && entry == null) {
                                logbook.error("No JOBNAME defined, line: " + lineNo + ".");
                            } else {
                                boolean jsParameter = false;
                                if (jsEntry != null) {
                                    jsParameter = true;
                                    switch (id) {
                                        case MAX_RETRY: {
                                            int maxRetry = TextCfg.getInt(param);
                                            if (maxRetry > Short.MAX_VALUE) {
                                                logbook.warning("MAX_RETRY max 32676, line " + lineNo + ".");
                                                maxRetry = Short.MAX_VALUE;
                                            }
                                            jsEntry.setMaxRetry(maxRetry);
                                            break;
                                        }
                                        case STEP_SEQU: {
                                            jsEntry.setSeq(uParam.equals("Y"));
                                            break;
                                        }
                                        case RETRY_DELAY: {
                                            try {
                                                jsEntry.setRetryDelay(TextCfg.getTime(param));
                                            }
                                            catch (CfgException e) {
                                                logbook.error(e.getMessage() + ", ignored, line " + lineNo + ".");
                                            }
                                            break;
                                        }
                                        case TIME_DELAY: {
                                            try {
                                                jsEntry.setDelay(TextCfg.getTime(param));
                                            }
                                            catch (CfgException e) {
                                                logbook.error(e.getMessage() + ", ignored, line " + lineNo + ".");
                                            }
                                            break;
                                        }
                                        case TIME_WINDOW: {
                                            CfgTimeWindowEntry tw = timeWindow.get(uParam);
                                            if (tw == null) {
                                                logbook.error("Timewindow " + uParam + " not found, ignored.");
                                                break;
                                            }
                                            jsEntry.setTimeWindow(tw);
                                            break;
                                        }
                                        case BACKGROUND: {
                                            break;
                                        }
                                        case MAX_EXEC_TIME: {
                                            try {
                                                int time = TextCfg.getTime(param);
                                                if (time <= 0) break;
                                                jsEntry.setMaxExecTime(time);
                                            }
                                            catch (CfgException e) {
                                                logbook.error(e.getMessage() + ", ignored, line " + lineNo + ".");
                                            }
                                            break;
                                        }
                                        case ASSIGN_MODE: {
                                            String[] a = param.split(" +");
                                            for (int x = 0; x < a.length; ++x) {
                                                try {
                                                    jsEntry.addAssignMode(a[x]);
                                                    continue;
                                                }
                                                catch (CfgException e) {
                                                    logbook.error(e.getMessage() + ", ignored, line " + lineNo + ".");
                                                }
                                            }
                                            break;
                                        }
                                        case IN_RCCLASS: {
                                            inRcClass = cfgRc.getValue(uParam);
                                            if (inRcClass != null) break;
                                            logbook.error("rcc_name " + uParam + " not defined, ignored, line " + lineNo + ".");
                                            break;
                                        }
                                        case RCC_REACTION: {
                                            if (inRcClass == null) {
                                                logbook.error("in_rcclass not defined, ignore rcc_reaction.");
                                                break;
                                            }
                                            try {
                                                jsEntry.addRcClass(inRcClass, new CfgJobStepRcReaction(param));
                                            }
                                            catch (ParameterException e) {
                                                logbook.error(e.getMessage() + ", ignored, line " + lineNo);
                                            }
                                            break;
                                        }
                                        case ASSIGN: {
                                            try {
                                                jsEntry.addAssign(param);
                                            }
                                            catch (CfgException e) {
                                                logbook.error("ASSIGN: " + e.getMessage() + ", ignored, line " + lineNo + ".");
                                            }
                                            break;
                                        }
                                        case ERROR_CLASS: {
                                            rcbErrorClass = param.trim();
                                            if (rcbErrorClass.length() > 32) {
                                                logbook.warning("ERROR_CLASS: " + rcbErrorClass + " too long (max 32), line " + lineNo + ".");
                                                rcbErrorClass = rcbErrorClass.substring(0, 32);
                                            }
                                            jsEntry.setErrorClass(rcbErrorClass);
                                            break;
                                        }
                                        case HOSTID: {
                                            logbook.warning("Parameter " + tLine + " in line " + lineNo + " not implemented.");
                                            break;
                                        }
                                        case HC_DIRECTION: {
                                            break;
                                        }
                                        case APPL_MESSG: {
                                            String[] applMsgDecls = uParam.split("\\s");
                                            for (i = 0; i < applMsgDecls.length; ++i) {
                                                if (!applMsgDecls[i].toUpperCase().equals("RCBLOG=Y")) continue;
                                                jsEntry.setRcbLog(true);
                                            }
                                            break;
                                        }
                                        case LOGICAL_END: {
                                            logEndStr = param.trim();
                                            if (logEndStr.toUpperCase().equals("Y")) {
                                                jsEntry.setLogicalEndFlag(true);
                                                logEndSet = true;
                                                if (!log.isDebugEnabled()) break;
                                                log.info((Object)("LOGICAL_END found: " + entry.getName() + "/" + jsEntry.getStep() + ":" + jsEntry.getName(0)));
                                                break;
                                            }
                                            if (logEndStr.toUpperCase().equals("N")) {
                                                jsEntry.setLogicalEndFlag(false);
                                                if (!log.isDebugEnabled()) break;
                                                log.debug((Object)("LOGICAL_END NO-Flag found: " + entry.getName() + "/" + jsEntry.getStep() + ":" + jsEntry.getName(0)));
                                                break;
                                            }
                                            log.warn((Object)("Wrong value for parameter LOGICAL_END found: '" + param + "', line: " + lineNo + "."));
                                            logbook.warning("Wrong value for parameter LOGICAL_END found: '" + param + "', line: " + lineNo + ".");
                                            jsEntry.setLogicalEndFlag(false);
                                            break;
                                        }
                                        default: {
                                            jsParameter = false;
                                        }
                                    }
                                    if (id != Ident.IN_RCCLASS) {
                                        inRcClass = null;
                                    }
                                }
                                if (!jsParameter) {
                                    switch (id) {
                                        case JOBNAME: {
                                            if (jsEntry != null && !logEndSet) {
                                                jsEntry.setLogicalEndFlag(true);
                                                if (log.isDebugEnabled()) {
                                                    String entryName = entry == null ? "no entry name" : entry.getName();
                                                    log.debug((Object)("LOGICAL_END default: " + entryName + "/" + jsEntry.getStep() + ":" + jsEntry.getName(0)));
                                                }
                                            }
                                            logEndSet = false;
                                            entry = new CfgJobEntry(dataSource, jsSequence, param);
                                            inRcClass = null;
                                            if (globalRemoveDelay >= 0) {
                                                entry.setRemoveDelay(globalRemoveDelay);
                                            }
                                            try {
                                                this.newEntry(entry);
                                                jsEntry = null;
                                                ++count;
                                            }
                                            catch (CfgException e) {
                                                logbook.error(e.getMessage() + ", ignored, line " + lineNo + ".");
                                                entry = null;
                                            }
                                            break;
                                        }
                                        case WAIT_REMOVE_JOB: {
                                            try {
                                                entry.setRemoveDelay(TextCfg.getTime(param));
                                            }
                                            catch (CfgException e) {
                                                logbook.error(e.getMessage() + " in line " + lineNo);
                                            }
                                            break;
                                        }
                                        case JOBSTEP: {
                                            jsEntry = new CfgJobStep(param, entry.getStepCount() + 1);
                                            entry.addStep(jsEntry);
                                            break;
                                        }
                                        case PUBLISHED_AS_WS: 
                                        case PARAM_FORMAL: 
                                        case EVENT_TRIGG: 
                                        case USED_CF: 
                                        case COMMENT: 
                                        case WSS_AUTHENTICATION: 
                                        case WSS_SIGNATURE: 
                                        case WSS_TIMESTAMP: 
                                        case WS_NAME: 
                                        case WS_PARAMETERS: 
                                        case SOAP_VERSION: 
                                        case WSS_TS_TIME_TO_LIVE: {
                                            break;
                                        }
                                        default: {
                                            logbook.warning("Parameter " + tLine + " in line " + lineNo + " not for Job.");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                line = br.readLine();
            }
            if (jsEntry != null && !logEndSet) {
                jsEntry.setLogicalEndFlag(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LOGICAL_END default: " + entry.getName() + "/" + jsEntry.getStep() + ":" + jsEntry.getName(0)));
                }
            }
            logEndSet = false;
        }
        if (jobLock.exists()) {
            jobLock.delete();
        }
        logbook.info(file.getName() + ": " + count + " entries");
    }

    static {
        identifier.put("JOBNAME", Ident.JOBNAME);
        identifier.put("PARAM_FORMAL", Ident.PARAM_FORMAL);
        identifier.put("USED_CF", Ident.USED_CF);
        identifier.put("EVENT_TRIGG", Ident.EVENT_TRIGG);
        identifier.put("WAIT_REMOVE_JOB", Ident.WAIT_REMOVE_JOB);
        identifier.put("F_COMMENT", Ident.COMMENT);
        identifier.put("G_COMMENT", Ident.COMMENT);
        identifier.put("E_COMMENT", Ident.COMMENT);
        identifier.put("COMMENT", Ident.COMMENT);
        identifier.put("PUBLISHED_AS_WS", Ident.PUBLISHED_AS_WS);
        identifier.put("WS_NAME", Ident.WS_NAME);
        identifier.put("WS_PARAMETERS", Ident.WS_PARAMETERS);
        identifier.put("WSS_TIMESTAMP", Ident.WSS_TIMESTAMP);
        identifier.put("WSS_SIGNATURE", Ident.WSS_SIGNATURE);
        identifier.put("WSS_AUTHENTICATION", Ident.WSS_AUTHENTICATION);
        identifier.put("WSS_TS_TIME_TO_LIVE", Ident.WSS_TS_TIME_TO_LIVE);
        identifier.put("SOAP_VERSION", Ident.SOAP_VERSION);
        identifier.put("JOBSTEP", Ident.JOBSTEP);
        identifier.put("APPL_MESSG", Ident.APPL_MESSG);
        identifier.put("ERROR_CLASS", Ident.ERROR_CLASS);
        identifier.put("ASSIGN", Ident.ASSIGN);
        identifier.put("ASSIGN_MODE", Ident.ASSIGN_MODE);
        identifier.put("BACKGROUND", Ident.BACKGROUND);
        identifier.put("MAX_RETRY", Ident.MAX_RETRY);
        identifier.put("RETRY_DELAY", Ident.RETRY_DELAY);
        identifier.put("MAX_EXEC_TIME", Ident.MAX_EXEC_TIME);
        identifier.put("STEP_SEQU", Ident.STEP_SEQU);
        identifier.put("TIME_DELAY", Ident.TIME_DELAY);
        identifier.put("TIME_WINDOW", Ident.TIME_WINDOW);
        identifier.put("HOSTID", Ident.HOSTID);
        identifier.put("IN_RCCLASS", Ident.IN_RCCLASS);
        identifier.put("RCC_REACTION", Ident.RCC_REACTION);
        identifier.put("HC_DIRECTION", Ident.HC_DIRECTION);
        identifier.put("LOGICAL_END", Ident.LOGICAL_END);
    }

    private static enum Ident {
        JOBNAME,
        PARAM_FORMAL,
        USED_CF,
        EVENT_TRIGG,
        WAIT_REMOVE_JOB,
        COMMENT,
        PUBLISHED_AS_WS,
        WS_NAME,
        WS_PARAMETERS,
        WSS_TIMESTAMP,
        WSS_SIGNATURE,
        WSS_AUTHENTICATION,
        WSS_TS_TIME_TO_LIVE,
        SOAP_VERSION,
        JOBSTEP,
        APPL_MESSG,
        ERROR_CLASS,
        ASSIGN,
        ASSIGN_MODE,
        BACKGROUND,
        MAX_RETRY,
        RETRY_DELAY,
        MAX_EXEC_TIME,
        STEP_SEQU,
        TIME_DELAY,
        TIME_WINDOW,
        HOSTID,
        IN_RCCLASS,
        RCC_REACTION,
        HC_DIRECTION,
        LOGICAL_END;

    }
}

