/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgSlave;
import de.axway.aim.controller.master.cfg.CfgSlaveEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextCfgSlave
extends CfgSlave {
    private static Log log = LogFactory.getLog((String)"master.cfg.TextCfgSlave");
    public static Map<String, CtrlSlave.Type> type = new Hashtable<String, CtrlSlave.Type>();
    public static Map<String, CtrlSlave.ConnectionType> connectionType;
    private static Map<String, Ident> identifier;
    private File file;

    public TextCfgSlave(File file) throws IOException {
        this.file = file;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        ILogbook logbook = Logbook.getLogbook();
        File slaveLock = TextCfg.checkSetLock(logbook, log, Ediboss.slavePath + ".lock");
        logbook.info("reading " + this.file.getAbsolutePath());
        if (!this.file.canRead()) {
            if (slaveLock.exists()) {
                slaveLock.delete();
            }
            throw new IOException("Can not read " + this.file.getAbsolutePath());
        }
        int count = 0;
        int lineNo = 0;
        CfgSlaveEntry entry = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));){
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                String tLine = line.trim();
                if (tLine.length() > 0 && !tLine.startsWith("#")) {
                    String paramName = TextCfg.getParamName(tLine);
                    if (paramName == null) {
                        logbook.error("no parameter found, line " + lineNo);
                    } else {
                        Ident id = identifier.get(TextCfg.getParamName(tLine));
                        String param = null;
                        String uParam = null;
                        try {
                            param = TextCfg.getParam(tLine);
                            uParam = param.toUpperCase();
                        }
                        catch (CfgException e) {
                            logbook.warning(e.getMessage() + " in line " + lineNo + ", ignored");
                        }
                        if (id == null) {
                            logbook.warning("unknown parameter " + tLine + " in line " + lineNo);
                        } else if (param != null) {
                            if (id != Ident.SLAVE_NAME && entry == null) {
                                logbook.error("no SLAVE_NAME defined, line: " + lineNo);
                            } else {
                                switch (id) {
                                    case SLAVE_NAME: {
                                        entry = new CfgSlaveEntry(param);
                                        this.newEntry(entry);
                                        ++count;
                                        break;
                                    }
                                    case IP_PORT: {
                                        String p = param;
                                        int i = p.indexOf(47);
                                        if (i > 0) {
                                            p = p.substring(0, i);
                                        }
                                        entry.setPort(TextCfg.getInt(p));
                                        break;
                                    }
                                    case HOST_NAME: {
                                        entry.setHost(param);
                                        break;
                                    }
                                    case MAX_PROCESSES: {
                                        entry.setMax(TextCfg.getInt(param));
                                        break;
                                    }
                                    case CONNECTION: {
                                        CtrlSlave.ConnectionType ct = connectionType.get(uParam);
                                        if (ct == null) {
                                            logbook.error("unknown connection type: " + uParam + ", ignored, line " + lineNo);
                                            break;
                                        }
                                        entry.setConnection(ct);
                                        break;
                                    }
                                    case COMMENT: {
                                        break;
                                    }
                                    case SLAVE_TYPE: {
                                        if (uParam.length() <= 0) break;
                                        CtrlSlave.Type t = type.get(uParam);
                                        if (t == null) {
                                            logbook.error("unknown type: " + uParam + ", ignored, line " + lineNo);
                                            break;
                                        }
                                        entry.setType(t);
                                        break;
                                    }
                                    case FH_PERMANENT: {
                                        try {
                                            entry.setFhPermanent(TextCfg.getBool(uParam));
                                        }
                                        catch (CfgException e) {
                                            logbook.error("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + entry.fhPermanent() + " as default.");
                                        }
                                        break;
                                    }
                                    case SRC_ADDRESS: {
                                        entry.setSrcAddress(param);
                                        break;
                                    }
                                    default: {
                                        logbook.warning("parameter " + tLine + " in line " + lineNo + " not implemented");
                                    }
                                }
                            }
                        }
                    }
                }
                line = br.readLine();
            }
        }
        if (slaveLock.exists()) {
            slaveLock.delete();
        }
        logbook.info(this.file.getName() + ": " + count + " entries");
    }

    static {
        type.put("SLAVE", CtrlSlave.Type.SLAVE);
        type.put("BOMSLAVE", CtrlSlave.Type.BOMSLAVE);
        connectionType = new Hashtable<String, CtrlSlave.ConnectionType>();
        connectionType.put("LOGPROT", CtrlSlave.ConnectionType.LOGPROT);
        connectionType.put("CLIENTCONNECTION", CtrlSlave.ConnectionType.CLIENTCONNECTION);
        identifier = new Hashtable<String, Ident>();
        identifier.put("SLAVE_NAME", Ident.SLAVE_NAME);
        identifier.put("IP_PORT", Ident.IP_PORT);
        identifier.put("HOST_NAME", Ident.HOST_NAME);
        identifier.put("MAX_PROCESSES", Ident.MAX_PROCESSES);
        identifier.put("COMMENT", Ident.COMMENT);
        identifier.put("CONNECTION", Ident.CONNECTION);
        identifier.put("SLAVE_TYPE", Ident.SLAVE_TYPE);
        identifier.put("FH_PERMANENT", Ident.FH_PERMANENT);
        identifier.put("SRC_ADDRESS", Ident.SRC_ADDRESS);
    }

    private static enum Ident {
        SLAVE_NAME,
        IP_PORT,
        HOST_NAME,
        MAX_PROCESSES,
        COMMENT,
        CONNECTION,
        SLAVE_TYPE,
        FH_PERMANENT,
        SRC_ADDRESS;

    }
}

