/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.cfg.TrkApiPar;
import de.axway.lib.util.ActisFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextTrkApiPar
extends TrkApiPar {
    private static Map<String, Ident> id = new Hashtable<String, Ident>();

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("\nTRKTHROWEX: ");
        out.append(this.getTrkThrowEx());
        out.append("\nTRKPRODUCTNAME: ");
        out.append(this.getTrkProductName());
        out.append("\nTRKLOCALADD: ");
        out.append(this.getTrkLocalAddr());
        out.append("\nTRKTNAME: ");
        out.append(this.getTrkOvfFilename());
        out.append("\nTRKTSIZE: ");
        out.append(this.getTrkOvfFileSize());
        out.append("\nTRKIPADDR: ");
        out.append(this.getTrkIpAddr());
        out.append("\nTRKIPPORT: ");
        out.append(this.getTrkIpPort());
        out.append("\nTRKIPADDR_BKUP: ");
        out.append(this.getTrkIpAddr2());
        out.append("\nTRKIPPORT_BKUP: ");
        out.append(this.getTrkIpPort2());
        out.append("\nTRKTRACE: ");
        out.append(this.getTrkTrace());
        out.append("\nTRKTRCFILE: ");
        out.append(this.getTrkTrcFilename());
        out.append("\nON_INIT_ALL_JS: ");
        out.append(this.getOnInitAllJs());
        out.append("\nWF_TRACKED_OBJECT: ");
        out.append(this.getWfTrackedObj());
        out.append("\nEO_TRACKED_OBJECT: ");
        out.append(this.getEoTrackedObj());
        out.append("\nJAVA_SENTINEL_CLIENT: ");
        out.append(this.getJavaSentinelClient());
        return out.toString();
    }

    public TextTrkApiPar(String filename) throws IOException {
        Log log = LogFactory.getLog((String)"master.cfg.TrkApiPar");
        try {
            if (this.notSet(filename)) {
                return;
            }
            this.load(filename, log);
        }
        catch (IOException e) {
            log.error((Object)("Cannot read sentinel parameters file: " + filename), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String filename, Log log) throws IOException {
        String paramName = null;
        Ident ident = null;
        String value = null;
        String sfile = null;
        String textLine = null;
        File file = null;
        BufferedReader br = null;
        int lineNo = 0;
        log.info((Object)("reading " + filename));
        if (filename == null || filename.length() <= 0) {
            throw new IOException("No filename defined!");
        }
        sfile = new ActisFile(filename, 1).toString();
        if (sfile == null || sfile.length() <= 0) {
            throw new IOException("No ACTIS file: " + filename);
        }
        file = new File(sfile);
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                this.setMyStorageName("trkapipath", sfile);
            }
            catch (Exception e) {
                log.error((Object)"Cannot store trkapipath parameter:", (Throwable)e);
            }
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("trkapipar line " + lineNo + ": " + line));
                }
                if ((textLine = line.trim()).length() > 0 && !textLine.startsWith("#")) {
                    paramName = TextCfg.getParamName(textLine);
                    if (paramName == null) {
                        log.error((Object)("No parameter found, line " + lineNo));
                    } else {
                        ident = id.get(paramName);
                        value = null;
                        try {
                            value = TextCfg.getParam(textLine);
                            value = TextCfg.trimCutComment(value);
                        }
                        catch (CfgException e) {
                            log.warn((Object)(e.getMessage() + " in line " + lineNo + ", ignored"));
                        }
                        if (ident == null || value == null) {
                            if (log.isWarnEnabled()) {
                                log.warn((Object)("Unknown parameter <" + textLine + "> in line " + lineNo));
                            }
                        } else {
                            try {
                                switch (ident) {
                                    case TRKTHROWEX: {
                                        this.setTrkThrowEx(paramName, value);
                                        break;
                                    }
                                    case TRKPRODUCTNAME: {
                                        this.setTrkProductName(paramName, value);
                                        break;
                                    }
                                    case TRKLOCALADDR: {
                                        this.setTrkLocalAddr(paramName, value);
                                        break;
                                    }
                                    case TRKTNAME: {
                                        this.setTrkOvfFilename(paramName, value);
                                        break;
                                    }
                                    case TRKTSIZE: {
                                        this.setTrkOvfFileSize(paramName, value);
                                        break;
                                    }
                                    case TRKIPADDR: {
                                        this.setTrkIpAddr(paramName, value);
                                        break;
                                    }
                                    case TRKIPPORT: {
                                        this.setTrkIpPort(paramName, value);
                                        break;
                                    }
                                    case TRKIPADDR_BKUP: {
                                        this.setTrkIpAddr2(paramName, value);
                                        break;
                                    }
                                    case TRKIPPORT_BKUP: {
                                        this.setTrkIpPort2(paramName, value);
                                        break;
                                    }
                                    case TRKTRACE: {
                                        this.setTrkTrace(paramName, value);
                                        break;
                                    }
                                    case TRKTRCFILE: {
                                        this.setTrkTrcFilename(paramName, value);
                                        break;
                                    }
                                    case ON_INIT_ALL_JS: {
                                        this.setOnInitAllJs(paramName, value);
                                        break;
                                    }
                                    case WF_TRACKED_OBJECT: {
                                        this.setWfTrackedObj(paramName, value);
                                        break;
                                    }
                                    case EO_TRACKED_OBJECT: {
                                        this.setEoTrackedObj(paramName, value);
                                        break;
                                    }
                                    case JAVA_SENTINEL_CLIENT: {
                                        this.setJavaSentinelClient(paramName, value);
                                        break;
                                    }
                                    default: {
                                        log.warn((Object)("Unknown identifier: " + (Object)((Object)ident) + " in line " + line + ", ignored"));
                                        break;
                                    }
                                }
                            }
                            catch (Exception fuck) {
                                log.error((Object)("Cannot read parameter value: " + fuck));
                            }
                        }
                    }
                } else if (log.isTraceEnabled()) {
                    log.warn((Object)"Skip line!");
                }
                line = br.readLine();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (Exception e) {
                    log.error((Object)("Cannot close " + sfile), (Throwable)e);
                }
            }
        }
    }

    static {
        id.put("TRKTHROWEX", Ident.TRKTHROWEX);
        id.put("TRKPRODUCTNAME", Ident.TRKPRODUCTNAME);
        id.put("TRKLOCALADDR", Ident.TRKLOCALADDR);
        id.put("TRKTNAME", Ident.TRKTNAME);
        id.put("TRKTSIZE", Ident.TRKTSIZE);
        id.put("TRKIPADDR", Ident.TRKIPADDR);
        id.put("TRKIPPORT", Ident.TRKIPPORT);
        id.put("TRKIPADDR_BKUP", Ident.TRKIPADDR_BKUP);
        id.put("TRKIPPORT_BKUP", Ident.TRKIPPORT_BKUP);
        id.put("TRKTRACE", Ident.TRKTRACE);
        id.put("TRKTRCFILE", Ident.TRKTRCFILE);
        id.put("ON_INIT_ALL_JS", Ident.ON_INIT_ALL_JS);
        id.put("WF_TRACKED_OBJECT", Ident.WF_TRACKED_OBJECT);
        id.put("EO_TRACKED_OBJECT", Ident.EO_TRACKED_OBJECT);
        id.put("JAVA_SENTINEL_CLIENT", Ident.JAVA_SENTINEL_CLIENT);
    }

    private static enum Ident {
        TRKTHROWEX,
        TRKPRODUCTNAME,
        TRKLOCALADDR,
        TRKTNAME,
        TRKIPADDR,
        TRKIPPORT,
        TRKIPADDR_BKUP,
        TRKIPPORT_BKUP,
        TRKTRACE,
        TRKTRCFILE,
        ON_INIT_ALL_JS,
        WF_TRACKED_OBJECT,
        EO_TRACKED_OBJECT,
        TRKTSIZE,
        JAVA_SENTINEL_CLIENT;

    }
}

